/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;

public class Animation {
    final String name;
    private final Array<Timeline> timelines;
    private float duration;

    public Animation(String name, Array<Timeline> timelines, float duration) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (timelines == null) {
            throw new IllegalArgumentException("timelines cannot be null.");
        }
        this.name = name;
        this.timelines = timelines;
        this.duration = duration;
    }

    public Array<Timeline> getTimelines() {
        return this.timelines;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void apply(Skeleton skeleton, float time, boolean loop) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (loop && this.duration != 0.0f) {
            time %= this.duration;
        }
        Array<Timeline> timelines = this.timelines;
        int i = 0;
        int n = timelines.size;
        while (i < n) {
            timelines.get(i).apply(skeleton, time, 1.0f);
            ++i;
        }
    }

    public void mix(Skeleton skeleton, float time, boolean loop, float alpha) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (loop && this.duration != 0.0f) {
            time %= this.duration;
        }
        Array<Timeline> timelines = this.timelines;
        int i = 0;
        int n = timelines.size;
        while (i < n) {
            timelines.get(i).apply(skeleton, time, alpha);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static int binarySearch(float[] values, float target, int step) {
        int low = 0;
        int high = values.length / step - 2;
        if (high == 0) {
            return step;
        }
        int current = high >>> 1;
        while (true) {
            if (values[(current + 1) * step] <= target) {
                low = current + 1;
            } else {
                high = current;
            }
            if (low == high) {
                return (low + 1) * step;
            }
            current = low + high >>> 1;
        }
    }

    static int linearSearch(float[] values, float target, int step) {
        int i = 0;
        int last = values.length - step;
        while (i <= last) {
            if (values[i] > target) {
                return i;
            }
            i += step;
        }
        return -1;
    }

    public static class AttachmentTimeline
    implements Timeline {
        private int slotIndex;
        private final float[] frames;
        private final String[] attachmentNames;

        public AttachmentTimeline(int frameCount) {
            this.frames = new float[frameCount];
            this.attachmentNames = new String[frameCount];
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setSlotIndex(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public String[] getAttachmentNames() {
            return this.attachmentNames;
        }

        public void setFrame(int frameIndex, float time, String attachmentName) {
            this.frames[frameIndex] = time;
            this.attachmentNames[frameIndex] = attachmentName;
        }

        @Override
        public void apply(Skeleton skeleton, float time, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            int frameIndex = time >= frames[frames.length - 1] ? frames.length - 1 : Animation.binarySearch(frames, time, 1) - 1;
            String attachmentName = this.attachmentNames[frameIndex];
            skeleton.slots.get(this.slotIndex).setAttachment(attachmentName == null ? null : skeleton.getAttachment(this.slotIndex, attachmentName));
        }
    }

    public static class ColorTimeline
    extends CurveTimeline {
        private static final int LAST_FRAME_TIME = -5;
        private static final int FRAME_R = 1;
        private static final int FRAME_G = 2;
        private static final int FRAME_B = 3;
        private static final int FRAME_A = 4;
        private int slotIndex;
        private final float[] frames;

        public ColorTimeline(int frameCount) {
            super(frameCount);
            this.frames = new float[frameCount * 5];
        }

        public void setSlotIndex(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int frameIndex, float time, float r, float g, float b, float a) {
            this.frames[frameIndex *= 5] = time;
            this.frames[frameIndex + 1] = r;
            this.frames[frameIndex + 2] = g;
            this.frames[frameIndex + 3] = b;
            this.frames[frameIndex + 4] = a;
        }

        @Override
        public void apply(Skeleton skeleton, float time, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            Color color = skeleton.slots.get((int)this.slotIndex).color;
            if (time >= frames[frames.length - 5]) {
                int i = frames.length - 1;
                float r = frames[i - 3];
                float g = frames[i - 2];
                float b = frames[i - 1];
                float a = frames[i];
                color.set(r, g, b, a);
                return;
            }
            int frameIndex = Animation.binarySearch(frames, time, 5);
            float lastFrameR = frames[frameIndex - 4];
            float lastFrameG = frames[frameIndex - 3];
            float lastFrameB = frames[frameIndex - 2];
            float lastFrameA = frames[frameIndex - 1];
            float frameTime = frames[frameIndex];
            float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex + -5] - frameTime), 0.0f, 1.0f);
            percent = this.getCurvePercent(frameIndex / 5 - 1, percent);
            float r = lastFrameR + (frames[frameIndex + 1] - lastFrameR) * percent;
            float g = lastFrameG + (frames[frameIndex + 2] - lastFrameG) * percent;
            float b = lastFrameB + (frames[frameIndex + 3] - lastFrameB) * percent;
            float a = lastFrameA + (frames[frameIndex + 4] - lastFrameA) * percent;
            if (alpha < 1.0f) {
                color.add((r - color.r) * alpha, (g - color.g) * alpha, (b - color.b) * alpha, (a - color.a) * alpha);
            } else {
                color.set(r, g, b, a);
            }
        }
    }

    public static abstract class CurveTimeline
    implements Timeline {
        public static final float LINEAR = 0.0f;
        public static final float STEPPED = -1.0f;
        public static final float BEZIER = -2.0f;
        private static final int BEZIER_SEGMENTS = 10;
        private final float[] curves;

        public CurveTimeline(int frameCount) {
            this.curves = new float[(frameCount - 1) * 6];
        }

        public int getFrameCount() {
            return this.curves.length / 6 + 1;
        }

        public void setLinear(int frameIndex) {
            this.curves[frameIndex * 6] = 0.0f;
        }

        public void setStepped(int frameIndex) {
            this.curves[frameIndex * 6] = -1.0f;
        }

        public float getCurveType(int frameIndex) {
            int index = frameIndex * 6;
            if (index == this.curves.length) {
                return 0.0f;
            }
            float type = this.curves[index];
            if (type == 0.0f) {
                return 0.0f;
            }
            if (type == -1.0f) {
                return -1.0f;
            }
            return -2.0f;
        }

        public void setCurve(int frameIndex, float cx1, float cy1, float cx2, float cy2) {
            float subdiv_step = 0.1f;
            float subdiv_step2 = subdiv_step * subdiv_step;
            float subdiv_step3 = subdiv_step2 * subdiv_step;
            float pre1 = 3.0f * subdiv_step;
            float pre2 = 3.0f * subdiv_step2;
            float pre4 = 6.0f * subdiv_step2;
            float pre5 = 6.0f * subdiv_step3;
            float tmp1x = -cx1 * 2.0f + cx2;
            float tmp1y = -cy1 * 2.0f + cy2;
            float tmp2x = (cx1 - cx2) * 3.0f + 1.0f;
            float tmp2y = (cy1 - cy2) * 3.0f + 1.0f;
            int i = frameIndex * 6;
            float[] curves = this.curves;
            curves[i] = cx1 * pre1 + tmp1x * pre2 + tmp2x * subdiv_step3;
            curves[i + 1] = cy1 * pre1 + tmp1y * pre2 + tmp2y * subdiv_step3;
            curves[i + 2] = tmp1x * pre4 + tmp2x * pre5;
            curves[i + 3] = tmp1y * pre4 + tmp2y * pre5;
            curves[i + 4] = tmp2x * pre5;
            curves[i + 5] = tmp2y * pre5;
        }

        public float getCurvePercent(int frameIndex, float percent) {
            float[] curves = this.curves;
            int curveIndex = frameIndex * 6;
            float dfx = curves[curveIndex];
            if (dfx == 0.0f) {
                return percent;
            }
            if (dfx == -1.0f) {
                return 0.0f;
            }
            float dfy = curves[curveIndex + 1];
            float ddfx = curves[curveIndex + 2];
            float ddfy = curves[curveIndex + 3];
            float dddfx = curves[curveIndex + 4];
            float dddfy = curves[curveIndex + 5];
            float x = dfx;
            float y = dfy;
            int i = 8;
            while (true) {
                if (x >= percent) {
                    float lastX = x - dfx;
                    float lastY = y - dfy;
                    return lastY + (y - lastY) * (percent - lastX) / (x - lastX);
                }
                if (i == 0) break;
                --i;
                x += (dfx += (ddfx += dddfx));
                y += (dfy += (ddfy += dddfy));
            }
            return y + (1.0f - y) * (percent - x) / (1.0f - x);
        }
    }

    public static class RotateTimeline
    extends CurveTimeline {
        private static final int LAST_FRAME_TIME = -2;
        private static final int FRAME_VALUE = 1;
        private int boneIndex;
        private final float[] frames;

        public RotateTimeline(int frameCount) {
            super(frameCount);
            this.frames = new float[frameCount * 2];
        }

        public void setBoneIndex(int boneIndex) {
            this.boneIndex = boneIndex;
        }

        public int getBoneIndex() {
            return this.boneIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int frameIndex, float time, float angle) {
            this.frames[frameIndex *= 2] = time;
            this.frames[frameIndex + 1] = angle;
        }

        @Override
        public void apply(Skeleton skeleton, float time, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (time >= frames[frames.length - 2]) {
                float amount = bone.data.rotation + frames[frames.length - 1] - bone.rotation;
                while (amount > 180.0f) {
                    amount -= 360.0f;
                }
                while (amount < -180.0f) {
                    amount += 360.0f;
                }
                bone.rotation += amount * alpha;
                return;
            }
            int frameIndex = Animation.binarySearch(frames, time, 2);
            float lastFrameValue = frames[frameIndex - 1];
            float frameTime = frames[frameIndex];
            float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex + -2] - frameTime), 0.0f, 1.0f);
            percent = this.getCurvePercent(frameIndex / 2 - 1, percent);
            float amount = frames[frameIndex + 1] - lastFrameValue;
            while (amount > 180.0f) {
                amount -= 360.0f;
            }
            while (amount < -180.0f) {
                amount += 360.0f;
            }
            amount = bone.data.rotation + (lastFrameValue + amount * percent) - bone.rotation;
            while (amount > 180.0f) {
                amount -= 360.0f;
            }
            while (amount < -180.0f) {
                amount += 360.0f;
            }
            bone.rotation += amount * alpha;
        }
    }

    public static class ScaleTimeline
    extends TranslateTimeline {
        public ScaleTimeline(int frameCount) {
            super(frameCount);
        }

        @Override
        public void apply(Skeleton skeleton, float time, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (time >= frames[frames.length - 3]) {
                bone.scaleX += (bone.data.scaleX - 1.0f + frames[frames.length - 2] - bone.scaleX) * alpha;
                bone.scaleY += (bone.data.scaleY - 1.0f + frames[frames.length - 1] - bone.scaleY) * alpha;
                return;
            }
            int frameIndex = Animation.binarySearch(frames, time, 3);
            float lastFrameX = frames[frameIndex - 2];
            float lastFrameY = frames[frameIndex - 1];
            float frameTime = frames[frameIndex];
            float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex + -3] - frameTime), 0.0f, 1.0f);
            percent = this.getCurvePercent(frameIndex / 3 - 1, percent);
            bone.scaleX += (bone.data.scaleX - 1.0f + lastFrameX + (frames[frameIndex + 1] - lastFrameX) * percent - bone.scaleX) * alpha;
            bone.scaleY += (bone.data.scaleY - 1.0f + lastFrameY + (frames[frameIndex + 2] - lastFrameY) * percent - bone.scaleY) * alpha;
        }
    }

    public static interface Timeline {
        public void apply(Skeleton var1, float var2, float var3);
    }

    public static class TranslateTimeline
    extends CurveTimeline {
        static final int LAST_FRAME_TIME = -3;
        static final int FRAME_X = 1;
        static final int FRAME_Y = 2;
        int boneIndex;
        final float[] frames;

        public TranslateTimeline(int frameCount) {
            super(frameCount);
            this.frames = new float[frameCount * 3];
        }

        public void setBoneIndex(int boneIndex) {
            this.boneIndex = boneIndex;
        }

        public int getBoneIndex() {
            return this.boneIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int frameIndex, float time, float x, float y) {
            this.frames[frameIndex *= 3] = time;
            this.frames[frameIndex + 1] = x;
            this.frames[frameIndex + 2] = y;
        }

        @Override
        public void apply(Skeleton skeleton, float time, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (time >= frames[frames.length - 3]) {
                bone.x += (bone.data.x + frames[frames.length - 2] - bone.x) * alpha;
                bone.y += (bone.data.y + frames[frames.length - 1] - bone.y) * alpha;
                return;
            }
            int frameIndex = Animation.binarySearch(frames, time, 3);
            float lastFrameX = frames[frameIndex - 2];
            float lastFrameY = frames[frameIndex - 1];
            float frameTime = frames[frameIndex];
            float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex + -3] - frameTime), 0.0f, 1.0f);
            percent = this.getCurvePercent(frameIndex / 3 - 1, percent);
            bone.x += (bone.data.x + lastFrameX + (frames[frameIndex + 1] - lastFrameX) * percent - bone.x) * alpha;
            bone.y += (bone.data.y + lastFrameY + (frames[frameIndex + 2] - lastFrameY) * percent - bone.y) * alpha;
        }
    }
}

