/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SharedLibraryLoader {
    public static boolean isWindows = System.getProperty("os.name").contains("Windows");
    public static boolean isLinux = System.getProperty("os.name").contains("Linux");
    public static boolean isMac = System.getProperty("os.name").contains("Mac");
    public static boolean isIos = false;
    public static boolean isAndroid = false;
    public static boolean is64Bit = System.getProperty("os.arch").equals("amd64");
    private static HashSet<String> loadedLibraries;
    private String nativesJar;

    public SharedLibraryLoader() {
    }

    public SharedLibraryLoader(String nativesJar) {
        this.nativesJar = nativesJar;
    }

    public String crc(InputStream input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[4096];
        try {
            int length;
            while ((length = input.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (Exception ex) {
            try {
                input.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return Long.toString(crc.getValue());
    }

    public String mapLibraryName(String libraryName) {
        if (isWindows) {
            return libraryName + (is64Bit ? "64.dll" : ".dll");
        }
        if (isLinux) {
            return "lib" + libraryName + (is64Bit ? "64.so" : ".so");
        }
        if (isMac) {
            return "lib" + libraryName + ".dylib";
        }
        return libraryName;
    }

    public synchronized void load(String libraryName) {
        if (isIos) {
            return;
        }
        if (loadedLibraries.contains(libraryName = this.mapLibraryName(libraryName))) {
            return;
        }
        try {
            if (isAndroid) {
                System.loadLibrary(libraryName);
            } else {
                System.load(this.extractFile(libraryName, null).getAbsolutePath());
            }
        }
        catch (Throwable ex) {
            throw new GdxRuntimeException("Couldn't load shared library '" + libraryName + "' for target: " + System.getProperty("os.name") + (is64Bit ? ", 64-bit" : ", 32-bit"), ex);
        }
        loadedLibraries.add(libraryName);
    }

    private InputStream readFile(String path) {
        if (this.nativesJar == null) {
            InputStream input = SharedLibraryLoader.class.getResourceAsStream("/" + path);
            if (input == null) {
                throw new GdxRuntimeException("Unable to read file for extraction: " + path);
            }
            return input;
        }
        try {
            ZipFile file = new ZipFile(this.nativesJar);
            ZipEntry entry = file.getEntry(path);
            if (entry == null) {
                throw new GdxRuntimeException("Couldn't find '" + path + "' in JAR: " + this.nativesJar);
            }
            return file.getInputStream(entry);
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading '" + path + "' in JAR: " + this.nativesJar, ex);
        }
    }

    public File extractFile(String sourcePath, String dirName) throws IOException {
        try {
            String sourceCrc = this.crc(this.readFile(sourcePath));
            if (dirName == null) {
                dirName = sourceCrc;
            }
            File extractedDir = new File(System.getProperty("java.io.tmpdir") + "/libgdx" + System.getProperty("user.name") + "/" + dirName);
            File extractedFile = new File(extractedDir, new File(sourcePath).getName());
            String extractedCrc = null;
            if (extractedFile.exists()) {
                try {
                    extractedCrc = this.crc(new FileInputStream(extractedFile));
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
            if (extractedCrc == null || !extractedCrc.equals(sourceCrc)) {
                try {
                    int length;
                    InputStream input = this.readFile(sourcePath);
                    extractedDir.mkdirs();
                    FileOutputStream output = new FileOutputStream(extractedFile);
                    byte[] buffer = new byte[4096];
                    while ((length = input.read(buffer)) != -1) {
                        output.write(buffer, 0, length);
                    }
                    input.close();
                    output.close();
                }
                catch (IOException ex) {
                    throw new GdxRuntimeException("Error extracting file: " + sourcePath, ex);
                }
            }
            return extractedFile;
        }
        catch (RuntimeException ex) {
            File file = new File(System.getProperty("java.library.path"), sourcePath);
            if (file.exists()) {
                return file;
            }
            throw ex;
        }
    }

    static {
        String vm = System.getProperty("java.vm.name");
        if (vm != null && vm.contains("Dalvik")) {
            isAndroid = true;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
        if (!(isAndroid || isWindows || isLinux || isMac)) {
            isIos = true;
            is64Bit = false;
        }
        loadedLibraries = new HashSet();
    }
}

