/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EarClippingTriangulator {
    private static final int CONCAVE = -1;
    private static final int TANGENTIAL = 0;
    private static final int CONVEX = 1;
    private List<Vector2> vertices;
    private int vertexCount;
    private int[] vertexTypes;
    private List<Vector2> triangles;

    public List<Vector2> computeTriangles(List<Vector2> polygon) {
        this.vertices = new ArrayList<Vector2>(polygon.size());
        this.vertices.addAll(polygon);
        this.vertexCount = this.vertices.size();
        if (!this.areVerticesClockwise()) {
            Collections.reverse(this.vertices);
        }
        this.vertexTypes = new int[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            this.vertexTypes[i] = this.classifyVertex(i);
        }
        this.triangles = new ArrayList<Vector2>(3 * Math.max(0, this.vertexCount - 2));
        while (this.vertexCount > 3) {
            int earTipIndex = this.findEarTip();
            this.cutEarTip(earTipIndex);
            int previousIndex = this.computePreviousIndex(earTipIndex);
            int nextIndex = earTipIndex == this.vertexCount ? 0 : earTipIndex;
            this.vertexTypes[previousIndex] = this.classifyVertex(previousIndex);
            this.vertexTypes[nextIndex] = this.classifyVertex(nextIndex);
        }
        if (this.vertexCount == 3) {
            this.triangles.addAll(this.vertices);
        }
        List<Vector2> result = this.triangles;
        this.vertices = null;
        this.triangles = null;
        this.vertexTypes = null;
        return result;
    }

    private boolean areVerticesClockwise() {
        float area = 0.0f;
        for (int i = 0; i < this.vertexCount; ++i) {
            Vector2 p1 = this.vertices.get(i);
            Vector2 p2 = this.vertices.get(this.computeNextIndex(i));
            area += p1.x * p2.y - p2.x * p1.y;
        }
        return area < 0.0f;
    }

    private int classifyVertex(int index) {
        Vector2 previousVertex = this.vertices.get(this.computePreviousIndex(index));
        Vector2 currentVertex = this.vertices.get(index);
        Vector2 nextVertex = this.vertices.get(this.computeNextIndex(index));
        return EarClippingTriangulator.computeSpannedAreaSign(previousVertex, currentVertex, nextVertex);
    }

    private static int computeSpannedAreaSign(Vector2 p1, Vector2 p2, Vector2 p3) {
        float area = 0.0f;
        area += p1.x * (p3.y - p2.y);
        area += p2.x * (p1.y - p3.y);
        return (int)Math.signum(area += p3.x * (p2.y - p1.y));
    }

    private int findEarTip() {
        for (int index = 0; index < this.vertexCount; ++index) {
            if (!this.isEarTip(index)) continue;
            return index;
        }
        return this.desperatelyFindEarTip();
    }

    private int desperatelyFindEarTip() {
        for (int index = 0; index < this.vertexCount; ++index) {
            if (this.vertexTypes[index] == -1) continue;
            return index;
        }
        return 0;
    }

    private boolean isEarTip(int pEarTipIndex) {
        if (this.vertexTypes[pEarTipIndex] == -1) {
            return false;
        }
        int previousIndex = this.computePreviousIndex(pEarTipIndex);
        int nextIndex = this.computeNextIndex(pEarTipIndex);
        Vector2 p1 = this.vertices.get(previousIndex);
        Vector2 p2 = this.vertices.get(pEarTipIndex);
        Vector2 p3 = this.vertices.get(nextIndex);
        int i = this.computeNextIndex(nextIndex);
        while (i != previousIndex) {
            if (this.vertexTypes[i] != 1) {
                Vector2 v = this.vertices.get(i);
                int areaSign1 = EarClippingTriangulator.computeSpannedAreaSign(p1, p2, v);
                int areaSign2 = EarClippingTriangulator.computeSpannedAreaSign(p2, p3, v);
                int areaSign3 = EarClippingTriangulator.computeSpannedAreaSign(p3, p1, v);
                if (areaSign1 >= 0 && areaSign2 >= 0 && areaSign3 >= 0) {
                    return false;
                }
            }
            i = this.computeNextIndex(i);
        }
        return true;
    }

    private void cutEarTip(int pEarTipIndex) {
        int previousIndex = this.computePreviousIndex(pEarTipIndex);
        int nextIndex = this.computeNextIndex(pEarTipIndex);
        this.triangles.add(new Vector2(this.vertices.get(previousIndex)));
        this.triangles.add(new Vector2(this.vertices.get(pEarTipIndex)));
        this.triangles.add(new Vector2(this.vertices.get(nextIndex)));
        this.vertices.remove(pEarTipIndex);
        System.arraycopy(this.vertexTypes, pEarTipIndex + 1, this.vertexTypes, pEarTipIndex, this.vertexCount - pEarTipIndex - 1);
        --this.vertexCount;
    }

    private int computePreviousIndex(int pIndex) {
        return pIndex == 0 ? this.vertexCount - 1 : pIndex - 1;
    }

    private int computeNextIndex(int pIndex) {
        return pIndex == this.vertexCount - 1 ? 0 : pIndex + 1;
    }
}

