/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL11;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class VertexBufferObject
implements VertexData {
    static final IntBuffer tmpHandle = BufferUtils.newIntBuffer(1);
    final VertexAttributes attributes;
    final FloatBuffer buffer;
    final ByteBuffer byteBuffer;
    int bufferHandle;
    final boolean isStatic;
    final int usage;
    boolean isDirty = false;
    boolean isBound = false;

    public VertexBufferObject(boolean isStatic, int numVertices, VertexAttribute ... attributes) {
        this(isStatic, numVertices, new VertexAttributes(attributes));
    }

    public VertexBufferObject(boolean isStatic, int numVertices, VertexAttributes attributes) {
        this.isStatic = isStatic;
        this.attributes = attributes;
        this.byteBuffer = BufferUtils.newUnsafeByteBuffer(this.attributes.vertexSize * numVertices);
        this.buffer = this.byteBuffer.asFloatBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = this.createBufferObject();
        this.usage = isStatic ? 35044 : 35048;
    }

    private int createBufferObject() {
        if (Gdx.gl20 != null) {
            Gdx.gl20.glGenBuffers(1, tmpHandle);
        } else {
            Gdx.gl11.glGenBuffers(1, tmpHandle);
        }
        return tmpHandle.get(0);
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public int getNumVertices() {
        return this.buffer.limit() * 4 / this.attributes.vertexSize;
    }

    @Override
    public int getNumMaxVertices() {
        return this.byteBuffer.capacity() / this.attributes.vertexSize;
    }

    @Override
    public FloatBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    @Override
    public void setVertices(float[] vertices, int offset, int count) {
        this.isDirty = true;
        BufferUtils.copy(vertices, this.byteBuffer, count, offset);
        this.buffer.position(0);
        this.buffer.limit(count);
        if (this.isBound) {
            if (Gdx.gl20 != null) {
                GL20 gl = Gdx.gl20;
                gl.glBufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            } else {
                GL11 gl = Gdx.gl11;
                gl.glBufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            }
            this.isDirty = false;
        }
    }

    @Override
    public void bind() {
        GL11 gl = Gdx.gl11;
        gl.glBindBuffer(34962, this.bufferHandle);
        if (this.isDirty) {
            this.byteBuffer.limit(this.buffer.limit() * 4);
            gl.glBufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
        int textureUnit = 0;
        int numAttributes = this.attributes.size();
        block6: for (int i = 0; i < numAttributes; ++i) {
            VertexAttribute attribute = this.attributes.get(i);
            switch (attribute.usage) {
                case 1: {
                    gl.glEnableClientState(32884);
                    gl.glVertexPointer(attribute.numComponents, 5126, this.attributes.vertexSize, attribute.offset);
                    continue block6;
                }
                case 2: 
                case 4: {
                    int colorType = 5126;
                    if (attribute.usage == 4) {
                        colorType = 5121;
                    }
                    gl.glEnableClientState(32886);
                    gl.glColorPointer(attribute.numComponents, colorType, this.attributes.vertexSize, attribute.offset);
                    continue block6;
                }
                case 8: {
                    gl.glEnableClientState(32885);
                    gl.glNormalPointer(5126, this.attributes.vertexSize, attribute.offset);
                    continue block6;
                }
                case 16: {
                    gl.glClientActiveTexture(33984 + textureUnit);
                    gl.glEnableClientState(32888);
                    gl.glTexCoordPointer(attribute.numComponents, 5126, this.attributes.vertexSize, attribute.offset);
                    ++textureUnit;
                    continue block6;
                }
            }
        }
        this.isBound = true;
    }

    @Override
    public void bind(ShaderProgram shader) {
        this.bind(shader, null);
    }

    @Override
    public void bind(ShaderProgram shader, int[] locations) {
        GL20 gl = Gdx.gl20;
        gl.glBindBuffer(34962, this.bufferHandle);
        if (this.isDirty) {
            this.byteBuffer.limit(this.buffer.limit() * 4);
            gl.glBufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
        int numAttributes = this.attributes.size();
        if (locations == null) {
            for (int i = 0; i < numAttributes; ++i) {
                VertexAttribute attribute = this.attributes.get(i);
                int location = shader.getAttributeLocation(attribute.alias);
                if (location < 0) continue;
                shader.enableVertexAttribute(location);
                if (attribute.usage == 4) {
                    shader.setVertexAttribute(location, attribute.numComponents, 5121, true, this.attributes.vertexSize, attribute.offset);
                    continue;
                }
                shader.setVertexAttribute(location, attribute.numComponents, 5126, false, this.attributes.vertexSize, attribute.offset);
            }
        } else {
            for (int i = 0; i < numAttributes; ++i) {
                VertexAttribute attribute = this.attributes.get(i);
                int location = locations[i];
                if (location < 0) continue;
                shader.enableVertexAttribute(location);
                if (attribute.usage == 4) {
                    shader.setVertexAttribute(location, attribute.numComponents, 5121, true, this.attributes.vertexSize, attribute.offset);
                    continue;
                }
                shader.setVertexAttribute(location, attribute.numComponents, 5126, false, this.attributes.vertexSize, attribute.offset);
            }
        }
        this.isBound = true;
    }

    @Override
    public void unbind() {
        GL11 gl = Gdx.gl11;
        int textureUnit = 0;
        int numAttributes = this.attributes.size();
        block6: for (int i = 0; i < numAttributes; ++i) {
            VertexAttribute attribute = this.attributes.get(i);
            switch (attribute.usage) {
                case 1: {
                    continue block6;
                }
                case 2: 
                case 4: {
                    gl.glDisableClientState(32886);
                    continue block6;
                }
                case 8: {
                    gl.glDisableClientState(32885);
                    continue block6;
                }
                case 16: {
                    gl.glClientActiveTexture(33984 + textureUnit);
                    gl.glDisableClientState(32888);
                    ++textureUnit;
                    continue block6;
                }
            }
        }
        gl.glBindBuffer(34962, 0);
        this.isBound = false;
    }

    @Override
    public void unbind(ShaderProgram shader) {
        this.unbind(shader, null);
    }

    @Override
    public void unbind(ShaderProgram shader, int[] locations) {
        GL20 gl = Gdx.gl20;
        int numAttributes = this.attributes.size();
        if (locations == null) {
            for (int i = 0; i < numAttributes; ++i) {
                shader.disableVertexAttribute(this.attributes.get((int)i).alias);
            }
        } else {
            for (int i = 0; i < numAttributes; ++i) {
                int location = locations[i];
                if (location < 0) continue;
                shader.disableVertexAttribute(location);
            }
        }
        gl.glBindBuffer(34962, 0);
        this.isBound = false;
    }

    public void invalidate() {
        this.bufferHandle = this.createBufferObject();
        this.isDirty = true;
    }

    @Override
    public void dispose() {
        if (Gdx.gl20 != null) {
            tmpHandle.clear();
            tmpHandle.put(this.bufferHandle);
            tmpHandle.flip();
            GL20 gl = Gdx.gl20;
            gl.glBindBuffer(34962, 0);
            gl.glDeleteBuffers(1, tmpHandle);
            this.bufferHandle = 0;
        } else {
            tmpHandle.clear();
            tmpHandle.put(this.bufferHandle);
            tmpHandle.flip();
            GL11 gl = Gdx.gl11;
            gl.glBindBuffer(34962, 0);
            gl.glDeleteBuffers(1, tmpHandle);
            this.bufferHandle = 0;
        }
        BufferUtils.disposeUnsafeByteBuffer(this.byteBuffer);
    }
}

