/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders.graph;

import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderDefine;
import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderInput;
import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderOutput;
import com.badlogic.gdx.utils.Array;

public class ShaderNode {
    protected String name;
    protected ShaderNodeType type;
    protected Array<ShaderInput> inputs;
    protected Array<ShaderOutput> outputs;
    protected String code;
    protected Array<String> requires;
    protected Array<ShaderDefine> defines;

    ShaderNode() {
    }

    ShaderNode(String name, ShaderNodeType type, Array<String> requires, Array<ShaderDefine> defines, Array<ShaderInput> inputs, Array<ShaderOutput> outputs, String code) {
        this.name = name;
        this.type = type;
        this.requires = requires;
        this.defines = defines;
        this.inputs = inputs;
        this.outputs = outputs;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public ShaderNodeType getType() {
        return this.type;
    }

    public Array<ShaderInput> getInputs() {
        return this.inputs;
    }

    public ShaderInput getInput(String name) {
        for (ShaderInput input : this.inputs) {
            if (!input.getName().equals(name)) continue;
            return input;
        }
        return null;
    }

    public Array<ShaderOutput> getOutputs() {
        return this.outputs;
    }

    public ShaderOutput getOutput(String name) {
        for (ShaderOutput output : this.outputs) {
            if (!output.getName().equals(name)) continue;
            return output;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public ShaderNode copy() {
        Array<ShaderInput> copiedInputs = new Array<ShaderInput>();
        for (ShaderInput input : this.inputs) {
            copiedInputs.add(input.copy());
        }
        Array<ShaderOutput> copiedOutputs = new Array<ShaderOutput>();
        for (ShaderOutput output : this.outputs) {
            copiedOutputs.add(output.copy());
        }
        return new ShaderNode(this.name, this.type, new Array<String>(this.requires), new Array<ShaderDefine>(this.defines), copiedInputs, copiedOutputs, this.code);
    }

    public String toString() {
        String[] lines;
        StringBuilder builder = new StringBuilder();
        builder.append("name ");
        builder.append(this.name);
        builder.append(";\n");
        builder.append("type ");
        builder.append((Object)this.type);
        builder.append(";\n");
        for (String require : this.requires) {
            builder.append("requires ");
            builder.append(require);
            builder.append(";\n");
        }
        for (ShaderDefine define : this.defines) {
            builder.append("define ");
            builder.append(define.getName());
            builder.append("=");
            builder.append(define.getValue());
            builder.append(";\n");
        }
        builder.append("inputs {\n");
        for (ShaderInput input : this.inputs) {
            builder.append("   ");
            if (input.getQualifier() != ShaderInput.ShaderInputQualifier.Local) {
                builder.append(input.getQualifier().toString().toLowerCase());
                builder.append(" ");
            }
            builder.append(input.getType());
            builder.append(" ");
            builder.append(input.getName());
            builder.append(";\n");
        }
        builder.append("}\n");
        builder.append("outputs {\n");
        for (ShaderOutput output : this.outputs) {
            builder.append("   ");
            if (output.isVarying()) {
                builder.append("varying ");
            }
            builder.append(output.getType());
            builder.append(" ");
            builder.append(output.getName());
            builder.append(";\n");
        }
        builder.append("}\n");
        builder.append("code {\n");
        for (String line : lines = this.code.split("\n")) {
            builder.append("   " + line);
        }
        builder.append("\n}\n");
        return builder.toString();
    }

    public static enum ShaderNodeType {
        Vertex,
        Fragment;

    }
}

