/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders.graph;

import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderConnection;
import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderInput;
import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderNode;
import com.badlogic.gdx.graphics.g3d.shaders.graph.ShaderOutput;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;

public class ShaderGraph {
    private final ShaderNode.ShaderNodeType type;
    private final ObjectMap<String, ShaderNode> nodeTypes = new ObjectMap();
    private final ObjectSet<ShaderNode> nodeSet = new ObjectSet();
    private final Array<ShaderNode> nodes = new Array();
    private final Array<ShaderConnection> connections = new Array();
    private final ObjectMap<ShaderNode, Array<ShaderConnection>> connectionMap = new ObjectMap();

    public ShaderGraph(ShaderNode.ShaderNodeType type) {
        this.type = type;
    }

    public ShaderNode.ShaderNodeType getType() {
        return this.type;
    }

    public void addNodeType(ShaderNode node) {
        if (node.getType() != this.type) {
            throw new GdxRuntimeException("graph type " + (Object)((Object)this.type) + " != node type " + (Object)((Object)node.getType()));
        }
        if (this.nodeTypes.get(node.getName()) != null) {
            throw new GdxRuntimeException("Node type with name '" + node.getName() + "' already in graph");
        }
        this.nodeTypes.put(node.getName(), node);
    }

    public ShaderNode newNode(String nodeType) {
        ShaderNode node = this.nodeTypes.get(nodeType);
        if (node == null) {
            throw new GdxRuntimeException("Node type '" + nodeType + "' not in graph, add it with addNodeType() first!");
        }
        node = node.copy();
        this.nodes.add(node);
        this.nodeSet.add(node);
        return node;
    }

    public void connect(ShaderNode outputNode, String outputName, ShaderNode inputNode, String inputName) {
        if (!this.nodeSet.contains(outputNode)) {
            throw new GdxRuntimeException("output node not in graph");
        }
        if (!this.nodeSet.contains(inputNode)) {
            throw new GdxRuntimeException("input node not in graph");
        }
        ShaderOutput output = outputNode.getOutput(outputName);
        if (output == null) {
            throw new GdxRuntimeException("shader output '" + outputName + "' not in node '" + outputNode.getName() + "'");
        }
        ShaderInput input = inputNode.getInput(inputName);
        if (input == null) {
            throw new GdxRuntimeException("shader input '" + inputName + "' not in node '" + inputNode.getName() + "'");
        }
        if (!output.getType().equals(input.getType())) {
            throw new GdxRuntimeException("shader output '" + output.getName() + "' has type '" + output.getType() + "'" + ", does not match shader input '" + input.getName() + "' type '" + input.getType() + "'");
        }
        ShaderConnection connection = new ShaderConnection(outputNode, output, inputNode, input);
        this.connections.add(connection);
        this.addConnection(outputNode, connection);
        this.addConnection(inputNode, connection);
    }

    private void addConnection(ShaderNode node, ShaderConnection connection) {
        Array<ShaderConnection> connections = this.connectionMap.get(node);
        if (connections == null) {
            connections = new Array();
            this.connectionMap.put(node, connections);
        }
        connections.add(connection);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("types {\n");
        for (String type : this.nodeTypes.keys()) {
            String[] lines;
            builder.append("   {\n");
            for (String line : lines = this.nodeTypes.get(type).toString().split("\n")) {
                builder.append("      " + line + "\n");
            }
            builder.append("   }\n");
        }
        builder.append("\n}\n");
        builder.append("nodes {\n");
        int i = 0;
        for (ShaderNode node : this.nodes) {
            builder.append("   node " + node.getName() + "_" + i + ";\n");
            ++i;
        }
        builder.append("\n}\n");
        builder.append("connections {\n");
        for (ShaderConnection con : this.connections) {
            int outputIdx = this.nodes.indexOf(con.getOutputNode(), true);
            int inputIdx = this.nodes.indexOf(con.getInputNode(), true);
            builder.append("   " + con.getOutputNode().getName() + "_" + outputIdx + con.getOutput().getName() + " -> ");
            builder.append(con.getInputNode().getName() + "_" + inputIdx + con.getInput().getName() + ";\n");
            ++i;
        }
        builder.append("\n}\n");
        return builder.toString();
    }
}

