/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.materials;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class TextureAttribute
extends Material.Attribute {
    public static final String DiffuseAlias = "diffuseTexture";
    public static final long Diffuse = TextureAttribute.register("diffuseTexture");
    public static final String SpecularAlias = "specularTexture";
    public static final long Specular = TextureAttribute.register("specularTexture");
    public static final String BumpAlias = "bumpTexture";
    public static final long Bump = TextureAttribute.register("bumpTexture");
    public static final String NormalAlias = "normalTexture";
    public static final long Normal = TextureAttribute.register("normalTexture");
    protected static long Mask = Diffuse | Specular | Bump | Normal;
    public final TextureDescriptor textureDescription;

    public static final boolean is(long mask) {
        return (mask & Mask) != 0L;
    }

    public static TextureAttribute createDiffuse(Texture texture) {
        return new TextureAttribute(Diffuse, texture);
    }

    public static TextureAttribute createSpecular(Texture texture) {
        return new TextureAttribute(Specular, texture);
    }

    public TextureAttribute(long type, TextureDescriptor textureDescription) {
        super(type);
        if (!TextureAttribute.is(type)) {
            throw new GdxRuntimeException("Invalid type specified");
        }
        this.textureDescription = textureDescription;
    }

    public TextureAttribute(long type) {
        this(type, new TextureDescriptor());
    }

    public TextureAttribute(long type, Texture texture) {
        this(type, new TextureDescriptor(texture));
    }

    public TextureAttribute(TextureAttribute copyFrom) {
        this(copyFrom.type, copyFrom.textureDescription);
    }

    @Override
    public Material.Attribute copy() {
        return new TextureAttribute(this);
    }

    @Override
    protected boolean equals(Material.Attribute other) {
        return ((TextureAttribute)other).textureDescription.equals(this.textureDescription);
    }
}

