/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio.io;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.io.Decoder;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;

public class WavDecoder
extends Decoder {
    WavInputStream in;
    byte[] buffer = new byte[1024];

    public WavDecoder(FileHandle file) {
        this.in = new WavInputStream(file);
    }

    @Override
    public int readSamples(short[] samples, int offset, int numSamples) {
        int read = 0;
        int total = 0;
        if (this.buffer.length < samples.length * 2) {
            this.buffer = new byte[samples.length * 2];
        }
        numSamples *= 2;
        try {
            while ((read = this.in.read(this.buffer, total, numSamples - total)) > 0) {
                total += read;
            }
            total -= total % 2;
            for (int j = 0; j < total; j += 2) {
                samples[offset++] = (short)(this.buffer[j + 1] << 8 & 0xFF00 | this.buffer[j] & 0xFF);
            }
        }
        catch (IOException e) {
            return 0;
        }
        return total /= 2;
    }

    @Override
    public int skipSamples(int numSamples) {
        try {
            return (int)this.in.skip(numSamples * 2 * this.getChannels()) / (2 * this.getChannels());
        }
        catch (IOException e) {
            Gdx.app.error("WavDecoder", "Couldn't skip");
            return 0;
        }
    }

    @Override
    public int getChannels() {
        return this.in.channels;
    }

    @Override
    public int getRate() {
        return this.in.sampleRate;
    }

    @Override
    public float getLength() {
        return (float)(this.in.dataRemaining / (2 * this.getChannels())) / (float)this.getRate();
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean setPosition(float seconds) {
        return false;
    }

    @Override
    public float getPosition() {
        return -1.0f;
    }

    @Override
    public void dispose() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class WavInputStream
    extends FilterInputStream {
        int channels;
        int sampleRate;
        int dataRemaining;

        WavInputStream(FileHandle file) {
            super(file.read());
            try {
                if (this.read() != 82 || this.read() != 73 || this.read() != 70 || this.read() != 70) {
                    throw new GdxRuntimeException("RIFF header not found: " + file);
                }
                this.skipFully(4);
                if (this.read() != 87 || this.read() != 65 || this.read() != 86 || this.read() != 69) {
                    throw new GdxRuntimeException("Invalid wave file header: " + file);
                }
                int fmtChunkLength = this.seekToChunk('f', 'm', 't', ' ');
                int type = this.read() & 0xFF | (this.read() & 0xFF) << 8;
                if (type != 1) {
                    throw new GdxRuntimeException("WAV files must be PCM: " + type);
                }
                this.channels = this.read() & 0xFF | (this.read() & 0xFF) << 8;
                if (this.channels != 1 && this.channels != 2) {
                    throw new GdxRuntimeException("WAV files must have 1 or 2 channels: " + this.channels);
                }
                this.sampleRate = this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
                this.skipFully(6);
                int bitsPerSample = this.read() & 0xFF | (this.read() & 0xFF) << 8;
                if (bitsPerSample != 16) {
                    throw new GdxRuntimeException("WAV files must have 16 bits per sample: " + bitsPerSample);
                }
                this.skipFully(fmtChunkLength - 16);
                this.dataRemaining = this.seekToChunk('d', 'a', 't', 'a');
            }
            catch (Throwable ex) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new GdxRuntimeException("Error reading WAV file: " + file, ex);
            }
        }

        private int seekToChunk(char c1, char c2, char c3, char c4) throws IOException {
            while (true) {
                boolean found = this.read() == c1;
                found &= this.read() == c2;
                found &= this.read() == c3;
                found &= this.read() == c4;
                int chunkLength = this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
                if (chunkLength == -1) {
                    throw new IOException("Chunk not found: " + c1 + c2 + c3 + c4);
                }
                if (found) {
                    return chunkLength;
                }
                this.skipFully(chunkLength);
            }
        }

        private void skipFully(int count) throws IOException {
            while (count > 0) {
                long skipped = this.in.skip(count);
                if (skipped <= 0L) {
                    throw new EOFException("Unable to skip.");
                }
                count = (int)((long)count - skipped);
            }
        }

        public int readData(byte[] buffer) throws IOException {
            if (this.dataRemaining == 0) {
                return -1;
            }
            int length = Math.min(this.read(buffer), this.dataRemaining);
            if (length == -1) {
                return -1;
            }
            this.dataRemaining -= length;
            return length;
        }
    }
}

