/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio.io;

import com.badlogic.gdx.audio.analysis.AudioTools;
import com.badlogic.gdx.utils.Disposable;

public abstract class Decoder
implements Disposable {
    private short[] readBuffer;
    private int channels;

    public abstract int readSamples(short[] var1, int var2, int var3);

    public int readSamples(float[] samples, int offset, int numSamples) {
        int result;
        if (this.readBuffer == null || this.readBuffer.length < numSamples) {
            this.readBuffer = new short[numSamples];
        }
        if (this.channels <= 0) {
            this.channels = this.getChannels();
        }
        if ((result = this.readSamples(this.readBuffer, 0, numSamples)) <= 0) {
            return result;
        }
        AudioTools.toFloat(this.readBuffer, 0, samples, offset, result);
        return result;
    }

    public short[] readAllSamples() {
        short[] tmp;
        short[] out = new short[(int)Math.ceil(this.getLength() * (float)this.getRate() * (float)this.getChannels())];
        short[] buffer = new short[5120];
        int readSamples = 0;
        int totalSamples = 0;
        while ((readSamples = this.readSamples(buffer, 0, buffer.length)) > 0) {
            if (readSamples + totalSamples >= out.length) {
                tmp = new short[readSamples + totalSamples];
                System.arraycopy(out, 0, tmp, 0, totalSamples);
                out = tmp;
            }
            System.arraycopy(buffer, 0, out, totalSamples, readSamples);
            totalSamples += readSamples;
        }
        if (out.length != totalSamples) {
            tmp = new short[totalSamples];
            System.arraycopy(out, 0, tmp, 0, totalSamples);
            out = tmp;
        }
        return out;
    }

    public abstract int skipSamples(int var1);

    public abstract boolean canSeek();

    public abstract boolean setPosition(float var1);

    public abstract float getPosition();

    public abstract int getChannels();

    public abstract int getRate();

    public abstract float getLength();

    @Override
    public abstract void dispose();
}

