/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio;

public class CircularFloatBuffer {
    private final float[] buffer;
    private int writePosition;
    private int readPosition;
    private int available;
    public final int size;

    public CircularFloatBuffer(int size) {
        this.size = size;
        this.buffer = new float[this.size];
    }

    public void write(float[] data, int offset, int count) {
        int copy = 0;
        if (this.writePosition > this.readPosition || this.available == 0) {
            copy = Math.min(this.buffer.length - this.writePosition, count);
            System.arraycopy(data, offset, this.buffer, this.writePosition, copy);
            this.writePosition = (this.writePosition + copy) % this.buffer.length;
            this.available += copy;
            if ((count -= copy) == 0) {
                return;
            }
        }
        copy = Math.min(this.readPosition - this.writePosition, count);
        System.arraycopy(data, offset, this.buffer, this.writePosition, copy);
        this.writePosition += copy;
        this.available += copy;
    }

    public void combine(float[] data, int offset, int count) {
        int copy = 0;
        if (this.writePosition > this.readPosition || this.available == 0) {
            copy = Math.min(this.buffer.length - this.writePosition, count);
            CircularFloatBuffer.combine(data, offset, this.buffer, this.writePosition, copy);
            this.writePosition = (this.writePosition + copy) % this.buffer.length;
            this.available += copy;
            if ((count -= copy) == 0) {
                return;
            }
        }
        copy = Math.min(this.readPosition - this.writePosition, count);
        CircularFloatBuffer.combine(data, offset, this.buffer, this.writePosition, copy);
        this.writePosition += copy;
        this.available += copy;
    }

    public int read(float[] data, int offset, int count) {
        if (this.available == 0) {
            return 0;
        }
        int total = count = Math.min(this.available, count);
        int copy = Math.min(this.buffer.length - this.readPosition, total);
        System.arraycopy(this.buffer, this.readPosition, data, offset, copy);
        this.readPosition = (this.readPosition + copy) % this.buffer.length;
        this.available -= copy;
        if ((count -= copy) > 0 && this.available > 0) {
            copy = Math.min(this.buffer.length - this.available, count);
            System.arraycopy(this.buffer, this.readPosition, data, offset, copy);
            this.readPosition = (this.readPosition + copy) % this.buffer.length;
            this.available -= copy;
        }
        return total;
    }

    public int skip(int count) {
        int total = count = Math.min(this.available, count);
        this.available -= total;
        this.readPosition = (this.readPosition + total) % this.buffer.length;
        return total;
    }

    public void clear() {
        int n = this.buffer.length;
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = 0.0f;
        }
        this.readPosition = 0;
        this.writePosition = 0;
        this.available = 0;
    }

    public void setWritePosition(int writePosition) {
        this.writePosition = Math.abs(writePosition) % this.buffer.length;
    }

    public int getWritePosition() {
        return this.writePosition;
    }

    public void setReadPosition(int readPosition) {
        this.readPosition = Math.abs(readPosition) % this.buffer.length;
    }

    public int getReadPosition() {
        return this.readPosition;
    }

    public int getAvailable() {
        return this.available;
    }

    private void dump() {
        int n = this.buffer.length;
        for (int i = 0; i < n; ++i) {
            System.out.println(this.buffer[i] + (i == this.writePosition ? " <- write" : "") + (i == this.readPosition ? " <- read" : ""));
        }
        System.out.println();
    }

    private static void combine(float[] src, int srcPos, float[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            int destIndex = destPos + i;
            float a = src[srcPos + i];
            float b = dest[destIndex];
            dest[destIndex] = a + b;
        }
    }
}

