/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders.resolvers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;

public class ResolutionFileResolver
implements FileHandleResolver {
    protected final FileHandleResolver baseResolver;
    protected final Resolution[] descriptors;

    public ResolutionFileResolver(FileHandleResolver baseResolver, Resolution ... descriptors) {
        this.baseResolver = baseResolver;
        this.descriptors = descriptors;
    }

    @Override
    public FileHandle resolve(String fileName) {
        Resolution bestDesc = ResolutionFileResolver.choose(this.descriptors);
        FileHandle originalHandle = new FileHandle(fileName);
        FileHandle handle = this.baseResolver.resolve(this.resolve(originalHandle, bestDesc.suffix));
        if (!handle.exists()) {
            handle = this.baseResolver.resolve(fileName);
        }
        return handle;
    }

    protected String resolve(FileHandle originalHandle, String suffix) {
        return originalHandle.parent() + "/" + suffix + "/" + originalHandle.name();
    }

    public static Resolution choose(Resolution ... descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException("descriptors cannot be null.");
        }
        int w = Gdx.graphics.getWidth();
        int h = Gdx.graphics.getHeight();
        Resolution best = descriptors[0];
        if (w < h) {
            int n = descriptors.length;
            for (int i = 0; i < n; ++i) {
                Resolution other = descriptors[i];
                if (w < other.portraitWidth || other.portraitWidth < best.portraitWidth || h < other.portraitHeight || other.portraitHeight < best.portraitHeight) continue;
                best = descriptors[i];
            }
        } else {
            int n = descriptors.length;
            for (int i = 0; i < n; ++i) {
                Resolution other = descriptors[i];
                if (w < other.portraitHeight || other.portraitHeight < best.portraitHeight || h < other.portraitWidth || other.portraitWidth < best.portraitWidth) continue;
                best = descriptors[i];
            }
        }
        return best;
    }

    public static class Resolution {
        public final int portraitWidth;
        public final int portraitHeight;
        public final String suffix;

        public Resolution(int portraitWidth, int portraitHeight, String suffix) {
            this.portraitWidth = portraitWidth;
            this.portraitHeight = portraitHeight;
            this.suffix = suffix;
        }
    }
}

