/*
 * Decompiled with CFR 0.152.
 */
package actors;

import aurelienribon.tweenengine.BaseTween;
import aurelienribon.tweenengine.TweenCallback;
import aurelienribon.tweenengine.TweenManager;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.ParticleEffectPool;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Skeleton;
import com.mcburrobit.util.Tween2;
import core.OfficeRunnerGame;

public class Enemy {
    private static final float JUMPINTERVAL = 0.25f;
    private String type;
    private int health;
    private Vector2 position;
    private Vector2 velocity;
    private Vector2 acceleration;
    private Body hitbox;
    private boolean tweening;
    private float groundDistance;
    private float jumpCounter;
    private boolean invulnerable = false;
    private float ppm;
    private Skeleton sprite;
    private World world;
    private OrthographicCamera cam;
    private Body player;
    private TweenManager tweenM;
    private OfficeRunnerGame game;
    private Array<ParticleEffectPool.PooledEffect> particles;
    private ParticleEffectPool pool;

    public void setX(float val2) {
        this.position.x = val2;
    }

    public void setY(float val2) {
        this.position.y = val2;
    }

    public Enemy(String type, Skeleton skeleton, Vector2 position, OfficeRunnerGame gameObj, World gameWorld, OrthographicCamera gameCam, Body gamePlayer, TweenManager origTeenM, Array<ParticleEffectPool.PooledEffect> gameParticles, ParticleEffectPool gamePool) {
        this.type = type;
        this.sprite = skeleton;
        this.position = position.cpy().scl(1.0f / this.ppm);
        this.game = gameObj;
        this.world = gameWorld;
        this.cam = gameCam;
        this.player = gamePlayer;
        this.tweenM = origTeenM;
        this.particles = gameParticles;
        this.pool = gamePool;
        this.velocity = new Vector2();
        this.acceleration = new Vector2();
        this.ppm = this.game.getPPM();
        BodyDef def = new BodyDef();
        def.type = BodyDef.BodyType.StaticBody;
        this.hitbox = this.world.createBody(def);
        PolygonShape poly = new PolygonShape();
        poly.setAsBox(0.7f, 2.2f);
        Fixture f = this.hitbox.createFixture(poly, 1.0f);
        f.setSensor(true);
        poly.dispose();
        this.health = 100;
        this.hitbox.setUserData(this);
        Tween2.setWaypointsLimit(1);
    }

    public boolean update() {
        Vector2 pos = this.player.getPosition();
        float Ex = pos.x + this.cam.viewportWidth / 4.0f / this.ppm;
        if (!this.tweening && !this.invulnerable) {
            if (!this.cam.frustum.pointInFrustum(Vector3.tmp.set(this.position.x * this.ppm, pos.y * this.ppm, 0.0f))) {
                this.tweening = true;
                float targetY = pos.y;
                Tween2.to(this, 2, 0.55f).target(targetY).waypoint(targetY + 3.0f).start(this.tweenM);
                ((Tween2)Tween2.to(this, 1, 0.5f).target(Ex).setCallback(new TweenCallback(){

                    @Override
                    public void onEvent(int type, BaseTween<?> source) {
                        Enemy.this.tweening = false;
                    }
                })).start(this.tweenM);
            } else {
                if (this.jumpCounter > 0.25f) {
                    this.jumpCounter -= 0.25f;
                    this.tweening = true;
                    Tween2.to(this, 2, 0.2f).waypoint(this.position.y + 2.0f).target(this.position.y).start(this.tweenM);
                    ((Tween2)Tween2.to(this, 1, 0.225f).target(this.position.x + 8.0f).setCallback(new TweenCallback(){

                        @Override
                        public void onEvent(int type, BaseTween<?> source) {
                            Enemy.this.tweening = false;
                        }
                    })).start(this.tweenM);
                }
                this.jumpCounter += Gdx.graphics.getDeltaTime();
            }
        }
        this.hitbox.setTransform(this.position, 0.0f);
        return this.health > 0;
    }

    public void render() {
        this.sprite.setX(this.position.x * this.ppm);
        this.sprite.setY((this.position.y - 2.2f) * this.ppm);
    }

    public void registerHit(Vector2 pos, Vector2 normal) {
        ParticleEffectPool.PooledEffect effect = this.pool.obtain();
        effect.setPosition(pos.x * this.ppm, pos.y * this.ppm);
        ParticleEmitter emitter = effect.getEmitters().first();
        float angle = normal.angle() - 180.0f;
        emitter.getAngle().setHigh(angle - 40.0f, angle);
        emitter.getAngle().setLow(angle);
        this.health = (int)((float)this.health - 40.0f);
        if ((float)this.health <= 0.0f) {
            this.game.pew();
            emitter.getScale().setLow(4.0f, 12.0f);
            emitter.getScale().setHigh(8.0f, 18.0f);
            emitter.getAngle().setHigh(0.0f, 360.0f);
            emitter.getAngle().setLow(0.0f, 360.0f);
            this.hitbox.destroyFixture(this.hitbox.getFixtureList().get(0));
            this.game.addScore(100.0f);
        } else {
            this.game.pew();
            emitter.getScale().setLow(1.0f, 6.0f);
            emitter.getScale().setHigh(4.0f, 8.0f);
        }
        this.particles.add(effect);
    }

    public String getType() {
        return this.type;
    }

    public int getHealth() {
        return this.health;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public Vector2 getAcceleration() {
        return this.acceleration;
    }

    public Body getHitbox() {
        return this.hitbox;
    }

    public boolean isTweening() {
        return this.tweening;
    }

    public float getGroundDistance() {
        return this.groundDistance;
    }

    public float getJumpCounter() {
        return this.jumpCounter;
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public float getPpm() {
        return this.ppm;
    }

    public Skeleton getSprite() {
        return this.sprite;
    }

    public World getWorld() {
        return this.world;
    }

    public OrthographicCamera getCam() {
        return this.cam;
    }

    public Body getPlayer() {
        return this.player;
    }

    public TweenManager getTweenM() {
        return this.tweenM;
    }

    public OfficeRunnerGame getGame() {
        return this.game;
    }

    public Array<ParticleEffectPool.PooledEffect> getParticles() {
        return this.particles;
    }

    public ParticleEffectPool getPool() {
        return this.pool;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public void setPosition(Vector2 position) {
        this.position = position;
    }

    public void setVelocity(Vector2 velocity) {
        this.velocity = velocity;
    }

    public void setAcceleration(Vector2 acceleration) {
        this.acceleration = acceleration;
    }

    public void setHitbox(Body hitbox) {
        this.hitbox = hitbox;
    }

    public void setTweening(boolean tweening) {
        this.tweening = tweening;
    }

    public void setGroundDistance(float groundDistance) {
        this.groundDistance = groundDistance;
    }

    public void setJumpCounter(float jumpCounter) {
        this.jumpCounter = jumpCounter;
    }

    public void setInvulnerable(boolean invulnerable) {
        this.invulnerable = invulnerable;
    }

    public void setPpm(float ppm) {
        this.ppm = ppm;
    }

    public void setSprite(Skeleton sprite) {
        this.sprite = sprite;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void setCam(OrthographicCamera cam) {
        this.cam = cam;
    }

    public void setPlayer(Body player) {
        this.player = player;
    }

    public void setTweenM(TweenManager tweenM) {
        this.tweenM = tweenM;
    }

    public void setGame(OfficeRunnerGame game) {
        this.game = game;
    }

    public void setParticles(Array<ParticleEffectPool.PooledEffect> particles) {
        this.particles = particles;
    }

    public void setPool(ParticleEffectPool pool) {
        this.pool = pool;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Enemy)) {
            return false;
        }
        Enemy other = (Enemy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.getHealth() != other.getHealth()) {
            return false;
        }
        Vector2 this$position = this.getPosition();
        Vector2 other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Vector2 this$velocity = this.getVelocity();
        Vector2 other$velocity = other.getVelocity();
        if (this$velocity == null ? other$velocity != null : !((Object)this$velocity).equals(other$velocity)) {
            return false;
        }
        Vector2 this$acceleration = this.getAcceleration();
        Vector2 other$acceleration = other.getAcceleration();
        if (this$acceleration == null ? other$acceleration != null : !((Object)this$acceleration).equals(other$acceleration)) {
            return false;
        }
        Body this$hitbox = this.getHitbox();
        Body other$hitbox = other.getHitbox();
        if (this$hitbox == null ? other$hitbox != null : !this$hitbox.equals(other$hitbox)) {
            return false;
        }
        if (this.isTweening() != other.isTweening()) {
            return false;
        }
        if (Float.compare(this.getGroundDistance(), other.getGroundDistance()) != 0) {
            return false;
        }
        if (Float.compare(this.getJumpCounter(), other.getJumpCounter()) != 0) {
            return false;
        }
        if (this.isInvulnerable() != other.isInvulnerable()) {
            return false;
        }
        if (Float.compare(this.getPpm(), other.getPpm()) != 0) {
            return false;
        }
        Skeleton this$sprite = this.getSprite();
        Skeleton other$sprite = other.getSprite();
        if (this$sprite == null ? other$sprite != null : !this$sprite.equals(other$sprite)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        OrthographicCamera this$cam = this.getCam();
        OrthographicCamera other$cam = other.getCam();
        if (this$cam == null ? other$cam != null : !this$cam.equals(other$cam)) {
            return false;
        }
        Body this$player = this.getPlayer();
        Body other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        TweenManager this$tweenM = this.getTweenM();
        TweenManager other$tweenM = other.getTweenM();
        if (this$tweenM == null ? other$tweenM != null : !this$tweenM.equals(other$tweenM)) {
            return false;
        }
        OfficeRunnerGame this$game = this.getGame();
        OfficeRunnerGame other$game = other.getGame();
        if (this$game == null ? other$game != null : !this$game.equals(other$game)) {
            return false;
        }
        Array<ParticleEffectPool.PooledEffect> this$particles = this.getParticles();
        Array<ParticleEffectPool.PooledEffect> other$particles = other.getParticles();
        if (this$particles == null ? other$particles != null : !((Object)this$particles).equals(other$particles)) {
            return false;
        }
        ParticleEffectPool this$pool = this.getPool();
        ParticleEffectPool other$pool = other.getPool();
        return !(this$pool == null ? other$pool != null : !this$pool.equals(other$pool));
    }

    public boolean canEqual(Object other) {
        return other instanceof Enemy;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $type = this.getType();
        result = result * 31 + ($type == null ? 0 : $type.hashCode());
        result = result * 31 + this.getHealth();
        Vector2 $position = this.getPosition();
        result = result * 31 + ($position == null ? 0 : ((Object)$position).hashCode());
        Vector2 $velocity = this.getVelocity();
        result = result * 31 + ($velocity == null ? 0 : ((Object)$velocity).hashCode());
        Vector2 $acceleration = this.getAcceleration();
        result = result * 31 + ($acceleration == null ? 0 : ((Object)$acceleration).hashCode());
        Body $hitbox = this.getHitbox();
        result = result * 31 + ($hitbox == null ? 0 : $hitbox.hashCode());
        result = result * 31 + (this.isTweening() ? 1231 : 1237);
        result = result * 31 + Float.floatToIntBits(this.getGroundDistance());
        result = result * 31 + Float.floatToIntBits(this.getJumpCounter());
        result = result * 31 + (this.isInvulnerable() ? 1231 : 1237);
        result = result * 31 + Float.floatToIntBits(this.getPpm());
        Skeleton $sprite = this.getSprite();
        result = result * 31 + ($sprite == null ? 0 : $sprite.hashCode());
        World $world = this.getWorld();
        result = result * 31 + ($world == null ? 0 : $world.hashCode());
        OrthographicCamera $cam = this.getCam();
        result = result * 31 + ($cam == null ? 0 : $cam.hashCode());
        Body $player = this.getPlayer();
        result = result * 31 + ($player == null ? 0 : $player.hashCode());
        TweenManager $tweenM = this.getTweenM();
        result = result * 31 + ($tweenM == null ? 0 : $tweenM.hashCode());
        OfficeRunnerGame $game = this.getGame();
        result = result * 31 + ($game == null ? 0 : $game.hashCode());
        Array<ParticleEffectPool.PooledEffect> $particles = this.getParticles();
        result = result * 31 + ($particles == null ? 0 : $particles.hashCode());
        ParticleEffectPool $pool = this.getPool();
        result = result * 31 + ($pool == null ? 0 : $pool.hashCode());
        return result;
    }

    public String toString() {
        return "Enemy(type=" + this.getType() + ", health=" + this.getHealth() + ", position=" + this.getPosition() + ", velocity=" + this.getVelocity() + ", acceleration=" + this.getAcceleration() + ", hitbox=" + this.getHitbox() + ", tweening=" + this.isTweening() + ", groundDistance=" + this.getGroundDistance() + ", jumpCounter=" + this.getJumpCounter() + ", invulnerable=" + this.isInvulnerable() + ", ppm=" + this.getPpm() + ", sprite=" + this.getSprite() + ", world=" + this.getWorld() + ", cam=" + this.getCam() + ", player=" + this.getPlayer() + ", tweenM=" + this.getTweenM() + ", game=" + this.getGame() + ", particles=" + this.getParticles() + ", pool=" + this.getPool() + ")";
    }
}

