/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.yksikot;

import com.assypeli.domain.AmmusOhjaaja;
import com.assypeli.domain.Pelaaja;
import com.assypeli.domain.Suunta;
import com.assypeli.domain.Yksikko;
import com.assypeli.domain.YksikkoPaivitys;
import com.assypeli.paaluokat.Peli;
import com.assypeli.yksikot.YksikkoPaivitysOhjaaja;
import com.assypeli.yksikot.Yksikot;
import java.util.ArrayList;
import java.util.List;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Rectangle;

public class YksikonOhjaaja {
    private List<Yksikko> yksikot = new ArrayList<Yksikko>();
    private List<Yksikko> rangedit = new ArrayList<Yksikko>();
    private Peli peli;
    private Pelaaja pelaaja;
    private Pelaaja vastustaja;
    private YksikkoPaivitysOhjaaja paivitysohjaaja;
    private AmmusOhjaaja ammusohjaaja;
    private List<float[]> hidasteet;
    private boolean piirtaa;
    private boolean liikutetaan;
    private Yksikot sallitutYksikot;

    public YksikonOhjaaja(Peli peli, Pelaaja pelaaja, Pelaaja vastustaja, AmmusOhjaaja ohjaaja) {
        this.peli = peli;
        this.pelaaja = pelaaja;
        this.vastustaja = vastustaja;
        this.paivitysohjaaja = new YksikkoPaivitysOhjaaja(pelaaja);
        this.ammusohjaaja = ohjaaja;
        this.hidasteet = new ArrayList<float[]>();
        this.piirtaa = false;
        this.liikutetaan = false;
    }

    public synchronized void lisaaYksikko(Yksikko yksikko) {
        this.paivitysohjaaja.paivitaYksikko(yksikko);
        while (this.piirtaa) {
        }
        while (this.liikutetaan) {
        }
        this.yksikot.add(yksikko);
        if (yksikko.onRanged()) {
            this.rangedit.add(yksikko);
        }
    }

    public synchronized void poistaYksikko(Yksikko yksikko) {
        while (this.piirtaa) {
        }
        while (this.liikutetaan) {
        }
        if (!yksikko.onHengissa()) {
            this.pelaaja.getTalo().poistaAsukkaita(yksikko.getAsukasmaara());
            this.yksikot.remove(yksikko);
            if (this.rangedit.contains(yksikko)) {
                this.rangedit.remove(yksikko);
            }
        }
    }

    public synchronized void piirraYksikot(Graphics g, int ruudunSijainti) {
        int ruutu = this.peli.getRuudunsijainti();
        this.piirtaa = true;
        if (!this.yksikot.isEmpty()) {
            for (Yksikko yk : this.yksikot) {
                yk.piirra(g, ruutu);
            }
        }
        if (!this.hidasteet.isEmpty()) {
            for (float[] hidaste : this.hidasteet) {
                g.setColor(Color.orange);
                g.drawLine(hidaste[0] - (float)ruudunSijainti, 300.0f, hidaste[1] - (float)ruudunSijainti, 300.0f);
                g.setColor(Color.white);
            }
        }
        this.piirtaa = false;
    }

    public synchronized void lisaaHidaste(float[] hidaste) {
        this.hidasteet.add(hidaste);
    }

    public synchronized void poistaHidaste(float[] hidaste) {
        if (this.hidasteet.contains(hidaste)) {
            this.hidasteet.remove(this.hidasteet.indexOf(hidaste));
        }
    }

    public boolean onHidasteita() {
        return !this.hidasteet.isEmpty();
    }

    public synchronized void liikutaYksikot(int delta) {
        this.liikutetaan = true;
        if (!this.yksikot.isEmpty()) {
            for (Yksikko z : this.yksikot) {
                Yksikko osuva = this.osuuOmaan(z, delta);
                if (osuva == null && !z.getTaistelussa()) {
                    if (this.onHidasteita()) {
                        for (float[] hidaste : this.hidasteet) {
                            float x1 = hidaste[0];
                            float x2 = hidaste[1];
                            if (z.getSuunta() == Suunta.VASEN) {
                                if (z.getX() >= x1 && z.getX() + (float)z.getLeveys() <= x2) {
                                    z.liikuta(hidaste[2], delta);
                                    continue;
                                }
                                z.liikuta(delta);
                                continue;
                            }
                            if (z.getX() + (float)z.getLeveys() >= x1 && z.getX() <= x2) {
                                z.liikuta(hidaste[2], delta);
                                continue;
                            }
                            z.liikuta(delta);
                        }
                    } else {
                        z.liikuta(delta);
                    }
                } else if (osuva != null && (osuva.getTaistelussa() || osuva.getHyokkaysJonossa())) {
                    z.setHyokkaysJonossa(true);
                }
                if (!z.onRanged() || z.getAmpuu() || z.getTaistelussa()) continue;
                this.rangedAmpuminen(z);
            }
        }
        this.liikutetaan = false;
    }

    public void rangedAmpuminen(Yksikko y) {
        if (this.pelaaja.getId() == 0) {
            if (this.peli.onYksikoita2() && this.peli.getPelaaja2pisimmalla().getX() <= y.getX() + (float)y.getRange()) {
                y.ammu(this.peli.getPelaaja2pisimmalla(), this.ammusohjaaja);
            }
        } else if (this.peli.onYksikoita1() && this.peli.getPelaaja1pisimmalla().getX() >= y.getX() - (float)y.getRange()) {
            y.ammu(this.peli.getPelaaja1pisimmalla(), this.ammusohjaaja);
        }
    }

    public synchronized void tyhjennaHyokkaysjono() {
        for (Yksikko y : this.yksikot) {
            y.setHyokkaysJonossa(false);
        }
    }

    public Yksikko osuuOmaan(Yksikko y, int delta) {
        if (this.yksikot.size() == 1) {
            return null;
        }
        Rectangle nelio = new Rectangle(y.getHitbox().getX(), y.getHitbox().getY(), y.getHitbox().getWidth(), y.getHitbox().getHeight());
        if (y.getSuunta() == Suunta.OIKEA) {
            nelio.setX(nelio.getX() + (float)(1 * delta) + (float)y.getLeveys());
            nelio.setWidth(1.0f);
        } else {
            nelio.setX(nelio.getX() - (float)(1 * delta));
            nelio.setWidth(1.0f);
        }
        for (Yksikko z : this.yksikot) {
            if (!z.getHitbox().intersects(nelio) || z.equals(y)) continue;
            return z;
        }
        return null;
    }

    public void toteutaPaivitys(YksikkoPaivitys paivitys) {
        this.paivitysohjaaja.aktivoiPaivitys(paivitys, this.yksikot);
    }

    public synchronized Yksikko klikkaaYksikkoa(Rectangle r) {
        for (Yksikko z : this.yksikot) {
            if (!z.osuuko(r)) continue;
            return z;
        }
        return null;
    }

    public List<Yksikko> getYksikot() {
        return this.yksikot;
    }

    public synchronized Yksikko suurinX() {
        if (this.yksikot.size() == 0) {
            return null;
        }
        Yksikko suurin = null;
        if (!this.yksikot.isEmpty()) {
            for (Yksikko y : this.yksikot) {
                if (suurin != null && !(y.getX() > suurin.getX())) continue;
                suurin = y;
            }
        }
        return suurin;
    }

    public synchronized Yksikko pieninX() {
        if (this.yksikot.size() == 0) {
            return null;
        }
        Yksikko pienin = null;
        if (!this.yksikot.isEmpty()) {
            for (Yksikko y : this.yksikot) {
                if (pienin != null && !(y.getX() < pienin.getX())) continue;
                pienin = y;
            }
        }
        return pienin;
    }

    public YksikkoPaivitysOhjaaja getPaivitysohjaaja() {
        return this.paivitysohjaaja;
    }

    public Pelaaja getVastustaja() {
        return this.vastustaja;
    }

    public AmmusOhjaaja getAmmusohjaaja() {
        return this.ammusohjaaja;
    }

    public synchronized void tarkistaSallitutyksikot() {
        if (!Yksikot.NUIJAMIES.getAktivoitu(this.pelaaja.getId())) {
            Yksikot.NUIJAMIES.aktivoi(this.pelaaja.getId());
        }
        if (!Yksikot.JOUSIMIES.getAktivoitu(this.pelaaja.getId()) && this.pelaaja.getKasarmi().getTaso() >= 2) {
            Yksikot.JOUSIMIES.aktivoi(this.pelaaja.getId());
        }
        if (!Yksikot.MIEKKAMIES.getAktivoitu(this.pelaaja.getId()) && this.pelaaja.getKasarmi().getTaso() >= 1) {
            Yksikot.MIEKKAMIES.aktivoi(this.pelaaja.getId());
        }
        if (!Yksikot.KEIHASMIES.getAktivoitu(this.pelaaja.getId()) && this.pelaaja.getKasarmi().getTaso() >= 3) {
            Yksikot.KEIHASMIES.aktivoi(this.pelaaja.getId());
        }
        if (!Yksikot.HEVOSMIES.getAktivoitu(this.pelaaja.getId()) && this.pelaaja.getTalli().getTaso() >= 1) {
            Yksikot.HEVOSMIES.aktivoi(this.pelaaja.getId());
        }
        if (!Yksikot.RITARI.getAktivoitu(this.pelaaja.getId()) && this.pelaaja.getKasarmi().getTaso() >= 4) {
            Yksikot.RITARI.aktivoi(this.pelaaja.getId());
        }
        if (!Yksikot.KATAPULTTI.getAktivoitu(this.pelaaja.getId()) && this.pelaaja.getMachinery().getTaso() >= 1) {
            Yksikot.KATAPULTTI.aktivoi(this.pelaaja.getId());
        }
    }

    public Yksikot getSallitutYksikot() {
        return this.sallitutYksikot;
    }

    public synchronized List<float[]> getHidasteet() {
        return this.hidasteet;
    }

    public synchronized boolean yksikkoAlussa(Yksikko yksikko) {
        for (Yksikko y : this.yksikot) {
            if (!y.getHitbox().intersects(yksikko.getHitbox())) continue;
            return true;
        }
        return false;
    }
}

