/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.rakennukset;

import com.assypeli.domain.Pelaaja;
import com.assypeli.domain.Rakennus;
import com.assypeli.domain.Rakennustiedot;
import com.assypeli.domain.Taika;
import com.assypeli.domain.Yksikko;
import com.assypeli.taikalista.Hidastus;
import com.assypeli.taikalista.Kuolemattomuus;
import com.assypeli.taikalista.Taikalista;
import com.assypeli.taikalista.Vahingoitus;
import java.util.ArrayList;
import java.util.List;

public class Velhotorni
extends Rakennus {
    private List<Taika> taikalista;
    private Pelaaja pelaaja;
    private int tuotanto;
    private float kerroin;
    private boolean keraamagiaa;
    private Magiankeruu magiankeruu;
    private Thread magiathread;
    private Taikalista sallitutTaijat;

    public Velhotorni(Pelaaja pelaaja) {
        super(Rakennustiedot.VELHOTORNI, pelaaja);
        super.setRakennus(this);
        this.taikalista = new ArrayList<Taika>();
        this.pelaaja = pelaaja;
        this.keraamagiaa = false;
        this.kerroin = 1.0f;
        this.magiankeruu = new Magiankeruu();
        this.magiathread = new Thread(this.magiankeruu);
        this.lisaaTaika(new Hidastus(super.getPelaaja()));
        this.lisaaTaika(new Vahingoitus(super.getPelaaja()));
        this.lisaaTaika(new Kuolemattomuus(super.getPelaaja()));
    }

    public void toteutaTaika(Taika taika, Yksikko yksikko) {
        if (this.taikalista.contains(taika)) {
            if (taika.voiToteuttaa()) {
                System.out.println("taika l\u00f6ytyi");
                taika.kulutaMagia();
                taika.toteuta(yksikko);
                taika.asetaCooldown();
            } else {
                System.out.println("ei l\u00f6ydy taikaa");
            }
        }
    }

    public void toteutaTaika(Taika taika, float x) {
        if (this.taikalista.contains(taika) && taika.voiToteuttaa()) {
            taika.kulutaMagia();
            taika.toteuta(x);
            taika.asetaCooldown();
        }
    }

    public void lisaaTaika(Taika taika) {
        this.taikalista.add(taika);
    }

    public void poistaTaika(Taika taika) {
        if (this.taikalista.contains(taika)) {
            this.taikalista.remove(this.taikalista.indexOf(taika));
        }
    }

    public List<Taika> getTaikalista() {
        return this.taikalista;
    }

    public Taika haeTaika(String nimi) {
        for (Taika t : this.taikalista) {
            if (!t.getNimi().equals(nimi)) continue;
            return t;
        }
        return null;
    }

    public float getTuotanto() {
        return (float)this.tuotanto * this.kerroin;
    }

    public void setTuotanto(int tuotanto) {
        this.tuotanto = tuotanto;
    }

    public void hankimagiaa() {
        this.keskeytaMagiankeruu();
        this.magiankeruu = new Magiankeruu();
        this.magiathread = new Thread(this.magiankeruu);
        this.magiathread.start();
        this.keraamagiaa = true;
    }

    public void keskeytaMagiankeruu() {
        this.keraamagiaa = false;
        if (this.magiathread.isAlive()) {
            try {
                this.magiathread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void tarkistaSallitutTaijat() {
        if (!Taikalista.HIDASTUS.getAktivoitu(this.pelaaja.getId())) {
            Taikalista.HIDASTUS.aktivoi(this.pelaaja.getId());
        }
        if (!Taikalista.VAHINGOITUS.getAktivoitu(this.pelaaja.getId()) && this.pelaaja.getVelhotorni().getTaso() >= 1) {
            Taikalista.VAHINGOITUS.aktivoi(this.pelaaja.getId());
        }
        if (!Taikalista.PARANNUS.getAktivoitu(this.pelaaja.getId()) && this.pelaaja.getVelhotorni().getTaso() >= 2) {
            Taikalista.PARANNUS.aktivoi(this.pelaaja.getId());
        }
        if (!Taikalista.KUOLEMATTOMUUS.getAktivoitu(this.pelaaja.getId()) && this.pelaaja.getVelhotorni().getTaso() >= 3) {
            Taikalista.KUOLEMATTOMUUS.aktivoi(this.pelaaja.getId());
        }
    }

    @Override
    public boolean voiRakentaa() {
        return super.getTaso() == 0 ? this.getPelaaja().getKasarmi().getTaso() >= 1 : (super.getTaso() == 1 ? this.getPelaaja().getKaupunki().getTaso() >= 2 : (super.getTaso() == 2 ? this.getPelaaja().getKasarmi().getTaso() >= 2 : super.getTaso() == 3 && this.getPelaaja().getKaupunki().getTaso() >= 3));
    }

    @Override
    public void tarkistaOminaisuudet() {
        switch (super.getTaso()) {
            case 0: {
                super.setVaatimukset("Barracks: 1");
                this.setTuotanto(10);
                break;
            }
            case 1: {
                super.setVaatimukset("Castle: 1");
                this.setTuotanto(15);
                this.haeTaika("Hidastus");
                break;
            }
            case 2: {
                super.setVaatimukset("Barracks: 2");
                this.setTuotanto(20);
                this.haeTaika("Vahingoitus");
                break;
            }
            case 3: {
                super.setVaatimukset("Castle: 3");
                this.setTuotanto(25);
                this.haeTaika("Parannus");
                break;
            }
            case 4: {
                super.setVaatimukset("-");
                this.setTuotanto(30);
                this.haeTaika("Kuolemattomuus");
                break;
            }
            default: {
                super.setVaatimukset("-");
                this.setTuotanto(0);
            }
        }
    }

    public Taikalista getSallitutTaijat() {
        return this.sallitutTaijat;
    }

    private class Magiankeruu
    implements Runnable {
        private Magiankeruu() {
        }

        @Override
        public void run() {
            Velhotorni.this.tarkistaOminaisuudet();
            while (Velhotorni.this.keraamagiaa) {
                try {
                    Thread.sleep(2000L);
                    Velhotorni.this.getPelaaja().getMagiavarasto().lisaa((float)Velhotorni.this.tuotanto * Velhotorni.this.kerroin / 30.0f);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

