/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.rakennukset;

import com.assypeli.domain.Pelaaja;
import com.assypeli.domain.Rakennus;
import com.assypeli.domain.Rakennustiedot;
import com.assypeli.domain.Varasto;

public class Rahavarasto
extends Rakennus
implements Varasto {
    private float maara;
    private int kapasiteetti;

    public Rahavarasto(Pelaaja pelaaja, int maara) {
        super(Rakennustiedot.RAHAVARASTO, pelaaja);
        super.setRakennus(this);
        this.maara = maara;
        this.kapasiteetti = this.laskeKapasiteetti(this.getTaso());
    }

    @Override
    public void lisaa(float maara) {
        this.maara = this.maara + maara <= (float)this.kapasiteetti ? (this.maara += maara) : (float)this.kapasiteetti;
    }

    @Override
    public void vahenna(float maara) {
        if (this.maara - maara >= 0.0f) {
            this.maara -= maara;
        }
    }

    @Override
    public boolean riittaako(int maara) {
        return this.maara >= (float)maara;
    }

    @Override
    public int getMaara() {
        return (int)this.maara;
    }

    @Override
    public int getKapasiteetti() {
        return this.kapasiteetti;
    }

    @Override
    public boolean voiRakentaa() {
        if (this.getPelaaja().getKaupunki().getTaso() >= 1) {
            return true;
        }
        return super.getTaso() == 1 ? this.getPelaaja().getKaupunki().getTaso() >= 2 : (super.getTaso() == 2 ? this.getPelaaja().getKaupunki().getTaso() >= 3 : super.getTaso() == 3 && this.getPelaaja().getKaupunki().getTaso() >= 4);
    }

    @Override
    public void tarkistaOminaisuudet() {
        if (super.getTaso() == 0) {
            super.setVaatimukset("Castle: 1");
        } else if (super.getTaso() == 1) {
            super.setVaatimukset("Castle: 2");
        } else if (super.getTaso() == 2) {
            super.setVaatimukset("Castle: 3");
        } else if (super.getTaso() == 3) {
            super.setVaatimukset("Castle: 4");
        } else {
            super.setVaatimukset("-");
        }
        this.kapasiteetti = this.laskeKapasiteetti(super.getTaso());
    }

    public int laskeKapasiteetti(int taso) {
        switch (taso) {
            case 0: {
                return 80;
            }
            case 1: {
                return 120;
            }
            case 2: {
                return 150;
            }
            case 3: {
                return 180;
            }
            case 4: {
                return 250;
            }
        }
        return 0;
    }
}

