/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.rakennukset;

import com.assypeli.domain.Pelaaja;
import com.assypeli.domain.Rakennus;
import com.assypeli.domain.Rakennustiedot;
import com.assypeli.domain.Varasto;

public class Puuvarasto
extends Rakennus
implements Varasto {
    private int kapasiteetti;
    private float maara;

    public Puuvarasto(Pelaaja pelaaja, int maara) {
        super(Rakennustiedot.PUUVARASTO, pelaaja);
        super.setRakennus(this);
        this.kapasiteetti = this.laskeKapasiteetti(this.getTaso());
        this.maara = maara;
    }

    @Override
    public void lisaa(float maara) {
        this.maara = this.maara + maara <= (float)this.kapasiteetti ? (this.maara += maara) : (float)this.kapasiteetti;
    }

    @Override
    public void vahenna(float maara) {
        if (this.maara - maara >= 0.0f) {
            this.maara -= maara;
        }
    }

    @Override
    public boolean riittaako(int maara) {
        return this.maara >= (float)maara;
    }

    @Override
    public int getMaara() {
        return (int)this.maara;
    }

    @Override
    public int getKapasiteetti() {
        return this.kapasiteetti;
    }

    @Override
    public boolean voiRakentaa() {
        return super.getTaso() == 0 ? this.getPelaaja().getMetsa().getTaso() >= 1 : (super.getTaso() == 1 ? this.getPelaaja().getKaupunki().getTaso() >= 2 : (super.getTaso() == 2 ? this.getPelaaja().getMetsa().getTaso() >= 2 : super.getTaso() == 3 && this.getPelaaja().getKaupunki().getTaso() >= 3));
    }

    @Override
    public void tarkistaOminaisuudet() {
        if (super.getTaso() == 0) {
            super.setVaatimukset("Forest: 1");
        } else if (super.getTaso() == 1) {
            super.setVaatimukset("Castle: 2");
        } else if (super.getTaso() == 2) {
            super.setVaatimukset("Forest: 2");
        } else if (super.getTaso() == 3) {
            super.setVaatimukset("Castle: 3");
        } else {
            super.setVaatimukset("-");
        }
        this.kapasiteetti = this.laskeKapasiteetti(super.getTaso());
    }

    public int laskeKapasiteetti(int taso) {
        switch (taso) {
            case 0: {
                return 70;
            }
            case 1: {
                return 110;
            }
            case 2: {
                return 140;
            }
            case 3: {
                return 170;
            }
            case 4: {
                return 250;
            }
        }
        return 0;
    }
}

