/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.rakennukset;

import com.assypeli.domain.Pelaaja;
import com.assypeli.domain.Rakennus;
import com.assypeli.domain.Rakennustiedot;

public class Metsa
extends Rakennus {
    private int tuotanto;
    private boolean hakkaapuuta;
    private Thread hakkuuthread;
    private Puunhakkuu hakkuu;
    private boolean keskustabonus;
    private float kerroin;

    public Metsa(Pelaaja pelaaja) {
        super(Rakennustiedot.METSA, pelaaja);
        super.setRakennus(this);
        this.hakkaapuuta = false;
        this.keskustabonus = false;
        this.kerroin = 1.0f;
        this.hakkuu = new Puunhakkuu();
        this.hakkuuthread = new Thread(this.hakkuu);
    }

    public float getTuotanto() {
        return (float)this.tuotanto * this.kerroin;
    }

    public void setTuotanto(int tuotanto) {
        this.tuotanto = tuotanto;
    }

    public void hakkaaPuuta() {
        this.keskeytaHakkuu();
        this.hakkuu = new Puunhakkuu();
        this.hakkuuthread = new Thread(this.hakkuu);
        this.hakkuuthread.start();
        this.hakkaapuuta = true;
    }

    public void keskeytaHakkuu() {
        this.hakkaapuuta = false;
        if (this.hakkuuthread.isAlive()) {
            try {
                this.hakkuuthread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void asetaBonus(boolean b) {
        this.keskustabonus = b;
        this.kerroin = b ? 1.2f : 1.0f;
    }

    public boolean getBonus() {
        return this.keskustabonus;
    }

    @Override
    public void tarkistaOminaisuudet() {
        switch (super.getTaso()) {
            case 0: {
                super.setVaatimukset("-");
                this.setTuotanto(40);
                break;
            }
            case 1: {
                super.setVaatimukset("Castle: 1");
                this.setTuotanto(70);
                break;
            }
            case 2: {
                super.setVaatimukset("Castle: 1");
                this.setTuotanto(100);
                break;
            }
            case 3: {
                super.setVaatimukset("Castle: 2");
                this.setTuotanto(130);
                break;
            }
            case 4: {
                super.setVaatimukset("-");
                this.setTuotanto(150);
                break;
            }
            default: {
                super.setVaatimukset("");
                this.setTuotanto(0);
            }
        }
    }

    @Override
    public boolean voiRakentaa() {
        if (super.getTaso() == 0) {
            return true;
        }
        return super.getTaso() == 1 ? this.getPelaaja().getKaupunki().getTaso() >= 1 : (super.getTaso() == 2 ? this.getPelaaja().getKaupunki().getTaso() >= 1 : super.getTaso() == 3 && this.getPelaaja().getKaupunki().getTaso() >= 2);
    }

    static /* synthetic */ boolean access$0(Metsa metsa) {
        return metsa.hakkaapuuta;
    }

    static /* synthetic */ int access$1(Metsa metsa) {
        return metsa.tuotanto;
    }

    static /* synthetic */ float access$2(Metsa metsa) {
        return metsa.kerroin;
    }

    public class Puunhakkuu
    implements Runnable {
        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

