/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.domain;

import com.assypeli.domain.Pelaaja;
import com.assypeli.domain.Taikatyypit;
import com.assypeli.domain.Yksikko;

public abstract class Taika {
    private String nimi;
    private int magia;
    private int cooldown;
    private boolean onkoCooldown;
    private Pelaaja pelaaja;
    private Taikatyypit tyyppi;

    public Taika(String nimi, int magia, int cooldown, Pelaaja pelaaja, Taikatyypit tyyppi) {
        this.nimi = nimi;
        this.magia = magia;
        this.cooldown = cooldown;
        this.pelaaja = pelaaja;
        this.tyyppi = tyyppi;
    }

    public void kulutaMagia() {
        this.pelaaja.getMagiavarasto().vahenna(this.getMagia());
        System.out.println("v\u00e4hennetty" + this.getMagia());
    }

    public String getNimi() {
        return this.nimi;
    }

    public int getMagia() {
        return this.magia;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public Pelaaja getPelaaja() {
        return this.pelaaja;
    }

    public boolean voiToteuttaa() {
        return !this.onkoCooldown && this.pelaaja.getMagiavarasto().getMaara() >= this.getMagia();
    }

    public void toteuta(Yksikko kohde) {
    }

    public void toteuta(float x) {
    }

    public Taikatyypit getTyyppi() {
        return this.tyyppi;
    }

    public void asetaCooldown() {
        this.onkoCooldown = true;
        new Thread(new Cooldown()).start();
    }

    private class Cooldown
    implements Runnable {
        private Cooldown() {
        }

        @Override
        public void run() {
            if (Taika.this.onkoCooldown) {
                try {
                    Thread.sleep(Taika.this.cooldown * 1000);
                    Taika.this.onkoCooldown = false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

