/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.domain;

import com.assypeli.domain.Kaupunki;
import com.assypeli.domain.Rakennus;
import com.assypeli.domain.Taika;
import com.assypeli.domain.Yksikko;
import com.assypeli.domain.YksikkoJono;
import com.assypeli.domain.YksikkoPaivitys;
import com.assypeli.grafiikka.Tekstuurit;
import com.assypeli.paaluokat.Peli;
import com.assypeli.rakennukset.Kasarmi;
import com.assypeli.rakennukset.Kivivarasto;
import com.assypeli.rakennukset.Louhos;
import com.assypeli.rakennukset.Machinery;
import com.assypeli.rakennukset.Magiavarasto;
import com.assypeli.rakennukset.Metsa;
import com.assypeli.rakennukset.Paja;
import com.assypeli.rakennukset.Puuvarasto;
import com.assypeli.rakennukset.Rahavarasto;
import com.assypeli.rakennukset.Talli;
import com.assypeli.rakennukset.Talo;
import com.assypeli.rakennukset.Tykki;
import com.assypeli.rakennukset.Velhotorni;
import com.assypeli.resurssit.Kivi;
import com.assypeli.resurssit.Kulta;
import com.assypeli.resurssit.Puu;
import com.assypeli.resurssit.Resurssi;
import com.assypeli.taikalista.Taikalista;
import com.assypeli.yksikot.YksikonOhjaaja;
import com.assypeli.yksikot.Yksikot;
import java.util.ArrayList;
import java.util.List;

public class Pelaaja {
    private int id;
    private int aloitusKoordinaatti;
    private YksikonOhjaaja yksikonOhjaaja;
    private Kaupunki kaupunki;
    private boolean rakentaa;
    private Peli peli;
    private Tekstuurit tekstuurit;
    private YksikkoJono yksikkojono;
    private Resurssi kulta;
    private Resurssi puu;
    private Resurssi kivi;
    private List<Rakennus> yleisetrakennukset;
    private List<Rakennus> sotilasrakennukset;
    private List<Rakennus> resurssirakennukset;
    private Kasarmi kasarmi;
    private Tykki tykki;
    private Talo talo;
    private Louhos louhos;
    private Metsa metsa;
    private Velhotorni velhotorni;
    private Talli talli;
    private Paja paja;
    private Machinery machinery;
    private Puuvarasto puuvarasto;
    private Kivivarasto kivivarasto;
    private Rahavarasto rahavarasto;
    private Magiavarasto magiavarasto;

    public Pelaaja(int id, Peli peli, int aloituskoordinaatti, Tekstuurit t) {
        this.id = id;
        this.aloitusKoordinaatti = aloituskoordinaatti;
        this.yksikkojono = new YksikkoJono(this, t.getRakennusAikataulu());
        this.rakentaa = false;
        this.peli = peli;
        this.tekstuurit = t;
        this.yleisetrakennukset = new ArrayList<Rakennus>();
        this.sotilasrakennukset = new ArrayList<Rakennus>();
        this.resurssirakennukset = new ArrayList<Rakennus>();
        this.kaupunki = new Kaupunki(this);
        this.kasarmi = new Kasarmi(this);
        this.talo = new Talo(this);
        this.talli = new Talli(this);
        this.metsa = new Metsa(this);
        this.louhos = new Louhos(this);
        this.velhotorni = new Velhotorni(this);
        this.tykki = new Tykki(this);
        this.paja = new Paja(this);
        this.machinery = new Machinery(this);
        this.puuvarasto = new Puuvarasto(this, 10);
        this.rahavarasto = new Rahavarasto(this, 10);
        this.kivivarasto = new Kivivarasto(this, 10);
        this.magiavarasto = new Magiavarasto(this, 0);
        this.louhos.louhi();
        this.metsa.hakkaaPuuta();
        this.kaupunki.keraaRahaa();
        this.yleisetrakennukset.add(this.kaupunki);
        this.yleisetrakennukset.add(this.paja);
        this.sotilasrakennukset.add(this.kasarmi);
        this.sotilasrakennukset.add(this.talli);
        this.sotilasrakennukset.add(this.machinery);
        this.sotilasrakennukset.add(this.tykki);
        this.resurssirakennukset.add(this.metsa);
        this.resurssirakennukset.add(this.louhos);
        this.resurssirakennukset.add(this.rahavarasto);
        this.resurssirakennukset.add(this.puuvarasto);
        this.resurssirakennukset.add(this.kivivarasto);
        for (Rakennus r : this.yleisetrakennukset) {
            r.tarkistaOminaisuudet();
        }
        for (Rakennus r : this.sotilasrakennukset) {
            r.tarkistaOminaisuudet();
        }
        for (Rakennus r : this.resurssirakennukset) {
            r.tarkistaOminaisuudet();
        }
        this.kulta = new Kulta(this, this.rahavarasto);
        this.puu = new Puu(this, this.puuvarasto);
        this.kivi = new Kivi(this, this.kivivarasto);
    }

    public boolean riittaaResurssit(int kulta, int puu, int kivi) {
        return this.rahavarasto.riittaako(kulta) && this.puuvarasto.riittaako(puu) && this.kivivarasto.riittaako(kivi);
    }

    public void kulutaResursseja(int kultah, int puuh, int kivih) {
        this.rahavarasto.vahenna(kultah);
        this.puuvarasto.vahenna(puuh);
        this.kivivarasto.vahenna(kivih);
    }

    public boolean onAktivoitu(Yksikko yksikko) {
        if (yksikko.getNimi() == "Barbarian") {
            this.getYksikonOhjaaja().getSallitutYksikot();
            return Yksikot.NUIJAMIES.getAktivoitu(this.getId());
        }
        if (yksikko.getNimi() == "Swordsman") {
            this.getYksikonOhjaaja().getSallitutYksikot();
            return Yksikot.MIEKKAMIES.getAktivoitu(this.getId());
        }
        if (yksikko.getNimi() == "Archer") {
            this.getYksikonOhjaaja().getSallitutYksikot();
            return Yksikot.JOUSIMIES.getAktivoitu(this.getId());
        }
        if (yksikko.getNimi() == "Spearman") {
            this.getYksikonOhjaaja().getSallitutYksikot();
            return Yksikot.KEIHASMIES.getAktivoitu(this.getId());
        }
        if (yksikko.getNimi() == "Knight") {
            this.getYksikonOhjaaja().getSallitutYksikot();
            return Yksikot.RITARI.getAktivoitu(this.getId());
        }
        if (yksikko.getNimi() == "Cavalry") {
            this.getYksikonOhjaaja().getSallitutYksikot();
            return Yksikot.HEVOSMIES.getAktivoitu(this.getId());
        }
        if (yksikko.getNimi() == "Catapult") {
            this.getYksikonOhjaaja().getSallitutYksikot();
            return Yksikot.KATAPULTTI.getAktivoitu(this.getId());
        }
        return false;
    }

    public boolean onAktivoitu(Taika taika) {
        if (taika.getNimi() == "Hidastus") {
            this.getVelhotorni().getSallitutTaijat();
            return Taikalista.HIDASTUS.getAktivoitu(this.getId());
        }
        if (taika.getNimi() == "Vahingoitus") {
            this.getVelhotorni().getSallitutTaijat();
            return Taikalista.VAHINGOITUS.getAktivoitu(this.getId());
        }
        if (taika.getNimi() == "Parannus") {
            this.getVelhotorni().getSallitutTaijat();
            return Taikalista.PARANNUS.getAktivoitu(this.getId());
        }
        if (taika.getNimi() == "Kuolemattomuus") {
            this.getVelhotorni().getSallitutTaijat();
            return Taikalista.KUOLEMATTOMUUS.getAktivoitu(this.getId());
        }
        return false;
    }

    public void lisaaYksikko(Yksikko yksikko) {
        if (this.onAktivoitu(yksikko)) {
            if (this.riittaaResurssit(yksikko.getRahahinta(), yksikko.getPuuhinta(), yksikko.getKivihinta())) {
                this.kulutaResursseja(yksikko.getRahahinta(), yksikko.getPuuhinta(), yksikko.getKivihinta());
                this.getYksikkojono().lisaaJonoon(yksikko);
            } else if (this.getId() == 1) {
                this.getYksikkojono().lisaaJonoon(yksikko);
                this.kulutaResursseja(this.rahavarasto.getMaara(), this.puuvarasto.getMaara(), this.kivivarasto.getMaara());
            }
        }
    }

    public void kehitaRakennusta(Rakennus rakennus) {
        rakennus.kasvataTasoa();
    }

    public void tutkiPaivitys(YksikkoPaivitys paivitys) {
        if (this.riittaaResurssit(paivitys.getHinnat().getKulta(), paivitys.getHinnat().getPuu(), paivitys.getHinnat().getKivi())) {
            if (!this.getYksikonOhjaaja().getPaivitysohjaaja().getAktivoidutPaivitykset().contains(paivitys)) {
                this.kulutaResursseja(paivitys.getHinnat().getKulta(), paivitys.getHinnat().getPuu(), paivitys.getHinnat().getKivi());
                this.getYksikonOhjaaja().toteutaPaivitys(paivitys);
            }
        } else if (this.getId() == 1) {
            this.getYksikonOhjaaja().toteutaPaivitys(paivitys);
            this.kulutaResursseja(this.rahavarasto.getMaara(), this.puuvarasto.getMaara(), this.kivivarasto.getMaara());
        }
    }

    public boolean onAktivoitu(YksikkoPaivitys paivitys) {
        return this.getYksikonOhjaaja().getPaivitysohjaaja().getAktivoidutPaivitykset().contains(paivitys);
    }

    public void rakenna(Rakennus rakennus) {
        if (!this.rakentaa) {
            this.rakentaa = true;
        }
    }

    public void aktivoiKeskusta(boolean b) {
        this.louhos.asetaBonus(b);
        this.metsa.asetaBonus(b);
        this.kaupunki.asetaBonus(b);
    }

    public void taio(Taika taika, Yksikko yksikko) {
        if (this.onAktivoitu(taika)) {
            this.velhotorni.toteutaTaika(taika, yksikko);
        }
    }

    public void taio(Taika taika, float x) {
        if (this.onAktivoitu(taika)) {
            System.out.println("on1");
            this.velhotorni.toteutaTaika(taika, x);
        }
    }

    public int getId() {
        return this.id;
    }

    public void lisaaYksikonOhjaaja(YksikonOhjaaja ohjaaja) {
        this.yksikonOhjaaja = ohjaaja;
    }

    public void setRakentaa(boolean b) {
        this.rakentaa = b;
    }

    public YksikonOhjaaja getYksikonOhjaaja() {
        return this.yksikonOhjaaja;
    }

    public Kaupunki getKaupunki() {
        return this.kaupunki;
    }

    public YksikkoJono getYksikkojono() {
        return this.yksikkojono;
    }

    public Resurssi getKulta() {
        return this.kulta;
    }

    public Resurssi getPuu() {
        return this.puu;
    }

    public Resurssi getKivi() {
        return this.kivi;
    }

    public Talo getTalo() {
        return this.talo;
    }

    public Kasarmi getKasarmi() {
        return this.kasarmi;
    }

    public Velhotorni getVelhotorni() {
        return this.velhotorni;
    }

    public Louhos getLouhos() {
        return this.louhos;
    }

    public Metsa getMetsa() {
        return this.metsa;
    }

    public Puuvarasto getPuuvarasto() {
        return this.puuvarasto;
    }

    public Kivivarasto getKivivarasto() {
        return this.kivivarasto;
    }

    public Rahavarasto getRahavarasto() {
        return this.rahavarasto;
    }

    public Magiavarasto getMagiavarasto() {
        return this.magiavarasto;
    }

    public Talli getTalli() {
        return this.talli;
    }

    public Tykki getTykki() {
        return this.tykki;
    }

    public Paja getPaja() {
        return this.paja;
    }

    public Machinery getMachinery() {
        return this.machinery;
    }

    public List<Rakennus> getYleisetrakennukset() {
        return this.yleisetrakennukset;
    }

    public List<Rakennus> getSotilasrakennukset() {
        return this.sotilasrakennukset;
    }

    public List<Rakennus> getResurssirakennukset() {
        return this.resurssirakennukset;
    }

    public boolean rakentaa() {
        return this.rakentaa;
    }

    public int getAloituskoordinaatti() {
        return this.aloitusKoordinaatti;
    }

    public Peli getPeli() {
        return this.peli;
    }

    public Tekstuurit getTekstuurit() {
        return this.tekstuurit;
    }
}

