
class Effect;
class ScrollArea;

using std::string;
using std::vector;

class Timeline {
public:
  struct ShowInfoMode {
    enum Enum {
      EFFECTS=0,
      RENDERTARGETS
    };
  };

private:
  float m_startTime;
  float m_endTime;

  float m_currentTime;
  float m_currentTimeStep;

  vector<Effect *> m_effects;

  string m_loadedTimelineFileName;

  ScrollArea *m_pScrollAreaFxList;
  ScrollArea *m_pScrollAreaRtList;

  float m_totalTime;

  ShowInfoMode::Enum m_showInfoMode;

  int m_showRtIndex;

public:

  bool m_bFlushDeviceBetweenEffects;
  bool m_bShowInactiveEffects;
  bool m_bShowEffectsInfo;

  Timeline();
  ~Timeline();

  bool Init(string timelineFile);

  Effect* GetNewDerivedEffect(string effectType);
  bool AddEffect(string fileName, string effectType, float start, float end, vector<string> paramsIn, int clearValue, std::vector<RtBuffer> rt16bBufferNames, bool bDoubleBuffer);

  void SetCurrentTime(float timeAbs, float timeStep);

  bool HandleInputs();
  void AdvanceEffects();
  void RenderEffects();

  // reload the timeline
  void Reload(string timelineFile);

  void SetPrevTotalTime(float totalTime) { m_totalTime = totalTime; }
  float GetPrevTotalTime() { return m_totalTime; }

  void SetShowInfoMode(ShowInfoMode::Enum showInfoMode) { m_showInfoMode = showInfoMode; }

  void SetShowRtIndex(int rtIndex) { m_showRtIndex = rtIndex; }
  void SetShowRtIndexWithToggleToMinus1(int rtIndex) { if (m_showRtIndex==rtIndex) { m_showRtIndex = -1; } else { m_showRtIndex = rtIndex; } }

};


Effect *GetCurrentEffect();