// effect.cpp

#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>


#include <vector>
#include <string>
#include <list>
#include <map>

using std::vector;
using std::string;
using std::list;
using std::map;

#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"
#include "effect.h"


#include "ContextData.h"
#include "DemoContextData.h"

#include "../../demowork/sync/sync.h"


static int s_numEffects = 0;

Effect::Effect() {
  m_startTime = 0.0f;
  m_endTime = 0.0f;
  m_absTime = 0.0f;

  m_clearFlags = 0;
 // m_rt16bBufferName = "";

  char uniqueID[256];
  sprintf(uniqueID, "%d", s_numEffects);
  m_uniqueID = uniqueID;

  s_numEffects++;

  m_timelineType = render;

  m_layout = NULL;

  m_enabled = true;
  m_enabledSyncTrack = NULL;

  m_renderStartTime = 0.0;
  m_renderEndTime = 0.0;

  m_advanceStartTime = 0.0;
  m_advanceEndTime  = 0.0;
}

Effect::~Effect() {

}

void Effect::SetEnableSyncVariable(std::string varName) {
  const struct sync_track *pst = sync_get_track(GetRocket(), varName.c_str(), g_syncEditor);
  m_enabledSyncTrack = pst;
}

extern double fmod_get_row();

bool Effect::GetEnabledFromSync() {
  float v = sync_get_val(m_enabledSyncTrack, fmod_get_row());
  if (v<0.5f) {
    return false;
  }
  return true;
}



bool Effect::ParseFromFile(string fileName) {
  m_layoutFile = fileName;
  m_layout = new EffectLayout(this);
  if (m_layout->readFromFile("", fileName, &m_params)) {
    return true;
  }
  return false;
}


void Effect::SetEffectLayout(EffectLayout *pEffectLayout, string fileName) {
  m_layout = pEffectLayout;
  m_layoutFile = fileName;
}

bool Effect::ReloadLayout() {
  if (m_layout) {
    delete m_layout;
  }
  m_layout = new EffectLayout(this);
  if (m_layout->readFromFile("", m_layoutFile, &m_params)) {
    return true;
  }
  return false;

}

std::string Effect::GetName() {
  if (m_layout) {
    return m_layout->m_effectName; 
  }
  return "";
}


float Effect::GetEffectTime() {
  float result = m_absTime-m_startTime;
  if (result < 0.0f)
    result = 0.0f;
  if (m_absTime > m_endTime)
    result = m_endTime;
  return result;
}

float Effect::GetEffectTimeNormalized() {
  return GetEffectTime()/(m_endTime-m_startTime);
}



void Effect::SetTimeValues(float absTime, float timeStep) {
  m_absTime = absTime;
  m_timeStep = timeStep; 
  m_effectTime = GetEffectTime();
}

bool Effect::IsActive() {
  if (m_absTime >= m_startTime && m_absTime <= m_endTime)
    return true;
  return false;
}

void Effect::SetClearFlags(DWORD clearFlags) {
  m_clearFlags = clearFlags;
}

DWORD Effect::GetClearFlags() {
  return m_clearFlags;
}

const EffectParam *Effect::GetPR() const {
  return m_layout->getRoot();
};


void Effect::SetParams(vector<string> params) {
  m_params.clear();
  for (vector<string>::iterator it = params.begin(); it != params.end(); it++) {
    m_params.push_back(*it);
  }
}

vector<Light> g_lights;

void ResetGlobalLights() {
  g_lights.clear();
}

void AddToGlobalLights(Light *light) {
  g_lights.push_back(*light);
}

vector<Light>* GetGlobalLights() {
  return &g_lights;
}

DWORD Effect::GetD3DBlendFromString(const char *s, DWORD def) {
  if (strcmp(s, "SRC_ALPHA")==0) {
    return D3DBLEND_SRCALPHA;
  } else if (strcmp(s, "ONE")==0) {
    return D3DBLEND_ONE;
  } else if (strcmp(s, "ZERO")==0) {
    return D3DBLEND_ZERO;
  } else if (strcmp(s, "INV_SRC_ALPHA")==0) {
    return D3DBLEND_INVSRCALPHA;
  } else {
    return def; // default
  }
}