// deferred.h

// This class handles deferred rendering setup, rendering and final mixing.
// Made to ease using of deferred rendering and to prevent writing the same code
// multiple times into the actual effect code.

// Basically multiple effect will be sharing the same instance of deferred renderer
// to be able to make deferred rendering from many effects at the same time 
// before mixing the final result.

class Shader;

class Deferred {
private:
  D3DXMATRIXA16 m_matView;
  D3DXMATRIXA16 m_matInvView;
  D3DXMATRIXA16 m_matWVP;
  D3DXMATRIXA16 m_matWorld;
  D3DXMATRIXA16 m_matProj;

  Texture *m_rt16b_depth;
  Texture *m_rt16b_normal;
  Texture *m_rt16b_diffuse;
  Texture *m_rt16b_ambspec;

  Shader *m_mrtDeferred;

  D3DXVECTOR4 m_materialDiffuse;

  std::string m_activeShader;

  bool m_bRenderOnlyDepth;


public:
  Deferred();
  ~Deferred();

  bool Init();
  void ReloadShaders();

  Texture* GetRT16bDepth() { return m_rt16b_depth; }
  void SetRT16bDepth(Texture *pT) { m_rt16b_depth = pT; }

  Texture* GetRT16bNormal() { return m_rt16b_normal; }
  Texture* GetRT16bDiffuse() { return m_rt16b_diffuse; }
  Texture* GetRT16bAmbSpec() { return m_rt16b_ambspec; }

  void SetRenderOnlyDepth(bool b) { m_bRenderOnlyDepth = b; }
  bool GetRenderOnlyDepth() { return m_bRenderOnlyDepth; }

  bool BeginDraw(bool clear = true);
  bool EndDraw();

  bool SetView(D3DXMATRIXA16 *matView);
  bool SetInvView(D3DXMATRIXA16 *matInvView);
  bool SetWorld(D3DXMATRIXA16 *matWorld);
  bool SetProj(D3DXMATRIXA16 *matProj);
  bool SetWVP(D3DXMATRIXA16 *matWVP);
  bool SetWVP(D3DXMATRIXA16 *matWorld, D3DXMATRIXA16 *matView, D3DXMATRIXA16 *matProj);

  void SetTexture(LPDIRECT3DTEXTURE9 lpTex);
  void SetMaterial(const D3DMATERIAL9 *pMaterial);


  D3DXMATRIXA16* GetView() { return &m_matView; }
  D3DXMATRIXA16* GetWVP() { return &m_matWVP; }

  ID3DXEffect *GetEffect() { return m_mrtDeferred->GetEffect(); } 

  bool FlushShader();
  bool BeginShader(const char *tech=NULL);
  std::string GetActiveShader() { return m_activeShader; }
  bool BeginShaderDiffuseOnly();
  bool EndShader();


  bool CheckShadersModifiedOnDisk();

};

Deferred* GetDeferred();