
struct CurvePoint {
  D3DXVECTOR4 m_point;
  D3DXVECTOR4 m_tangent;
  float m_time;
};

class Curve {
private:
  vector<CurvePoint> m_points;

  bool m_dirty;

  int m_loopTimes;

  float m_loopEnd;

  int m_numPoints;

public:
  Curve();
  ~Curve();
  
  int LoadCurve(const char *fileName);

  void AddPoint(float t, D3DXVECTOR3 *p);
  void AddPoint4(float t, D3DXVECTOR4 *p);

  void SetLoop(int loopTimes, float loopEnd) {
    m_loopTimes = loopTimes;
    m_loopEnd = loopEnd;
  }
  void ReCalc();

  D3DXVECTOR3 GetPos(float t);
  D3DXVECTOR4 GetPos4(float t);
  D3DXVECTOR3 GetTan(float t);
  D3DXVECTOR4 GetTan4(float t);

};