#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <sstream>
#include <vector>
#include <list>

using std::vector;

#include "curve.h"

#include "datafile.h"


Curve::Curve() {
  m_dirty = false;
  m_loopTimes = 1;
  m_numPoints = 0;
  m_loopEnd = 10000.0f;
}

Curve::~Curve() {
}

void Curve::AddPoint(float t, D3DXVECTOR3 *p) {
  CurvePoint cp;
  cp.m_point = D3DXVECTOR4(p->x, p->y, p->z, 0.0f);
  cp.m_tangent = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);
  cp.m_time = t;
  m_points.push_back(cp);
  m_numPoints++;
  m_dirty = true;
}

void Curve::AddPoint4(float t, D3DXVECTOR4 *p) {
  CurvePoint cp;
  cp.m_point = *p;
  cp.m_tangent = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);
  cp.m_time = t;
  m_points.push_back(cp);
  m_numPoints++;
  m_dirty = true;
}



void Curve::ReCalc() {
  m_dirty = false;
}

int Curve::LoadCurve(const char *filename) {
	unsigned char *data=NULL;
	unsigned int dataSize=0;
	m_numPoints = 0;
	if (getData(filename,  &data, &dataSize)) {
	  for (int pass=0; pass<2; pass++) {
		  char str[1024];
		  unsigned int dataIndex = 0;
		  unsigned char c;
		  int i=0;

		  float pointRead[6];
		  float numero;

		  int curPoint=0;

		//  if (pass == 1) {
		//    if (numPoints > 3) {
		//	  points = new vec3[numPoints];
		//	  pointData = new vec3[numPoints];
		//    }
		//  }
		  do {
		    c = data[dataIndex];
		    dataIndex++;
		    if (dataIndex <= dataSize) {
			    if ((c != '\n') && (c != EOF)) {
			      if ((c != 10) && (c != 13)) {
				    str[i] = c;
				    i++;
			      }
			    } else {
			      str[i] = 0;
			      i=0;
			      D3DXVECTOR3 point = D3DXVECTOR3(0.0f, 0.0f, 0.f);
			      D3DXVECTOR3 pointData = D3DXVECTOR3(0.0f, 0.0f, 0.0f);

			      for (int ik=0; ik<6; ik++) {
				      pointRead[ik] = 0.0f;
			      }

			      int pI=0;
			      char delims[] = ",";
			      char *result = NULL;
			      result = strtok( str, delims );
			      while( result != NULL ) {
				      std::stringstream ss;
				      ss << result;
				      ss >> numero;
				      if (!ss.fail()) {
				        if (pI<6) {
					      pointRead[pI] = numero;
					      pI++;
				        }
				      }
				      result = strtok( NULL, delims );
			      }
			      if (pass == 0) {
				      if (pI > 3) {
				        m_numPoints++;
				      } else {
				        if (pI == 1) {
					        if ((int)pointRead[0] == 0) {
					        } else if ((int)pointRead[0] == 1) {
					          m_loopTimes=100;
					          //this->mode2D = 0;
					        } else if ((int)pointRead[0] == 2) {
					          m_loopTimes=100;
					          //this->mode2D = 1;
					        }
				        }
				      }
			      }
			      if (pI > 3) {
				      if (pass == 1) {
				        point.x = pointRead[2];
				        point.y = pointRead[3];
				        point.z = pointRead[4];
				    //    m_points.push_back(point);
                AddPoint(pointRead[0], &point);
                // BUGBUG TBD: tension!
				    //    this->pointData[curPoint][0] = pointRead[0]; // timeStamp
				    //    this->pointData[curPoint][1] = pointRead[1]; // tension
				    //    this->pointData[curPoint][2] = 0.0f;

				        curPoint++;
				      }
			      }
			    }
		    }
		  } while (dataIndex < dataSize);
	  }
	}

	return 1;
}



D3DXVECTOR4 cmrs(float u, D3DXVECTOR4 *k0, D3DXVECTOR4 *k1, D3DXVECTOR4 *kt0, D3DXVECTOR4 *kt1) {
  D3DXVECTOR4 res;
  float u2 = u*u;
  float u3 = u2*u;

  res = (*k0)*(2.0f*u3-3.0f*u2+1.0f) +
        (*k1)*(3.0f*u2-2.0f*u3) +
        (*kt0)*(u3-2.0f*u2+u) +
        (*kt1)*(u3-u2);

  return res;
}

D3DXVECTOR4 Curve::GetPos4(float t) {
  if (m_dirty)
    ReCalc();

  float td;
  float u;

  float torig = t;
  int loopingAtRound = (int)(t/m_loopEnd);

  t = (float)((int)(t*10000.0f)%(int)(m_loopEnd*10000.0f))/10000.0f;

  if (m_loopTimes >= 0 && loopingAtRound >= m_loopTimes) {
    if (torig > (m_loopEnd*m_loopTimes+m_points[m_points.size()-1].m_time)) {
      return m_points[m_points.size()-1].m_point;
    }
  }

  int i1;

  int i=0;
  while (i < ((int)m_points.size())) {
    i1 = (i+1);
    float tComp;
    if (i == (m_points.size()-1)) {
      tComp = m_loopEnd;
    } else {
      tComp = m_points[i1].m_time;
    }
    if (t >= tComp) {
      i++;
    } else {
      break;
    }
  }
  /*
  i = i-1;
  if (i<0)
    i = m_points.size()-1;
  */
  i = i%m_points.size();

  i1=i+1;
  i1 = i1%m_points.size();
  if (i1 > i) {
    td = m_points[i1].m_time - m_points[i].m_time;
  } else {
    td = m_points[i1].m_time+(m_loopEnd-m_points[i].m_time);
  }
 
  float td0;
  float td1;




  D3DXVECTOR4 k0, k1;
  D3DXVECTOR4 kDiff;
  D3DXVECTOR4 kt0, kt1;

  k0 = m_points[i].m_point;

  float mulle = 1.0f;
 // if (m_loop) {
  i1 = (i+1)%m_points.size();
  k1 = m_points[i1].m_point;

  kDiff = k1-k0;
  float kLen = D3DXVec4Length(&kDiff);

  float minLength = 0.00001f;
  if (kLen < minLength) {
    return k0;
  }

  int i2 = (i+2)%m_points.size();

  int im1 = i-1;
  if (im1<0)
    im1 = m_points.size()-1;

  if (i > im1) {
    td0 = m_points[i].m_time - m_points[im1].m_time;
  } else {
    td0 = m_points[i].m_time+(m_loopEnd-m_points[im1].m_time);
  }

  if (i2 > i1) {
    td1 = m_points[i2].m_time - m_points[i1].m_time;
  } else {
    td1 = m_points[i2].m_time+(m_loopEnd-m_points[i1].m_time);
  }

 // char kurse[512];
 // sprintf(kurse, "i = %d, td0 %f, td %f, td1 %f\n", i, td0, td, td1);
 // OutputDebugString(kurse);

  D3DXVECTOR4 kDiff0 = k0-m_points[im1].m_point;
  float k0Len = D3DXVec4Length(&kDiff0);
  D3DXVECTOR4 kDiff1 = m_points[i2].m_point-k1;
  float k1Len = D3DXVec4Length(&kDiff1);


  D3DXVECTOR4 ktn0;
  D3DXVECTOR4 ktn1;

  kt0 = (m_points[i1].m_point - m_points[im1].m_point);
  float kt0Len = D3DXVec4Length(&kt0);
  if (kt0Len < minLength) {
    kt0 = m_points[i1].m_point - m_points[i].m_point;
  }

  kt1 = (m_points[i2].m_point - m_points[i].m_point);
  float kt1Len = D3DXVec4Length(&kt1);
  if (kt1Len < minLength) {
    kt1 = m_points[i1].m_point - m_points[i].m_point;
  }

  D3DXVec4Normalize(&ktn0, &kt0);
  D3DXVec4Normalize(&ktn1, &kt1);

  kt0 = ktn0*kLen;
  kt1 = ktn1*kLen;

  u = (t - m_points[i].m_time) / td;


  if (td0 > minLength && td1 > minLength && td>minLength) {
    float ku = 1/td;
    float ku0 = 1/td0;
    float ku1 = 1/td1;

    D3DXVECTOR4 timeT1;
    D3DXVec4Normalize(&timeT1, &D3DXVECTOR4(1.0f, td/td0*k0Len/kLen, 0.0f, 0.0f));
    timeT1 *= 1.0f;

    D3DXVECTOR4 timeT2;
    D3DXVec4Normalize(&timeT2, &D3DXVECTOR4(1.0f, td/td1*k1Len/kLen, 0.0f, 0.0f));
    timeT2 *= 1.0f;

    float verys = 0.00001f;

    float deltase = 1.0f;
    int iters = 0;
    D3DXVECTOR4 ures;
    float itersMul = 1.0f;
    float uOrig = u;

    ures = cmrs(u, &D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), &D3DXVECTOR4(1.0f, 1.0f, 0.0f, 0.0f), &timeT1, &timeT2);
    float virheEnnen = fabs(ures.x-u);

    float deltor = 0.50f;

    int binne = 0;
    int binneLim = 16;

    while ((fabs(deltase) > verys) && iters < 32) {
      ures = cmrs(u, &D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), &D3DXVECTOR4(1.0f, 1.0f, 0.0f, 0.0f), &timeT1, &timeT2);
      deltase = ures.x - uOrig;

      if (binne > binneLim) {
        if ((fabs(deltase) > verys))
          u -= deltase * deltor;
      } else {
        u -= deltase * 0.1f;
      }

      if (binne > binneLim) {
        deltor *= 0.5f;
      }
      binne++;
      iters++;
    }
  //   float virhe = fabs(ures.x-uOrig);
  //  if (virhe < virheEnnen)
     u = ures.y;
  } 

  /*

  float virhe = fabs(ures.x-uOrig);
  char kukke[512];
  sprintf(kukke, "virhe ennen %f, jlkeen %f\n", virheEnnen, virhe);
  OutputDebugString(kukke);
*/

  return cmrs(u, &k0, &k1, &kt0, &kt1);
}

D3DXVECTOR3 Curve::GetPos(float t) {
  D3DXVECTOR4 v4 = GetPos4(t);
  return D3DXVECTOR3(v4.x, v4.y, v4.z);
}

D3DXVECTOR3 Curve::GetTan(float t) {
  if (m_dirty)
    ReCalc();
  return D3DXVECTOR3(m_points[0].m_tangent.x, m_points[0].m_tangent.y, m_points[0].m_tangent.z);
}

D3DXVECTOR4 Curve::GetTan4(float t) {
  if (m_dirty)
    ReCalc();
  return m_points[0].m_tangent;
}



