#pragma once

class ScrollArea {
private:
  int m_visibleWidth;
  int m_visibleHeight;
  int m_contentWidth;
  int m_contentHeight;

  int m_contentMinY;
  int m_contentMaxY;

public:
  int m_posX;
  int m_posY;

  int m_moveXAtMouseDown;
  int m_moveYAtMouseDown;
  bool m_bScrollingWithBar;
  int m_mouseDownAtX;
  int m_mouseDownAtY;

  ScrollArea(); 
  void ResetSize();
  void SetVisibleSize(int width, int height);
  void SetContentAt(int minX, int minY, int maxX, int maxY);

  int GetPosY();
  void SetPosY(int p);
  int GetMaxY();
  int GetContentHeight();
  int GetVisibleHeight();

  void RenderContent(D3DApp *pD3DApp, int top, Texture *pContentTexture);
  void RenderScrollBar(D3DApp *pD3DApp, int top);
};
