#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;
#include "mesh.h"

#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"
#include "deferred.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectCamera.h"

#include "EffectPixSim.h"



void EffectPixSim::Init() {
  if (!m_shader) {
    m_shader = new Shader();
  }
  const EffectParam *ep;
  ep = GetPR()->get("pixsim");
  m_shader->CreateFromFile(g_D3DApp->m_pd3dDevice, ep->getString("shader"));
}

void EffectPixSim::ReloadShaders() {
  Init();
}

bool EffectPixSim::CheckShadersModifiedOnDisk() {
  if (m_shader && m_shader->CheckModifiedOnDisk()) {
    return true;
  }
  return false;
}


void EffectPixSim::Advance() {
}

struct MeshFrame {
  float m_mat[16];
  D3DXVECTOR3 m_position;
  D3DXVECTOR3 m_scale;
  D3DXQUATERNION m_rot;
};

std::vector<MeshFrame> meshFrames;

void addFrameRecursive(const EffectParam *p, LPD3DXFRAME frame, std::string frameNameToFind, D3DXMATRIXA16 *matWorld) {

  while (frame) {
    LPMESHCONTAINER pM =  (LPMESHCONTAINER)frame->pMeshContainer;

    D3DXMATRIXA16 matWorldMy = frame->TransformationMatrix;

    matWorldMy = matWorldMy*(*matWorld);

    if ((strcmp(frameNameToFind.c_str(), "")==0 || strstr(frame->Name, frameNameToFind.c_str()))) {
   //   Light light;
   //   light = *baseLight;

 //     if (!frame->pMeshContainer) {
      if (!pM) {
        D3DXVECTOR3 oScale;
        D3DXQUATERNION oRot;
        D3DXVECTOR3 oTrans;

        D3DXMatrixDecompose(&oScale, &oRot, &oTrans, &matWorldMy);
  /*
        if (p->getN("color") == 0) {
          if (pM->NumMaterials) {
            light.m_color.x = pM->pMaterials9[0].Diffuse.r;
            light.m_color.y = pM->pMaterials9[0].Diffuse.g;
            light.m_color.z = pM->pMaterials9[0].Diffuse.b;
            light.m_color.w = 1.0f;
          }
        }
        */
     //   D3DXVECTOR3 positionToAdd = D3DXVECTOR4(oTrans.x, oTrans.y, oTrans.z, 1.0f)        
    //    AddToGlobalLights(&light);
        MeshFrame mf;
        mf.m_position = oTrans;
        mf.m_rot = oRot;
        mf.m_scale = oScale;
        for (int i=0;i<16;i++){
          mf.m_mat[i] = matWorldMy[i];
        }
        meshFrames.push_back(mf);
      }
    }
    if (frame->pFrameFirstChild) {
      addFrameRecursive(p, frame->pFrameFirstChild, frameNameToFind, &matWorldMy);
    }
    frame = frame->pFrameSibling;
  }

}

void recursiveGlobalAdd(const EffectParam *p, float absTime, std::string fileName, std::string meshName) {
  Mesh *mesh; 

  int meshI = g_D3DApp->addAnimatedMesh(fileName.c_str(), NULL, NULL);
  mesh = g_D3DApp->getMesh(meshI);

  mesh->Update(absTime);

  LPMESHCONTAINER pMesh = (LPMESHCONTAINER)mesh->m_pFirstMesh;

  LPD3DXFRAME frame = mesh->m_pFrameRoot;

  D3DXMATRIXA16 matWorld;

  g_D3DApp->MakeWorldMatrix(&matWorld, 
    &p->getVec3("position"),
    &p->getVec3("scale"),
    &p->getVec3("rotate"));
    
 // D3DXMatrixIdentity(&matWorld);
  addFrameRecursive(p, frame, meshName, &matWorld);

}
/*
void EffectPixSim::RenderLineToPixMap(D3DXVECTOR4 *pPosStart, D3DXVECTOR4 *pPosEnd, D3DXVECTOR4 *pVelStart, D3DXVECTOR4 *pVelEnd, float startIndex, float endIndex) {
  int startRow = startIndex/640;
  int endRow = endIndex/640;

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;

//  m_shader->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
//  m_shader->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);

  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matWVP;

  g_D3DApp->MakeWorldMatrix(&matWorld, 
                          &D3DXVECTOR3(0.0f, startRow, 0.0f), // translate
                          &D3DXVECTOR3(1.0f, (endRow-startRow+1)/480.0f, 1.0f), // scale
                          &D3DXVECTOR3(0.0f, 0.0f, 0.0f)); // rotate


  D3DXMatrixIdentity(&matProj);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);
  pd3dDevice->SetTransform(D3DTS_VIEW, &matProj);
  pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);
  D3DXMatrixIdentity(&matWorld);

  matWVP = matWorld*matProj*matProj;
  
  m_shader->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

  m_shader->GetEffect()->SetFloat("g_lineStartIndex", &startIndex);
  m_shader->GetEffect()->SetFloat("g_lineEndIndex", &endIndex);
  m_shader->GetEffect()->SetVector("g_linePosStart", pPosStart);
  m_shader->GetEffect()->SetVector("g_linePosEnd", pPosEnd);
  m_shader->GetEffect()->SetVector("g_lineVelStart", pVelStart);
  m_shader->GetEffect()->SetVector("g_lineVelEnd", pVelEnd);

}
*/

/*
Basic idea to grow the trees is to emit particles starting from the root of the tree and going with the main branch.
The emitted particles stay almost stationary, the will only increase in size related to their age and move very slowly
to the direction of growth at that point.

tree grow is specified in the effect xml with following parameters
*growthDir: vec3 for the primary direction of growth
*growthDirU: vec3 being in angle towards the growth dir (for example 90 degrees)
*growthDirV: vec3 being in angle towards the growth dir and growthDirU (for example 90 degrees for both)
*growthSpeed: float for the growth speed, units per second into the primary direction
*emitsPerSecond: how many particles are emitted per second
*growthDirVarUVAmp: vec2 amplitude of auto-variance for the growth direction for U & V
*growthDirVarUVFreq: vec2 frequency of auto-variance for the growth direction for U & V
*growthDirVarUVOfs: vec2 offset of auto-variance for the growth direction for U & V
  actual growthDir = primaryGrowthDir + growthDirVarUVAmp.x*sin(growthDirVarUVFreq.x*time+growthDirVarOfs.x)*growthDirU + growthDirVarUVAmp.y*sin(growthDirVarUVFreq.y*time+growthDirVarOfs.y)*growthDirV 
*branchMainTime: float time in seconds when main branch branches
  *branchTimeMul: float multiplier for the child time to emit another child (for example 0.5 could be good)
*branchMainType: int type for branching (0: keep main branch going, 1: main branch stops on this branch)
*maximumBranchLevel: int how many times the tree is going to branch
*branchesNum: int how many branches there are made around the main branch when branching
  (angle is determined by the growthDirU & V)
*mainSize: float size of the emitted particle of the root branch
  *branchSizeMul: float multiplier for the branch size related to the previous level
  *sizeChangeByAge: float how much the size increases related to age in secs
*movePerAge: float how much the position moves compared to the emit pos towards the emit dir related to age in secs

*/

struct NewBranchToAdd {
  TreeBranch *pTB;
  TreeBranch *nb;
};

std::vector<NewBranchToAdd> branchesToAdd;


void EffectPixSim::UpdateTreeBranches() {
  const EffectParam *ep;
  ep = GetPR()->get("pixsim");

  if (!m_bTreeBranchesInited) {
    int shadeNum = GetPR()->getN("pixsim");
    for (int ei=0; ei<shadeNum; ei++) {
      ep = GetPR()->get("pixsim", ei);
      if (ep->getN("growthDir")) {
        TreeBranch *tb = new TreeBranch();
        tb->position=ep->getVec3("growthStartPos");
        tb->growthDir = ep->getVec3("growthDir");
        tb->growthDirU = ep->getVec3("growthDirU");
        tb->growthDirV = ep->getVec3("growthDirV");
        tb->branchAge = ep->getFloat("branchAge");
        tb->branchesNum = ep->getInt("branchesNum");
        tb->branchesLeft = ep->getInt("maximumBranchLevel");
        tb->bornPos = tb->position;
        tb->age=0.0f;
        tb->level=0;
        tb->size=1.0f;
        tb->growthSpeed = ep->getFloat("growthSpeed");
        m_mainTreeBranches.push_back(tb);
      }
    }
    m_bTreeBranchesInited = true;
  }
  branchesToAdd.clear();
  if (m_mainTreeBranches.size()) {
    UpdateRecTreeBranches(&m_mainTreeBranches, 0);
  }
  for (std::vector<NewBranchToAdd>::iterator it=branchesToAdd.begin(); it!=branchesToAdd.end(); it++) {
    (*((*it).pTB)).branches.push_back((*it).nb);
  }
}


void EffectPixSim::UpdateRecTreeBranches(std::vector<TreeBranch*> *tbr, int recurseLevel) {
  if (recurseLevel > 6) {
    return;
  }
  for (std::vector<TreeBranch*>::iterator it=tbr->begin(); it!=tbr->end(); it++) {
    UpdateRecTreeBranches(&(*it)->branches, recurseLevel+1);
    (*it)->position += m_timeStep*(*it)->growthDir*(*it)->growthSpeed;
    if (((*it)->age > (*it)->branchAge)) {
      if ((*it)->branchesLeft==0) {
        (*it)->growthSpeed *= 0.40f;
      }
      if (((*it)->branchesLeft>0)) {
        (*it)->branchesLeft--;
        if ((*it)->branchesLeft<0) {
          (*it)->branchesLeft=0;
        }
        (*it)->age = 0.0f;
        for (int ik=0; ik<(*it)->branchesNum; ik++) {
          TreeBranch *nb = new TreeBranch();
          nb->age = (*it)->age;
          nb->level = (*it)->level+1;
          nb->branchesLeft = (*it)->branchesLeft;
          nb->branchAge = (*it)->branchAge*0.76;
          nb->growthSpeed = (*it)->growthSpeed*0.76;
          nb->age = 0.0f;
          nb->bornPos = (*it)->position;
          nb->branchesNum = (*it)->branchesNum-1;
          nb->position = (*it)->position;
          nb->size = (*it)->size;
          float kooma = (float)ik/(float)(*it)->branchesNum;
          nb->growthDir = (*it)->growthDirU*sin(kooma*2.0f*3.141592f)+(*it)->growthDirV*cos(kooma*2.0f*3.141592f);
          nb->growthDirU = (*it)->growthDir;
          D3DXVec3Cross(&nb->growthDirV, &nb->growthDir, &nb->growthDirU);
          float lensu = D3DXVec3Length(&(*it)->growthDirV);
          float lensuMe = D3DXVec3Length(&nb->growthDirV);
          nb->growthDirV *= lensu/(lensuMe+0.001f);
          NewBranchToAdd kkk;
          kkk.pTB=(*it);
          kkk.nb=nb;
          branchesToAdd.push_back(kkk);
        }
        (*it)->branchesLeft = 0;
        (*it)->growthSpeed = 0.0f;
      }
    }
    (*it)->age += m_timeStep;
  }
}

/*
  for (std::vector<TreeBranch>::iterator it=tbr->begin(); it!=tbr->end(); it++) {
    if ((*it).branchesLeft) {
      UpdateRecTreeBranches(&(*it).branches);
    }
  }
  */

int kountti = 0;

bool EffectPixSim::DrawTreeBranches() {
  kountti = 0;
  if (m_mainTreeBranches.size()) {
    m_shader->Enable();
    DrawRecTreeBranches(&m_mainTreeBranches);
    m_shader->Disable();
    return true;
  }
  return false;
}

void EffectPixSim::DrawRecTreeBranches(std::vector<TreeBranch*> *tbr) {
  const EffectParam *ep;
  ep = GetPR()->get("pixsim");

  m_shader->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
  m_shader->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);

 //return;
    if (kountti>g_D3DApp->m_windowHeight) {
      return;
    }

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;

  for (std::vector<TreeBranch*>::iterator it=tbr->begin(); it!=tbr->end(); it++) {
    D3DXVECTOR3 koope = (*it)->position-(*it)->bornPos;
    float koopelen = D3DXVec3Length(&koope);
    if (koopelen > 0.05f) {
      int numParams = ep->getN("param");
      for (int param=0; param<numParams; param++) {
        const EffectParam *epp = ep->get("param", param);
        std::string name = epp->getString("shader_name");
        D3DXVECTOR4 value = epp->getVec4("value");
        if (strcmp(name.c_str(), "g_outputLinesAndOffset")==0) {
          value.y = value.x*kountti;
        }
        if (strcmp(name.c_str(), "g_emitPos")==0) {
          value.x = (*it)->position.x;
          value.y = (*it)->position.y;
          value.z = (*it)->position.z;
        }
        if (strcmp(name.c_str(), "g_emitLineStartPos")==0) {
          value.x = (*it)->bornPos.x;
          value.y = (*it)->bornPos.y;
          value.z = (*it)->bornPos.z;
        }
        if (strcmp(name.c_str(), "g_emitLineEndPos")==0) {
          value.x = (*it)->position.x;
          value.y = (*it)->position.y;
          value.z = (*it)->position.z;
        }
        m_shader->GetEffect()->SetVector(name.c_str(), &value);
      }
      kountti++;
      if (kountti>g_D3DApp->m_windowHeight) {
        return;
      }
      m_shader->Flush();
      g_D3DApp->drawSquare(1.0f);

      if ((*it)->branches.size()) {
        DrawRecTreeBranches(&(*it)->branches);
      }
    }
  }
}


void EffectPixSim::ClearTreeBranches() {
  m_mainTreeBranches.clear();
}

int EffectPixSim::Render() {
  // piirtoa

  static float effectTimePrev=0.0f;
  if (m_effectTime < effectTimePrev) {
    ClearTreeBranches();
    m_bTreeBranchesInited = false;
    Texture *prt16bpos = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "ps_pos", 1, D3DFMT_A32B32G32R32F); // D3DFMT_A32B32G32R32F); // D3DFMT_A16B16G16R16F);
    Texture *prt16bvel = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "ps_vel", 1, D3DFMT_A32B32G32R32F); // D3DFMT_A32B32G32R32F); // D3DFMT_A16B16G16R16F);
    Texture *prt16bvar = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "ps_var", 1, D3DFMT_A32B32G32R32F); // D3DFMT_A32B32G32R32F); // D3DFMT_A16B16G16R16F);
    g_D3DApp->clearRenderTarget(prt16bpos, D3DCOLOR_RGBA(0,0,0,0));
    g_D3DApp->clearRenderTarget(prt16bvel, D3DCOLOR_RGBA(0,0,0,0));
    g_D3DApp->clearRenderTarget(prt16bvar, D3DCOLOR_RGBA(0,0,0,0));
  }
  effectTimePrev = m_effectTime;

  UpdateTreeBranches();

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;

  const EffectParam *ep;
  ep = GetPR()->get("pixsim");


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);

 // Texture *rt16b_buffer0 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_buffer0", 1, D3DFMT_A16B16G16R16F);
  Texture *rt16b_depth = GetDeferred()->GetRT16bDepth();
  Texture *rt16b_diffuse = GetDeferred()->GetRT16bDiffuse();
  Texture *rt16b_normal = GetDeferred()->GetRT16bNormal();
  Texture *rt16b_ambSpec = GetDeferred()->GetRT16bAmbSpec();



  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_POINT );

  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);


  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matWVP;

  D3DXMatrixIdentity(&matProj);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);
  pd3dDevice->SetTransform(D3DTS_VIEW, &matProj);
  pd3dDevice->SetTransform(D3DTS_WORLD, &matProj);
  D3DXMatrixIdentity(&matWorld);

  matWVP = matWorld*matProj*matProj;

  m_shader->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

  m_shader->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
  m_shader->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);


  D3DXMATRIXA16 matInv;
  D3DXMATRIXA16 matCamProj;
  D3DXMATRIXA16 matCamView;
  D3DXMATRIXA16 matCamViewProj;

  D3DXMatrixPerspectiveFovLH(&matCamProj,  GetGlobalCameraFOV(), g_D3DApp->m_aspectRatio, 0.10f, 10000.0f);
  //pd3dDevice->SetTransform(D3DTS_PROJECTION, &matCamProj);
  matCamView = *GetGlobalCameraView();
  //pd3dDevice->SetTransform(D3DTS_VIEW, &matCamView);

  float itDet = D3DXMatrixDeterminant(&matCamProj);
  D3DXMatrixInverse(&matInv, &itDet, &matCamProj);
  m_shader->GetEffect()->SetMatrix( "g_mInvProj", &matInv);
   itDet = D3DXMatrixDeterminant(&matCamView);
  D3DXMatrixInverse(&matInv, &itDet, &matCamView);
  m_shader->GetEffect()->SetMatrix( "g_mInvView", &matInv);

  int shadeNum = GetPR()->getN("pixsim");

  for (int ei=0; ei<shadeNum; ei++) {
    ep = GetPR()->get("pixsim", ei);

   //  g_D3DApp->setTexture(rt16b_buffer0);
    int bUseDiffuse = ep->getInt("diffuse_on");
    int bUseDepth = ep->getInt("depth_on");
    int bUseNormal = ep->getInt("normal_on");
    int bUseAmbSpec = ep->getInt("ambspec_on");

    int bUseBlend = ep->getInt("blend_on");

    m_shader->GetEffect()->SetFloat("g_time", m_effectTime);


    float timeStep = m_timeStep;
    if (timeStep > 0.2f) {
      timeStep = 0.2f;
    }
    if (timeStep < -0.2f) {
      timeStep = -0.2f;
    }
    m_shader->GetEffect()->SetFloat("g_timeStep", timeStep);


    string blendMode = "";
    if (ep->getN("blend_mode")) {
      blendMode = ep->getString("blend_mode");
    }

    if (bUseDiffuse) {
      m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_diffuse->lpTexture);
    }
    if (bUseDepth) {
      m_shader->GetEffect()->SetTexture("g_tDepth", rt16b_depth->lpTexture);
    }
    if (bUseNormal) {
      m_shader->GetEffect()->SetTexture("g_tNormal", rt16b_normal->lpTexture);
    }
    if (bUseAmbSpec) {
      m_shader->GetEffect()->SetTexture("g_tAmbSpec", rt16b_ambSpec->lpTexture);
    }

    int numParams;

    numParams = ep->getN("texture");
    for (int param=0; param<numParams; param++) {
      const EffectParam *epp = ep->get("texture", param);
      std::string name = epp->getString("shader_name");
      std::string file = epp->getString("file");
      Texture *tex = g_D3DApp->addTexture(file.c_str());
      if (tex) {
        m_shader->GetEffect()->SetTexture(name.c_str(), tex->lpTexture);
      }
    }



    if (bUseBlend) {
      pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);
    } else {
      pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
    }

    if (strcmp(blendMode.c_str(), "add")==0) {
      pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
      pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
    } else {
      pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
      pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
    }

    meshFrames.clear();

    if (ep->getN("file")) {
      std::string fileName = ep->getString("file");
      // recursively add lights from the file
      std::string meshName = ep->getString("mesh_name");
      recursiveGlobalAdd(ep, m_effectTime*0.007, fileName, meshName);
    }
    numParams = ep->getN("param");
    for (int param=0; param<numParams; param++) {
      const EffectParam *epp = ep->get("param", param);
      std::string name = epp->getString("shader_name");
      D3DXVECTOR4 value = epp->getVec4("value");
      m_shader->GetEffect()->SetVector(name.c_str(), &value);
    }


    if (DrawTreeBranches()) {
  
    } else if (meshFrames.size()) {
      // haha, emitterzz come from the mesh!
      m_shader->Enable();

      int meshNumber=0;
      for (std::vector<MeshFrame>::iterator it=meshFrames.begin(); it!=meshFrames.end(); it++) {
        numParams = ep->getN("param");
        for (int param=0; param<numParams; param++) {
          const EffectParam *epp = ep->get("param", param);
          std::string name = epp->getString("shader_name");
          D3DXVECTOR4 value = epp->getVec4("value");
          if (strcmp(name.c_str(), "g_outputLinesAndOffset")==0) {
            value.y = value.x*meshNumber;
          }
          if (strcmp(name.c_str(), "g_emitPos")==0) {
            value.x += (*it).m_position.x;//*meshScale.x;
            value.y += (*it).m_position.y;//*meshScale.y;
            value.z += (*it).m_position.z;//*meshScale.z;
          }
          if (strcmp(name.c_str(), "g_emitLineStartPos")==0) {
            D3DXMATRIXA16 resMat;
            D3DXVECTOR4 poi(0.0f, 0.0f, 0.0f, 1.0f);
            D3DXVECTOR4 tPoi;
            for (int ikr=0;ikr<16;ikr++) {
              resMat[ikr]=(*it).m_mat[ikr];
            }
            D3DXVec4Transform(&tPoi, &poi, &resMat);

            value.x = tPoi.x;
            value.y = tPoi.y;
            value.z = tPoi.z;

          }
          if (strcmp(name.c_str(), "g_emitLineEndPos")==0) {
            D3DXMATRIXA16 resMat;
            D3DXMATRIXA16 rotMat;
         //   D3DXQ
            D3DXVECTOR4 poi(0.0f, -4.0f, 0.0f, 1.0f);
            D3DXVECTOR4 tPoi;
      //      D3DXQuaternionBaryCentric
            for (int ikr=0;ikr<16;ikr++) {
              resMat[ikr]=(*it).m_mat[ikr];
            }
            D3DXVec4Transform(&tPoi, &poi, &resMat);

            value.x = tPoi.x;
            value.y = tPoi.y;
            value.z = tPoi.z;

        //    value.x = (*it).m_position.x;//*meshScale.x;
        //    value.y = (*it).m_position.y;//*meshScale.y;
         //   value.z = (*it).m_position.z;//*meshScale.z;

          }
          m_shader->GetEffect()->SetVector(name.c_str(), &value);
        }
        m_shader->Flush();
        g_D3DApp->drawSquare(1.0f);
        meshNumber++;
      }
      m_shader->Disable();
    } else {
      m_shader->Enable();
      m_shader->Flush();
      g_D3DApp->drawSquare(1.0f);
      m_shader->Disable();
    }

  }

  // End the scene.
  pd3dDevice->EndScene();

  return 1;
}
