struct Texture;

class Particle {
public:
  D3DXVECTOR3 m_position;
  D3DXVECTOR3 m_size;
  D3DXVECTOR4 m_color;
  float m_intensity;
  Texture *m_tex;
  Texture *m_texHeight;

  float m_defDepth;
  float m_defBumpness;

  float m_distance;

  float m_angle;
  float m_angleGrow;

  std::string m_blendMode;
  D3DXVECTOR3 m_ageSizeGrow;
  float m_ageAlphaMul;


  D3DXVECTOR3 m_force;


  D3DXVECTOR3 m_speed;
  float m_visibleAge;
  float m_age;
  float m_ageStart;
};

class Shader;

class EffectPemit : public Effect {
private:
    Shader *m_shader;
public:

  EffectPemit() {
    m_timelineType = render;
  }
  ~EffectPemit() { }


  std::list<Particle> m_particles;


 void RecursiveGlobalParticleAdd(const EffectParam *p, float absTime, std::string fileName, std::string meshName);
 void AddFrameParticles(const EffectParam *p, LPD3DXFRAME frame, std::string frameNameToFind, D3DXMATRIXA16 *matWorld);

  void ReloadShaders();


  void Init();
  void Advance();
  int Render();
};

