
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "mesh.h"
#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"

#include "shader.h"

#include "deferred.h"

#include "effect.h"
#include "EffectPemit.h"
#include "EffectCamera.h"

void EffectPemit::Init() {
  m_shader = new Shader();
  m_shader->CreateFromFile("shaders/particle.fx");

}

void EffectPemit::ReloadShaders() {
  delete m_shader;
  Init();
}


void EffectPemit::Advance() {
}


void EffectPemit::AddFrameParticles(const EffectParam *p, LPD3DXFRAME frame, std::string frameNameToFind, D3DXMATRIXA16 *matWorld) {

  while (frame) {
    LPMESHCONTAINER pM =  (LPMESHCONTAINER)frame->pMeshContainer;

    D3DXMATRIXA16 matWorldMy = frame->TransformationMatrix;

    matWorldMy = matWorldMy*(*matWorld);

    if (strstr(frame->Name, frameNameToFind.c_str())) {

      D3DXVECTOR3 oScale;
      D3DXQUATERNION oRot;
      D3DXVECTOR3 oTrans;


      D3DXMatrixDecompose(&oScale, &oRot, &oTrans, &matWorldMy);

      Particle newParticle;


      int partMax = (int)p->getFloat("particles_max");

      if ((int)m_particles.size() < partMax) {

        int emitsPerSecond = (int)p->getFloat("emits_per_second");

        for (int eee=0; eee<emitsPerSecond; eee++) {
          
          if (p->getN("color") == 0) {
            if (pM->NumMaterials) {
              newParticle.m_color.x = pM->pMaterials9[0].Diffuse.r;
              newParticle.m_color.y = pM->pMaterials9[0].Diffuse.g;
              newParticle.m_color.z = pM->pMaterials9[0].Diffuse.b;
              newParticle.m_color.w = 1.0f;
            }
          } else {
            newParticle.m_color = p->getVec4("color");
          }
          

          newParticle.m_position = oTrans;
          newParticle.m_age = p->getFloat("age")+p->getFloat("age_variance")*(float)rand()/RAND_MAX;
          newParticle.m_ageStart = newParticle.m_age;
          newParticle.m_speed.x = ((float)rand()/RAND_MAX-0.50f)*2.0f;
          newParticle.m_speed.y = ((float)rand()/RAND_MAX-0.50f)*2.0f;
          newParticle.m_speed.z = ((float)rand()/RAND_MAX-0.50f)*2.0f;
          newParticle.m_speed *= p->getFloat("power")+p->getFloat("power_var")*(float)rand()/RAND_MAX;
          newParticle.m_force = p->getVec3("force");
          D3DXVECTOR3 forceVar = p->getVec3("force_var");
          newParticle.m_force.x += forceVar.x*(float)rand()/RAND_MAX;
          newParticle.m_force.y += forceVar.y*(float)rand()/RAND_MAX;
          newParticle.m_force.z += forceVar.z*(float)rand()/RAND_MAX;

          newParticle.m_angle = p->getFloat("particle_angle")+p->getFloat("particle_angle_var")*(float)rand()/RAND_MAX;
          newParticle.m_angleGrow = p->getFloat("particle_angle_grow");


          newParticle.m_blendMode = p->getString("blend");
          newParticle.m_ageSizeGrow = p->getVec3("age_size_grow");
          newParticle.m_ageAlphaMul = p->getFloat("age_alpha_mul");
          newParticle.m_visibleAge = p->getFloat("visible_age");
          
          newParticle.m_intensity = p->getFloat("intensity");

          newParticle.m_color *= newParticle.m_intensity;
          
          Texture *tex = g_D3DApp->addTexture(p->getString("image").c_str());
          newParticle.m_tex = tex;

          newParticle.m_texHeight = tex;
          newParticle.m_defDepth = 5.0f;
          newParticle.m_defBumpness = 5.0f;

          Texture *texHeight = NULL;
          if (p->getN("height")) {
            newParticle.m_texHeight = g_D3DApp->addTexture(p->getString("height").c_str());
            newParticle.m_defDepth = p->getFloat("def_height");
            newParticle.m_defBumpness = p->getFloat("def_bumpness");
          }


          D3DXVECTOR3 pSize = p->getVec3("particle_size");
          D3DXVECTOR3 sizeVar = p->getVec3("particle_size_var");

          float ransu = (float)rand()/RAND_MAX;
          pSize.x += (1.0f+sizeVar.x*ransu);
          pSize.y += (1.0f+sizeVar.y*ransu);

          newParticle.m_size = pSize;

          if ((int)m_particles.size() < partMax) 
            m_particles.push_back(newParticle);
        }
      
      }
    }

    if (frame->pFrameFirstChild) {
      AddFrameParticles(p, frame->pFrameFirstChild, frameNameToFind, &matWorldMy);
    }

    frame = frame->pFrameSibling;
  }

}

void EffectPemit::RecursiveGlobalParticleAdd(const EffectParam *p, float absTime, std::string fileName, std::string meshName) {
  Mesh *mesh; 

  int meshI = g_D3DApp->addAnimatedMesh(fileName.c_str());
  mesh = g_D3DApp->getMesh(meshI);

  mesh->Update(absTime);

  LPMESHCONTAINER pMesh = (LPMESHCONTAINER)mesh->m_pFirstMesh;

  LPD3DXFRAME frame = mesh->m_pFrameRoot;

  D3DXMATRIXA16 matWorld;

  g_D3DApp->MakeWorldMatrix(&matWorld, 
    &p->getVec3("position"),
    &p->getVec3("scale"),
    &p->getVec3("rotate"));

  AddFrameParticles(p, frame, meshName, &matWorld);

}


bool particleSort(Particle a, Particle b) {
  return (a.m_distance > b.m_distance);
}


// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectPemit::Render() {



  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);



  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);



  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  bool deferredParticles = (GetPR()->getFloat("deferred") > 0.5f); 


  if (deferredParticles) {
    if (GetClearFlags()) {
      GetDeferred()->BeginDraw(true);
    } else {
      GetDeferred()->BeginDraw(false);
    }
    pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);

  }


  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 wvp;

  D3DXMATRIXA16 tempMatrix;


  D3DXVECTOR3 vEyePt;
  D3DXVECTOR3 vLookatPt;
  D3DXVECTOR3 vUpVec;


  D3DXMatrixPerspectiveFovLH(&matProj,  GetGlobalCameraFOV(), g_D3DApp->m_aspectRatio, 1.0f, 10000.0f);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);



  matView = *GetGlobalCameraView();
  pd3dDevice->SetTransform(D3DTS_VIEW, &matView);


  matView._11 = 1.0f;
  matView._12 = 0.0f;
  matView._13 = 0.0f;

  matView._21 = 0.0f;
  matView._22 = 1.0f;
  matView._23 = 0.0f;

  matView._31 = 0.0f;
  matView._32 = 0.0f;
  matView._33 = 1.0f;

  float def_height;
  float def_bumpness;

  Texture *tex;
  Texture *height;

  float g_depthClipMul;

  int bGlobalTexChange = 0;


  int num = GetPR()->getN("pemit");
  for (int i=0; i<num; i++) {
    const EffectParam *p;
    p = GetPR()->get("pemit", i);
    if (p->hide == 1)
      continue;

    std::string fileName = p->getString("file");
    std::string meshName = p->getString("emitters");
    RecursiveGlobalParticleAdd(p, m_effectTime, fileName, meshName);

    def_height = p->getFloat("def_height");
    def_bumpness = p->getFloat("def_bumpness");

    tex = g_D3DApp->addTexture(p->getString("image").c_str());
    height = g_D3DApp->addTexture(p->getString("height").c_str());

    bGlobalTexChange = p->getInt("use_global_tex_change");

    g_depthClipMul = p->getFloat("depth_clip_mul");

  }

  D3DXVECTOR3 globalPos = GetPR()->getVec3("global_position");

  if (deferredParticles) {
    m_shader->Enable("RenderDeferred");
  } else {
    m_shader->Enable("Render");
  }

  D3DXVECTOR3 globalForce = GetPR()->getVec3("force");


//  newParticle.m_tex = tex;


  for (std::list<Particle>::iterator it=m_particles.begin(); it!=m_particles.end();) {

    if (m_timeStep >= 0.0f) {
      (*it).m_age -= m_timeStep;
    } 

    (*it).m_speed += ((*it).m_force+globalForce)*m_timeStep;
    (*it).m_position += (*it).m_speed*m_timeStep;

    D3DXVECTOR3 trans = (*it).m_position + globalPos;
    D3DXVECTOR3 rot = D3DXVECTOR3(0.0f, 0.0f, (*it).m_angle);
    D3DXVECTOR3 scale = (*it).m_size;

    scale.x *= (1.0f+((*it).m_ageStart-(*it).m_age)*(*it).m_ageSizeGrow.x);
    scale.y *= (1.0f+((*it).m_ageStart-(*it).m_age)*(*it).m_ageSizeGrow.y);
    scale.z *= (1.0f+((*it).m_ageStart-(*it).m_age)*(*it).m_ageSizeGrow.z);

    rot.z *= (1.0f+((*it).m_ageStart-(*it).m_age)*(*it).m_angleGrow);

    g_D3DApp->MakeWorldMatrix(&matWorld, &trans, &scale, &rot);

    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

    D3DXMATRIXA16 matWV = matWorld*matView; 

    D3DXVECTOR4 transV;
    D3DXVec3Transform(&transV, &trans, &matWV);

    (*it).m_distance = transV.z;

    if ((*it).m_age <= 0.0f) {
      it = m_particles.erase(it);
    } else {
      it++;
    }
  }

  float zsort = GetPR()->getFloat("zsort");

  if (zsort > 0.5f) {
    m_particles.sort(particleSort);
  }
  
  D3DXVECTOR4 texCoordScale = D3DXVECTOR4(1.0f, 1.0f, 1.0f, 1.0f);
  D3DXVECTOR4 texCoordOfs = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);

  m_shader->GetEffect()->SetVector( "g_texCoordScale", &texCoordScale);
  m_shader->GetEffect()->SetVector( "g_texCoordOfs", &texCoordOfs);


  m_shader->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
  m_shader->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);


  Texture *particleTexture = NULL;
  Texture *particleHeightTexture = NULL;

  if (m_particles.size()) {
    if (bGlobalTexChange) {
      particleTexture = tex;
      particleHeightTexture = height;
    } else {
      particleTexture = m_particles.front().m_tex; 
      particleHeightTexture = m_particles.front().m_texHeight; 
    }

    g_D3DApp->setTexture(particleTexture);
    if (deferredParticles) {
      g_D3DApp->setTexture(particleHeightTexture, 1);

    //  m_shader->GetEffect()->SetFloat("g_defHeight", m_particles.front().m_defDepth);
    //  m_shader->GetEffect()->SetFloat("g_defBumpness", m_particles.front().m_defBumpness);

      m_shader->GetEffect()->SetFloat("g_defHeight", def_height);
      m_shader->GetEffect()->SetFloat("g_defBumpness", def_bumpness);

    }

    pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

    if (m_particles.front().m_blendMode == "add") {
      pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
      pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
    } else {
      pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
      pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
    }

    if (deferredParticles) {
      pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
    }
  }

  m_shader->GetEffect()->SetMatrix( "g_mView", &matView );

  for (std::list<Particle>::iterator it=m_particles.begin(); it!=m_particles.end(); it++) {

    // draw

    D3DXVECTOR3 trans = (*it).m_position + globalPos;
    D3DXVECTOR3 rot = D3DXVECTOR3(0.0f, 0.0f, (*it).m_angle);
    D3DXVECTOR3 scale = (*it).m_size;

    scale.x *= (1.0f+((*it).m_ageStart-(*it).m_age)*(*it).m_ageSizeGrow.x);
    scale.y *= (1.0f+((*it).m_ageStart-(*it).m_age)*(*it).m_ageSizeGrow.y);
    scale.z *= (1.0f+((*it).m_ageStart-(*it).m_age)*(*it).m_ageSizeGrow.z);

    rot.z *= (1.0f+((*it).m_ageStart-(*it).m_age)*(*it).m_angleGrow);

    g_D3DApp->MakeWorldMatrix(&matWorld, &trans, &scale, &rot);

    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

    D3DXMATRIXA16 matWVP = matWorld*matView*matProj;

    D3DXVECTOR4 color = (*it).m_color;


    if (deferredParticles) {
      m_shader->GetEffect()->SetMatrix( "g_mWorld", &matWorld );
    }

    m_shader->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

    m_shader->GetEffect()->SetFloat( "g_depthClipMul", g_depthClipMul );


    color.w = ((*it).m_age)*(*it).m_ageAlphaMul;
    float syntyAlpha = ((*it).m_ageStart-(*it).m_age-(*it).m_visibleAge)*(*it).m_ageAlphaMul;
    if (syntyAlpha > 1.0f)
      syntyAlpha = 1.0f;
    if (syntyAlpha < 0.0f)
      syntyAlpha = 0.0f;

    color.w *= syntyAlpha;

    if (color.w > 1.0f)
      color.w = 1.0f;

    m_shader->GetEffect()->SetVector( "g_color", &color);



    m_shader->Flush();
    g_D3DApp->drawSquare(1.0f);

  }

  m_shader->Disable();

  if (deferredParticles) {
    GetDeferred()->EndDraw();
  }



  // End the scene.
  pd3dDevice->EndScene();


  return true;
}
