
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "mesh.h"
#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"
#include "curve.h"
#include "effect.h"
#include "EffectOfs.h"

void EffectOffset::Init() {
}

D3DXVECTOR4 g_offset;

void EffectOffset::Advance() {
}

int EffectOffset::Render() {

  m_position = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);
  const EffectParam *ep;
  ep = GetPR()->get("offset");
  float globalFade;
  m_position = ep->getVec4("position", &globalFade);
  g_offset = g_offset*(globalFade) + m_position;

  return 1;
}

void ResetGlobalOfs() {
  g_offset = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);
}


D3DXVECTOR4* GetGlobalOffset() {
  return &g_offset;
}


