#ifndef EFFECT_LAYOUT_H
#define EFFECT_LAYOUT_H

class EffectLayout;

struct sync_track;

class EffectParam {
public:
  std::list<EffectParam> params;
  std::string name;
  std::string type;
  std::string lang;

  EffectLayout *m_belongsToLayout;

  std::string id; // id for others to reference
  std::string ref;  // reference to some other element

  float start;
  float end;
  float loopEnd;

  float fadeIn;
  float fadeOut;

  float fadeInPow;
  float fadeOutPow;

  int loop;
  int hide;
  std::string fadeInCurve;
  std::string fadeOutCurve;
  std::string clear;

  std::string op;

  std::string valueStr;
  std::vector<std::string> paramNames;
  std::vector<const sync_track*> m_syncTracks;

  std::string m_globalParam;

  float valueVec[4];
  int numVec;





  EffectParam() {
    name = "";
    valueStr = "";
    id = "";
    ref = "";
    valueVec[0] = 0.0f;
    numVec = 0;

    start = -1000.0f;
    end = -1000.0f;
    loopEnd = -1000.0f;

    fadeIn = 0.0f;
    fadeOut = 0.0f;

    fadeInPow = 1.0f;
    fadeOutPow = 1.0f;

    loop = 0;
    hide = 0;
    clear = "";
    op = "+"; // default operator is +
    fadeInCurve = "cubic";
    fadeOutCurve = "cubic";

    m_belongsToLayout = NULL;
  }
  const EffectParam* get(std::string name, int index=0) const;
  const int getN(std::string name) const;

  const float GetDynamicValue(int i) const;


  const D3DXVECTOR3 getVec3(std::string name, float *pGlobalFade=NULL) const;
  const D3DXVECTOR4 getVec4(std::string name, float *pGlobalFade=NULL, D3DXVECTOR4 *pDefaultValue=NULL) const;

  const float getFloat(std::string name, float defaultValue=0.0f) const;
  const int getInt(std::string name) const;
  const string getString(std::string name) const;

  const void GetFadeParams(float *fade, int *isOn, float *modTime, float *startTime, float *endTime, float freq=1.0f) const;
  
  const float getValue(int i) const;

  const EffectParam* getById(std::string id) const;
  const EffectParam* getByNameAndId(std::string name, std::string id) const;


};

class EffectLayout;

class TiXmlNode;
class Effect;

class EffectLayout {
private:
  int readVec(std::string s, float *v2);
  int readParams(std::string s, std::vector<std::string> *params);
  bool readFloat(std::string s, float *v);
  bool readInt(std::string s, int *v);

  EffectParam m_paramRoot;


//  void AddRecursiveStructure(const TiXmlNode *pn, EffectElement *le, EffectParam *lft, std::vector<std::string> *paramsIn, int level=0);
  void AddRecursiveStructure(const TiXmlNode *pn, EffectParam *lft, std::vector<std::string> *paramsIn, int level=0, std::string effectName="");



//  std::vector<EffectElement> elements;
  std::string m_rootDir;
  std::string m_aspectRatioString;
  std::string m_effectType;

public:
  Effect *m_belongsToEffect;

  std::string m_effectName;

  EffectLayout();
  EffectLayout(Effect *belongsToEffect);
  ~EffectLayout();

  void SetBelongsToEffect(Effect *pEffect) {
    m_belongsToEffect = pEffect;
  }

  std::string GetEffectType() {
    return m_effectType;
  }

  int readFromFile(std::string rootDir, std::string xmlFile, std::vector<std::string> *paramsIn);


  const EffectParam* getRoot() const {
    return &m_paramRoot;
  }

  std::string layoutFile;
};


void SetGlobalFloatParam(const char *s, float p);
void SetGlobalFloatParamVec4(const char *s, D3DXVECTOR4 *pParam);


#endif
