
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"
#include "deferred.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectGlow.h"

void EffectGlow::Init() {
  if (!m_shader) {
    m_shader = new Shader();
  }
  m_shader->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/glow.h");
}

void EffectGlow::ReloadShaders() {
  Init();
}

bool EffectGlow::CheckShadersModifiedOnDisk() {
  if (m_shader && m_shader->CheckModifiedOnDisk()) {
    return true;
  }
  return false;
}

void EffectGlow::Advance() {
}

// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectGlow::Render() {
  // piirtoa

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;

  Texture *pRtAtStart = g_D3DApp->GetPtrPrevSetRT();


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);

  const EffectParam *ep;
  ep = GetPR()->get("glow");


  Texture *rt16b_buffer0 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, ep->getString("input"), 1, D3DFMT_A16B16G16R16F); // D3DFMT_A16B16G16R16F);

 // Texture *rt16b_depth = GetDeferred()->GetRT16bDepth();
 // Texture *rt16b_normal = GetDeferred()->GetRT16bNormal();

  Texture *rt16b_depth = GetDeferred()->GetRT16bDepth();
  Texture *rt16b_normal = GetDeferred()->GetRT16bNormal();
  m_shader->GetEffect()->SetTexture("g_tDepth", rt16b_depth->lpTexture);
  m_shader->GetEffect()->SetTexture("g_tNormal", rt16b_normal->lpTexture);


  int glowResDiv = (int)ep->getFloat("resdiv");
  int glowIter = (int)ep->getFloat("iter");

  Texture *rt16b_bufferGlow0 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth/glowResDiv, g_D3DApp->m_windowHeight/glowResDiv, "rt16b_bufferGlow0", 1, D3DFMT_A16B16G16R16F); // D3DFMT_A16B16G16R16F);
  Texture *rt16b_bufferGlow1 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth/glowResDiv, g_D3DApp->m_windowHeight/glowResDiv, "rt16b_bufferGlow1", 1, D3DFMT_A16B16G16R16F); // D3DFMT_A16B16G16R16F);

  Texture *rt16b_buffer0halves[32];

  int halva = 2;
  int numHalves = (int)ep->getFloat("halves");
  bool bUseHalves = false;

  if (numHalves)
    bUseHalves = true;

  if (bUseHalves) {

    for (int ha=0; ha<numHalves; ha++) {
      char halveName[512];
      sprintf(halveName, "rt16b_buffer0half%d", ha);
      rt16b_buffer0halves[ha] = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth/halva, g_D3DApp->m_windowHeight/halva, halveName, 1, D3DFMT_A16B16G16R16F); // D3DFMT_A16B16G16R16F);
      halva*=2;
    }
  }

  HRESULT hr = pd3dDevice->BeginScene();
  if (FAILED(hr)) {
    return hr;
  }
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZENABLE, false);
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_POINT );

  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matWVP;

  D3DXMatrixIdentity(&matProj);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);
  pd3dDevice->SetTransform(D3DTS_VIEW, &matProj);
  pd3dDevice->SetTransform(D3DTS_WORLD, &matProj);
  D3DXMatrixIdentity(&matWorld);

  matWVP = matWorld*matProj*matProj;

  g_D3DApp->resetRenderTarget();
  g_D3DApp->setTexture(rt16b_buffer0);

  m_shader->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );
  m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_buffer0->lpTexture);
  m_shader->GetEffect()->SetTexture("g_tDiffuseOrig", rt16b_buffer0->lpTexture);


  m_shader->GetEffect()->SetFloat( "g_windowWidth", (float)g_D3DApp->m_windowWidth);
  m_shader->GetEffect()->SetFloat( "g_windowHeight", (float)g_D3DApp->m_windowHeight);


  m_shader->GetEffect()->SetFloat( "g_glowExponent", ep->getFloat("exponent"));
  m_shader->GetEffect()->SetFloat( "g_glowLowLimit", ep->getFloat("low_limit"));
  m_shader->GetEffect()->SetFloat( "g_glowPreMul", ep->getFloat("pre_mul"));


  g_D3DApp->setRenderTarget(rt16b_bufferGlow0);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
  m_shader->Enable("RenderPlain");
  g_D3DApp->drawSquare(1.0f);
  m_shader->Disable();
  g_D3DApp->resetRenderTarget();

  if (bUseHalves) {
  // halve down
    m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_buffer0->lpTexture);
    int halver = 2;
    for (int ha=0; ha<numHalves; ha++) {
      m_shader->GetEffect()->SetFloat( "g_windowWidth", (float)g_D3DApp->m_windowWidth/halver);
      m_shader->GetEffect()->SetFloat( "g_windowHeight", (float)g_D3DApp->m_windowHeight/halver);
      halver*=2;
      g_D3DApp->setRenderTarget(rt16b_buffer0halves[ha]);
      pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
      m_shader->Enable("RenderBlit");
      g_D3DApp->drawSquare(1.0f);
      m_shader->Disable();
      g_D3DApp->resetRenderTarget();
      m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_buffer0halves[ha]->lpTexture);
    }
    m_shader->GetEffect()->SetTexture("g_tDiffuseOrig", rt16b_buffer0halves[numHalves-1]->lpTexture);
    m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_buffer0->lpTexture);
  }

  D3DXVECTOR4 gSize = ep->getVec4("size");
  D3DXVECTOR4 blurLoopBase = D3DXVECTOR4(1.9f, 1.9f, 0.0f, 0.0f);
  D3DXVECTOR4 blurLoopMul = D3DXVECTOR4(0.55f, 0.55f, 0.0f, 0.0f);

  if (ep->getN("blur_loop_base"))
    blurLoopBase = ep->getVec4("blur_loop_base");

  if (ep->getN("blur_loop_mul"))
    blurLoopMul = ep->getVec4("blur_loop_mul");

  std::string blurShape = "cross";

  if (ep->getN("shape"))
    blurShape = ep->getString("shape");

  float glowMulFactor = 1.0f;
  if (ep->getN("iter_brightness_mul")) {
    glowMulFactor = ep->getFloat("iter_brightness_mul");
  }
  m_shader->GetEffect()->SetFloat("g_glowMulFactor", glowMulFactor);

  D3DXVECTOR4 glowDisp = ep->getVec4("disp");
  glowDisp.w = 0.0f;
  m_shader->GetEffect()->SetVector( "g_glowCurrentDisp", &glowDisp);

  float glowBaseAngle = ep->getFloat("base_angle");
  m_shader->GetEffect()->SetFloat( "g_glowBaseAngle", glowBaseAngle);

  float glowDispTexMul = ep->getFloat("disp_texmul");
  m_shader->GetEffect()->SetFloat( "g_glowCurrentDispTexCoordMul", glowDispTexMul);

  float glowAngleTexMul = ep->getFloat("angle_texmul");
  m_shader->GetEffect()->SetFloat( "g_glowAngleTexCoordMul", glowAngleTexMul);

  bool bRenderNormalsBlur = false;

  if (blurShape == "cross") {
    m_shader->Enable("RenderBlurCross");
  } else if (blurShape == "box") {
    m_shader->Enable("RenderBlurBox");
  } else if (blurShape == "line") {
    m_shader->Enable("RenderBlurLine");
  } else if (blurShape == "stream") {
    m_shader->Enable("RenderBlurStream");
  } else if (blurShape == "god_rays") {
    m_shader->Enable("RenderBlurGodRays");
  } else if (blurShape == "normals") {
    m_shader->Enable("RenderBlurNormals");
    bRenderNormalsBlur = true;
  } else if (blurShape == "norm") {
    m_shader->Enable("RenderBlurNorm");
    bRenderNormalsBlur = true;
  }

  int numParams = ep->getN("param");
  for (int param=0; param<numParams; param++) {
    const EffectParam *epp = ep->get("param", param);
    std::string name = epp->getString("shader_name");
    D3DXVECTOR4 value = epp->getVec4("value");
    m_shader->GetEffect()->SetVector(name.c_str(), &value);
  }
    


  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
  for (int gi=0; gi<glowIter; gi++) {
    m_shader->GetEffect()->SetFloat( "g_windowWidth", (float)g_D3DApp->m_windowWidth/glowResDiv);
    m_shader->GetEffect()->SetFloat( "g_windowHeight", (float)g_D3DApp->m_windowHeight/glowResDiv);
    D3DXVECTOR4 glowSize = D3DXVECTOR4(gSize.x*(blurLoopBase.x+gi*gi*blurLoopMul.x)/g_D3DApp->m_windowWidth, gSize.y*(blurLoopBase.y+gi*blurLoopMul.y)/g_D3DApp->m_windowHeight, gSize.z, 0.0f);
    m_shader->GetEffect()->SetVector("g_glowSize", &glowSize);
    if (gi & 1) {
      g_D3DApp->setRenderTarget(rt16b_bufferGlow0);
      m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_bufferGlow1->lpTexture);
    } else {
      g_D3DApp->setRenderTarget(rt16b_bufferGlow1);
      m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_bufferGlow0->lpTexture);
    }
    m_shader->Flush();
    g_D3DApp->drawSquare(1.0f);
    g_D3DApp->resetRenderTarget();
  }
  m_shader->Disable();

  m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_bufferGlow0->lpTexture);

  m_shader->GetEffect()->SetFloat( "g_windowWidth", (float)g_D3DApp->m_windowWidth);
  m_shader->GetEffect()->SetFloat( "g_windowHeight", (float)g_D3DApp->m_windowHeight);


  std::vector<RtBuffer> rt16bBufferNames = GetRT16bBufferNames();
  if (rt16bBufferNames.size()) {
    rt16b_buffer0 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, rt16bBufferNames[0].m_name, 0, rt16bBufferNames[0].m_fmt); //D3DFMT_A16B16G16R16F);
  }
 // g_D3DApp->setRenderTarget(rt16b_buffer0);
 // pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_RGBA(0, 0, 0, 0), 1.0f, 0 );
 //  g_D3DApp->setTexture(rt16b_buffer0);

  g_D3DApp->resetRenderTarget();
  if (pRtAtStart) {
    g_D3DApp->setRenderTarget(pRtAtStart, 0);
  }

  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, GetD3DBlendFromString(ep->getString("blend_src").c_str()));
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, GetD3DBlendFromString(ep->getString("blend_dst").c_str()));

  D3DXVECTOR4 glowColor = ep->getVec4("color");
  glowColor = glowColor*ep->getFloat("intensity");
  m_shader->GetEffect()->SetVector("g_glowColor", &glowColor);

  float blendAlpha = ep->getFloat("blend_alpha", 1.0f);
  m_shader->GetEffect()->SetFloat("g_glowAlpha", blendAlpha);

  if (bRenderNormalsBlur) {
    pd3dDevice->SetRenderState(D3DRS_COLORWRITEENABLE, D3DCOLORWRITEENABLE_GREEN+D3DCOLORWRITEENABLE_RED);
    pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
  }
  m_shader->Enable("RenderGlowMix");
  g_D3DApp->drawSquare(1.0f);
  m_shader->Disable();
  if (bRenderNormalsBlur) {
    pd3dDevice->SetRenderState(D3DRS_COLORWRITEENABLE, D3DCOLORWRITEENABLE_ALPHA+D3DCOLORWRITEENABLE_BLUE+D3DCOLORWRITEENABLE_GREEN+D3DCOLORWRITEENABLE_RED);
  }

  // End the scene.
  pd3dDevice->EndScene();
/*

  m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_buffer0halves[numHalves-1]->lpTexture);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);
  m_shader->Enable("RenderBlit");
  g_D3DApp->drawSquare(1.0f);
  m_shader->Disable();
//  g_D3DApp->resetRenderTarget();

*/
/*
  g_D3DApp->resetRenderTarget();
  g_D3DApp->setRenderTarget(rt16b_buffer_real0);
*/
  return 1;
}
