

class Shader;

class Ammo {
private:
  D3DXVECTOR4 m_position;
  D3DXVECTOR4 m_speed;
  D3DXVECTOR4 m_force;
  D3DXVECTOR4 m_color;
  float m_energy;

  float m_lifeTime;

  D3DXVECTOR4 m_externalForce;

  bool m_bCarryingEnergy;

public:

  Ammo(D3DXVECTOR4 initialPos, D3DXVECTOR4 initialSpeed, float energy,  D3DXVECTOR4 color) {
    m_position = initialPos;
    m_speed = initialSpeed;
    m_force = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);
    m_color = color;
    m_energy = energy;
    m_lifeTime = 0.0f;
    m_bCarryingEnergy = false;
  }

  D3DXVECTOR4 GetPosition() const { return m_position; }
  D3DXVECTOR4 GetSpeed() const { return m_speed; }
  float GetEnergy() const { return m_energy; }
  float GetLifeTime() const { return m_lifeTime; }

  void AddEnergy(float e) { m_energy += e; }

  bool IsBackToShip(D3DXVECTOR4 shipPosition, float shipEnergy);
  bool IsHittingShip(D3DXVECTOR4 shipPosition, float shipEnergy);

  bool CarryingEnergy() { return m_bCarryingEnergy; }
  void SetCarryingEnergy() { m_bCarryingEnergy = true; }

  void AddForce(D3DXVECTOR4 force);

  // advance calculates the force based on the main movement and sets the force as zero in the end
  void Advance(float timeAbs, float timeStep);
  void Render();

};

class Ship {
private:
  D3DXVECTOR4 m_position;
  D3DXVECTOR4 m_speed;
  D3DXVECTOR4 m_force;
  D3DXVECTOR4 m_color;

  D3DXVECTOR4 m_externalForce;

  float m_energy;

  float m_moveForce;


  bool m_bIsComputer;
  float m_computerBravenessUpdateTime;
  float m_computerBraveness;
  float m_computerNextShootTime;
  bool m_bComputerMoveLeft;
  bool m_bComputerMoveRight;
  bool m_bComputerMoveUp;
  bool m_bComputerMoveDown;

  float m_computerUpdateDirTime;
  int m_computerMoveLeftRight;
  int m_computerMoveUpDown;




  float m_weaponEnergyPercent;
  float m_weaponThresholdVelocity;
  float m_weaponBackToMamaTime;
  float m_weaponBackToShipForce;
  float m_weaponShootSpeedFactor;

  bool m_bIsDead;

  float m_minEnergyLimit;


  std::vector<Ammo> m_ammos;

public:

  Ship(D3DXVECTOR4 initialPos, bool bIsComputer, D3DXVECTOR4 initialSpeed, float energy, float moveForce, D3DXVECTOR4 color) {
    m_position = initialPos;
    m_speed = initialSpeed;
    m_force = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);
    m_color = color;
    m_moveForce = moveForce;
    m_energy = energy;

    m_weaponEnergyPercent = 0.15f;
    m_weaponThresholdVelocity = 64.0f;
    m_weaponBackToMamaTime = 0.50f;
    m_weaponShootSpeedFactor = 8.0f;
    m_weaponBackToShipForce = 256.0f;

    m_bIsComputer = bIsComputer;
    m_computerBraveness = 0.0f;
    m_computerBravenessUpdateTime = 0.0f;
    m_computerNextShootTime = 0.0f;
    m_computerUpdateDirTime = 0.0f;
    m_computerMoveLeftRight = 1;
    m_computerMoveUpDown = 1;

    m_bIsDead = false;
    m_minEnergyLimit = 0.15f;

  }

  void AddForce(D3DXVECTOR4 force);

  void MoveRight();
  void MoveLeft();
  void MoveUp();
  void MoveDown();

  bool GetIsComputer() { return m_bIsComputer; }
  D3DXVECTOR4 GetPosition() { return m_position; }
  D3DXVECTOR4 GetSpeed() { return m_speed; }
  float GetEnergy() { return m_energy; }

  float RemoveEnergy(float e) {
    float energyRemoved = e;
    m_energy -= e;
    if (m_energy <= m_minEnergyLimit) {
      energyRemoved += m_minEnergyLimit-m_energy;
      m_energy = m_minEnergyLimit;
      m_bIsDead = true;
    }
    return energyRemoved;
  }

  void Approach(D3DXVECTOR4 *v);
  void Flee(D3DXVECTOR4 *v);

  const std::vector<Ammo> *GetAmmos() const { return &m_ammos; }


  // Shoot out energy ammo of the given percentage of own energy
  // shot is made into the direction of the current movement
  // if not moving above the threshold speed, shot not possible
  // shootSpeedFactor is the multiplier to multiply ships speed given as initial speed of the ammo
  bool Shoot(); 

  // advance calculates the force based on the main movement and sets the force as zero in the end
  void Advance(float timeAbs, float timeStep, std::vector<Ship*> otherShips, const EffectParam *epGame, const EffectParam *epShip);
  void Render();

};

class EffectGameProto : public Effect {
private:
  std::vector<Ship*> m_playerShips;

  LPD3DXMESH m_meshPlayerName;

  float m_currentCamMultiplier;
  D3DXVECTOR3 m_avp;

public:
  EffectGameProto() {
    m_timelineType = render;
  }
  ~EffectGameProto() { }

  bool HandleInput();

  void Init();
  void Advance();
  int Render();

  void ReloadShaders() {}
  bool CheckShadersModifiedOnDisk() {return false;}

};