
class Shader;


#include "Physics.h"

struct RectArea {
  D3DXVECTOR3 m_posTopLeft;
  D3DXVECTOR3 m_posBottomRight;
};

class GameCubicleLevel {
private:
  std::string m_name;
  std::string m_description;

  RectArea m_tykkiArea;
  D3DXVECTOR3 m_tykkiPos; // constrained by m_tykkiArea
  int m_moveMode;

  float m_tykkiAngle; // -1.0 ... 1.0 
  float m_tykkiPower; // 0.0 ... 1.0  -> 0.0 drop, 1.0 full power
  float m_tykkiPowerMax;

  const EffectParam *m_epTykkiMesh;
  Mesh *m_pTykkiMesh;

  PhysicsGrid m_physicsGrid;
  std::vector<PhysicsParticleCollection*> m_physicsParticleCollections;

  const EffectParam *m_epLevel;
  const EffectParam *m_epGame;

  PhysicsParticleCollection *m_pNextBlock;

public:

  GameCubicleLevel() {
    m_pNextBlock = NULL;
    m_moveMode = 0;
  }
  ~GameCubicleLevel() { FreeAll(); }

  bool Init(const EffectParam *epLevel, const EffectParam *epGame);
  bool Reload(const EffectParam *epLevel, const EffectParam *epGame);
  void FreeAll();

  void Advance(float timeAbs, float timeStep);
  void Render(D3DXMATRIXA16 *pMatWorld, D3DXMATRIXA16 *pMatProj);

  std::string GetName();
  std::string GetDescription();
};


class EffectGameCubicle : public Effect {
private:

  // LPD3DXMESH m_meshPlayerName;

//  PhysicsGrid m_physicsGrid;
//  std::vector<PhysicsParticleCollection*> m_physicsParticleCollections;

  std::vector<GameCubicleLevel *> m_levels;  
  int m_currentLevelIndex;


public:
  EffectGameCubicle();
  ~EffectGameCubicle();

  bool HandleInput();

  void Init();
  void Advance();
  int Render();

  bool ReloadEffect();

  void ReloadShaders() {}
  bool CheckShadersModifiedOnDisk() {return false;}


};