
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>
#include <string>

#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"

#include "shader.h"

#include "effect.h"
#include "effectFFT.h"
#include "effectCamera.h"

#include "ContextData.h"
#include "DemoContextData.h"

#include "fmod.h"
#include "music.h"


void EffectFFT::Init() {
}

void EffectFFT::Advance() {
}


// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectFFT::Render() {
  // piirtoa

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_MIRROR);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_MIRROR);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);


  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);

  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 tempMatrix;

  const EffectParam *ep;

  D3DXVECTOR3 vEyePt;
  D3DXVECTOR3 vLookatPt;
  D3DXVECTOR3 vUpVec;


 // D3DXMatrixPerspectiveFovLH(&matProj, D3DX_PI*0.5f, g_D3DApp->m_aspectRatio, 0.10f, 10000.0f);
 // pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);

  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);

  int numEffects = GetPR()->getN("fft");

  for (int effectI=0; effectI<numEffects; effectI++) {

    ep = GetPR()->get("fft", effectI);

    if (ep->hide == 1) {
      continue;
    }

    std::string outTextureName = "rt16b_spectrum";
    if (ep->getN("output")) {
      outTextureName = ep->getString("output");
    }
    std::string outTextureSysName = outTextureName+"_spectrum";

    float gainLog = 500.0f;
    float gain = 1.0f;
    float releaseSpeed = 23.0f;
    
    if (ep->getN("gainLog")) {
      gainLog = ep->getFloat("gainLog");
    }
    if (ep->getN("gain")) {
      gain = ep->getFloat("gain");
    }
    if (ep->getN("releaseSpeed")) {
      releaseSpeed = ep->getFloat("releaseSpeed");
    }


    Texture *rt16b_spectrum = g_D3DApp->createRenderTarget(2048, 32, outTextureName, 0, D3DFMT_A32B32G32R32F); // , USAGE_DYNAMIC, D3DPOOL_MANAGED);
    Texture *rt16b_spectrum_sysmem = g_D3DApp->createRenderTarget(2048, 32, outTextureSysName, 0, D3DFMT_A32B32G32R32F, D3DUSAGE_DYNAMIC, D3DPOOL_SYSTEMMEM);

    static float spectrumArray[2048];
    static bool bSpectrumInited = false;

    if (!bSpectrumInited) {
      bSpectrumInited = true;
      for (int i=0; i<2048; i++) {
        spectrumArray[i] = 0.0f;
      }
      g_D3DApp->clearRenderTarget(rt16b_spectrum, D3DCOLOR_ARGB(0,0,0,0));
    }
    
    D3DLOCKED_RECT lockedRect;
    hr = rt16b_spectrum_sysmem->lpTexture->LockRect(0, &lockedRect, NULL, D3DLOCK_DISCARD);
    if (hr==D3D_OK) {
      DemoContextData *cd = (DemoContextData*)GetCurrentContextData();
      if (cd->m_demoMusic) {
        float spectrumArrayNew[2048];
        float spectrumArrayPrev[2048];
        cd->m_demoMusic->GetMusicSpectrum(spectrumArrayNew, FMOD_DSP_FFT_WINDOW_HANNING, 2048);

        // put new values into the spectrum array
        for (int i=0;i<2048; i++) {
          float oldValue = spectrumArray[i];
          spectrumArrayPrev[i] = oldValue;
          float newValue = spectrumArrayNew[i];
          float value = oldValue-cd->m_timeStep*releaseSpeed;
          if (value < 0.0f || value > 10000.0f) {
            value = 0.0f;
          }
          newValue = gain*(float)log10(gainLog*newValue)*2.0f;
          if (newValue > oldValue) {
            value = newValue;
          }
          spectrumArray[i] = value;
        }

        float *pPixels = (float*)lockedRect.pBits;
        for (int i=0;i<2048; i++) {
          float specValue = spectrumArray[i];
          pPixels[i*4] = specValue;
          pPixels[i*4+1] = specValue;
          pPixels[i*4+2] = specValue;
          pPixels[i*4+3] = specValue;
        }
      }
      hr = rt16b_spectrum_sysmem->lpTexture->UnlockRect(0);
      hr = g_D3DApp->m_pd3dDevice->UpdateTexture(rt16b_spectrum_sysmem->lpTexture, rt16b_spectrum->lpTexture);

      SetGlobalFloatParam("g_fft.low", spectrumArray[5]);
      SetGlobalFloatParam("g_fft.mid", spectrumArray[55]);
      SetGlobalFloatParam("g_fft.hi", spectrumArray[100]);

    }

    
  }



  // End the scene.
  pd3dDevice->EndScene();

  return 1;

}

