
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"

#include "deferred.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectLight.h"
#include "EffectDeferredLight.h"

EffectDeferredLight::EffectDeferredLight() {
  m_timelineType = mixer;
  m_deferredMixer = NULL;
}
void EffectDeferredLight::ReloadShaders() {
  Init();
}
EffectDeferredLight::~EffectDeferredLight() {
}
void EffectDeferredLight::Init() {
  if (!m_deferredMixer) {
    m_deferredMixer = new Shader();
  }
  m_deferredMixer->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/deferred_light.h");
}

bool EffectDeferredLight::CheckShadersModifiedOnDisk() {
  if (m_deferredMixer && m_deferredMixer->CheckModifiedOnDisk()) {
    return true;
  }
  return false;
}


void EffectDeferredLight::Advance() {
}

// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectDeferredLight::Render() {

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;

  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_ZENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESS);

  Texture *rt16b_depth = GetDeferred()->GetRT16bDepth();
  Texture *rt16b_normal = GetDeferred()->GetRT16bNormal();
  Texture *rt16b_diffuse = GetDeferred()->GetRT16bDiffuse();

  Texture *rt16b_ambSpec = GetDeferred()->GetRT16bAmbSpec();


  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);

  vector<Light> *lights =  GetGlobalLights();

  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 matWVP;

  D3DXMatrixIdentity(&matProj);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);
  pd3dDevice->SetTransform(D3DTS_VIEW, &matProj);

  D3DXMatrixIdentity(&matWorld);

  pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

  matWVP = matWorld*matProj*matProj;

  int dfmixNum = GetPR()->getN("dfmix");
  for (int mI=0; mI<dfmixNum; mI++) {

    const EffectParam *ep;
    ep = GetPR()->get("dfmix", mI);


    m_deferredMixer->GetEffect()->SetMatrix( "g_mView", GetDeferred()->GetView());
    m_deferredMixer->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

    m_deferredMixer->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
    m_deferredMixer->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);


    m_deferredMixer->GetEffect()->SetTexture("g_tDepth", rt16b_depth->lpTexture);
    g_D3DApp->setTexture(rt16b_depth, 0);
    pd3dDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
    pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    m_deferredMixer->GetEffect()->SetTexture("g_tNormal", rt16b_normal->lpTexture);
    g_D3DApp->setTexture(rt16b_normal, 1);
    pd3dDevice->SetSamplerState(1, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(1, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(1, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
    pd3dDevice->SetSamplerState(1, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    m_deferredMixer->GetEffect()->SetTexture("g_tDiffuse", rt16b_diffuse->lpTexture);
    g_D3DApp->setTexture(rt16b_diffuse, 2);
    pd3dDevice->SetSamplerState(2, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(2, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(2, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
    pd3dDevice->SetSamplerState(2, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    m_deferredMixer->GetEffect()->SetTexture("g_tAmbSpec", rt16b_ambSpec->lpTexture);
    g_D3DApp->setTexture(rt16b_ambSpec, 3);
    pd3dDevice->SetSamplerState(3, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(3, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(3, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
    pd3dDevice->SetSamplerState(3, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);

/*
    Texture *rt16b_buffer0h = g_D3DApp->getTexture(m_deferredMixer->GetLastAOName());
    m_deferredMixer->GetEffect()->SetTexture("g_tAO", rt16b_buffer0h->lpTexture);
    g_D3DApp->setTexture(rt16b_buffer0h, 4);
*/
    pd3dDevice->SetSamplerState(4, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(4, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(4, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
    pd3dDevice->SetSamplerState(4, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);


    pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
    pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
    pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

    g_D3DApp->MakeWorldMatrix(&matWorld, 
                            &D3DXVECTOR3(0.0f-0.0f/g_D3DApp->m_windowWidth, 0.0f+0.0f/g_D3DApp->m_windowHeight, 0.0f), // translate
                            &D3DXVECTOR3(1.0f, 1.0f, 1.0f), // scale
                            &D3DXVECTOR3(0.0f, 0.0f, 0.0f)); // rotate

    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

    matWVP = matWorld*matProj*matProj;

    m_deferredMixer->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

    m_deferredMixer->Enable();
/*
    for (int i=0; i<lights.size(); i++) {

      D3DXVECTOR4 lightViewPos;
      D3DXVECTOR2 lightViewPos2D;


      D3DXVec4Transform(&lightViewPos, &lights[i].m_position, GetDeferred()->GetView());

      lightViewPos2D.x = lightViewPos.x/lightViewPos.z;
      lightViewPos2D.y = lightViewPos.y/lightViewPos.z;


      D3DXVECTOR3 kuhmos = D3DXVECTOR3(0.0f, 0.0f, 0.0f);

      float area = lights[i].m_ss_size*lights[i].m_distance;

      float kaakX = (1.0f+1.0f)*1.33333f;
      float kaakY = (1.0f+1.0f)*1.0f;


      if (lightViewPos.z > 0.0f && 
         lightViewPos2D.x > -kaakX && lightViewPos2D.y > -kaakY &&
         lightViewPos2D.x < kaakX && lightViewPos2D.y < kaakY)  {
        area = area/(lightViewPos.z*1.0f+0.001f);

        float kohtaX = -lightViewPos2D.x/1.3333333f;
        float kohtaY = lightViewPos2D.y;
        float skaalaX = area;
        float skaalaY = area*1.33333f;

        skaalaX = (float)((int)(skaalaX*g_D3DApp->m_windowWidth))/g_D3DApp->m_windowWidth;
        skaalaY = (float)((int)(skaalaY*g_D3DApp->m_windowHeight))/g_D3DApp->m_windowHeight;

        kohtaX = (float)((int)(kohtaX*g_D3DApp->m_windowWidth))/g_D3DApp->m_windowWidth;
        kohtaY = (float)((int)(kohtaY*g_D3DApp->m_windowHeight))/g_D3DApp->m_windowHeight;

      g_D3DApp->MakeWorldMatrix(&matWorld, 
                              &D3DXVECTOR3(0.0f-kohtaX, kohtaY, 0.0f), // translate
                              &D3DXVECTOR3(skaalaX*1.0f, skaalaY*1.0f, 1.0f), // scale
                              &D3DXVECTOR3(0.0f, 0.0f, 0.0f)); // rotate

      } else {
        g_D3DApp->MakeWorldMatrix(&matWorld, 
                              &D3DXVECTOR3(0.0f, 0.0f, 0.0f), // translate
                              &D3DXVECTOR3(2.0f, 2.0f, 1.0f), // scale
                              &D3DXVECTOR3(0.0f, 0.0f, 0.0f)); // rotate
      }

      matWVP = matWorld*matProj*matProj;

      m_deferredMixer->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );
      m_deferredMixer->GetEffect()->SetVector( "g_lightPos", &lights[i].m_position);
      m_deferredMixer->GetEffect()->SetFloat( "g_lightInvDistance", 1.0f/lights[i].m_distance);
      m_deferredMixer->GetEffect()->SetFloat( "g_lightBallSharpness", lights[i].m_lightball_sharpness);
      m_deferredMixer->GetEffect()->SetFloat( "g_lightBallSize", lights[i].m_lightball_size);
      
      D3DXVECTOR4 lightCol = lights[i].m_color*lights[i].m_intensity;
      m_deferredMixer->GetEffect()->SetVector( "g_lightColor", &lightCol);
      m_deferredMixer->Flush();
      g_D3DApp->drawSquare(1.0f);
    }  
    */
  }


  m_deferredMixer->Disable();

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

  g_D3DApp->setTexture(0, 1);
  pd3dDevice->SetSamplerState( 1, D3DSAMP_MINFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 1, D3DSAMP_MIPFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 1, D3DSAMP_MAGFILTER, D3DTEXF_POINT );

  g_D3DApp->setTexture(0, 2);
  pd3dDevice->SetSamplerState( 2, D3DSAMP_MINFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 2, D3DSAMP_MIPFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 2, D3DSAMP_MAGFILTER, D3DTEXF_POINT );

  g_D3DApp->setTexture(0, 3);

  g_D3DApp->setTexture(0, 4);


  // End the scene.
  pd3dDevice->EndScene();

  return 1;
}
