#pragma once

#define CAMERA_NEAR 0.1f
#define CAMERA_FAR 10000.0f

class EffectCamera : public Effect {
public:
  D3DXVECTOR3 m_position;
  D3DXVECTOR3 m_up;
  D3DXVECTOR3 m_lookAt;
  D3DXVECTOR3 m_dir;

  float m_fov;

  bool m_isLookAt;

  float m_roll;
  float m_pitch;
  float m_pitchLA;
  float m_yaw;
  float m_yawLA;


  float m_cameraNear;
  float m_cameraFar; 


  EffectCamera() {
    m_timelineType = camera;
    m_roll = 0.0f;
    m_pitch = 0.0f;
    m_yaw = 0.0f;
    m_pitchLA = 0.0f;
    m_yawLA = 0.0f;

    m_cameraNear = CAMERA_NEAR;
    m_cameraFar = CAMERA_FAR;
  }
  ~EffectCamera() { }

  void Init();
  void Advance();
  int Render();

  void ReloadShaders() {}
  bool CheckShadersModifiedOnDisk() {return false;}
};

void ResetGlobalCamera();

void AddToGlobalCamera(EffectCamera *ec, float weight);
void MultiplyGlobalCameraPos(float multiplier);
void AddToGlobalCameraPos(D3DXVECTOR3 *pos, D3DXVECTOR3 *lookAt);
D3DXMATRIXA16 *GetGlobalCameraView();
float GetGlobalCameraFOV();
float GetGlobalCameraNear();
float GetGlobalCameraFar();

D3DXVECTOR3 GetGlobalCameraPos();
D3DXVECTOR3 GetGlobalCameraLookAt();
void SetGlobalCameraPos(D3DXVECTOR3 cameraPos);

