
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;


struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};


texture g_tDepth;
sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tNormal;
sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tDiffuse;
sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = LINEAR; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tDiffuseOrig;
sampler smDiffuseOrig =
sampler_state {
  Texture = <g_tDiffuseOrig>;
  MipFilter = LINEAR; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = BORDER;
  AddressV = BORDER;
};


texture g_tAmbSpec;
sampler smAmbSpec =
sampler_state {
  Texture = <g_tAmbSpec>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tNoise;
sampler smNoise =
sampler_state {
  Texture = <g_tNoise>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};


const float zFar = 10000.0;
const float zNear = 0.10;


float getPointDist(float z) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return clipB/(z-clipA);  
}
float getPointZ(float d) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return (clipB + d*clipA)/d;
}

float3 getNormal3(float2 n) {
  float3 n3;
  n3.xy = n*2.0-1.0;
  n3.z = sqrt(1.0-n3.x*n3.x-n3.y*n3.y);
  return n3;
}

PS_OUT ps_simple( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;

  float4 result = 0;
  float2 tc = In.vTexcoord;
  float2 tcOfs = 2.0*float2(1.0/g_windowWidth, 1.0/g_windowHeight);

  result = tex2D(smDiffuse, tc);
  
  float4 d = tex2D(smDepth, tc);
  float dist = getPointDist(d.r);
  float2 tc2 = tc*2.0-1.0;
  
  float3 ray = float3(tc2, dist);
  
  float3 normal = getNormal3(tex2D(smNormal, tc));
  normal.y = -normal.y;
  
  float reflectAmount = tex2D(smAmbSpec, tc).w*0.5;
  result = (1.0-reflectAmount)*result+reflectAmount*tex2D(smDiffuse, tc+normal.xy*0.15+float2(tcOfs.x, 0.0));

   result.a = 1.0;
  
  o.rt0 = result;
  return o;
}


PS_OUT ps_gaps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;

  float4 result = 0;
  float2 tc = In.vTexcoord;
  float2 tcOfs = float2(0.50/g_windowWidth, 0.50/g_windowHeight);

  result = tex2D(smDiffuse, tc);
  
  float4 d = tex2D(smDepth, tc);
  float dist = getPointDist(d.r);
  float2 tc2 = tc*2.0-1.0;
  float3 ray = float3(tc2, 1.0);
  float3 rayO = ray*dist;
  ray = normalize(ray);
  
  float3 normal = getNormal3(tex2D(smNormal, tc));
  normal.y = -normal.y;
  // normal.x = -normal.x;
  normal = normalize(normal);
  
  float3 rayR = reflect(ray,normal);
 // float3 rayR = reflect(normal,ray);
  float raySteep = rayR.z;
  float reflectAmount = tex2D(smAmbSpec, tc).w*0.5;
  float2 tcHit = tc;
  int onceIn = 0;
  int inTimes = 0;
  float dir = 1.0;
  float halver = 1.0;
  rayO+=rayR*(0.2);// *dir*halver;
  float maxDist = -10000000.0;
  float dist2;
 // float n = tex2D(smNoise, tc);
  for (int i=0; i<32; i++) {
	tc2 = (rayO.xy/rayO.z+1.0)*0.5; //+n*0.0;
	float4 d2 = tex2D(smDepth, tc2);
	// float4 n2 = tex2D(smNormal, tc2)*2.0-1.0;
	dist2 = getPointDist(d2.r);
	if (abs(dist2-rayO.z)<0.850 && rayO.z>dist2+0.0) { // && abs(n2.z)>0.50) {
	  if (inTimes == 0) {
		tcHit = tc2;
	  }
	  onceIn=1;
	  inTimes++;
	} else {
	  inTimes=0;
	}
	if (inTimes==0) {
	  rayO+=rayR*((0.35));//+(float)i/32.0*0.0)*raySteep);//-(float)i/32*0.4);
	}
	if (inTimes==1) {
	  rayO+=rayR*0.05;
	}
  }
  float a = abs(dist2-rayO.z);
  if (a>1.0) {
    onceIn = 0;
  }  
  if (tcHit.x < 0.0 || tcHit.x > 1.0 || tcHit.y < 0.0 || tcHit.y > 1.0 || onceIn==0 || inTimes<2) {
    tcHit = tc;
  }
  result = (1.0-reflectAmount)*result+2.0*reflectAmount*tex2D(smDiffuse, tcHit+tcOfs);
  result.a = 1.0;
  o.rt0 = result;
  return o;
}

float g_rgbDistort;

PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;

  float4 result = 0;
  float2 tc = In.vTexcoord;
  float2 tcOfs = float2(0.50/g_windowWidth, 0.50/g_windowHeight);

  result = tex2D(smDiffuse, tc);
  
  float4 d = tex2D(smDepth, tc);
  float dist = getPointDist(d.r);
  float2 tc2 = tc*2.0-1.0;
  float3 ray = float3(tc2, 1.0);
  float3 rayO = ray*dist;
  ray = normalize(ray);
  
  float3 normal = getNormal3(tex2D(smNormal, tc));
  normal.y = -normal.y;
  // normal.x = -normal.x;
  normal = normalize(normal);
  
  float3 rayR = reflect(ray,normal);
  
  float distAmount = (dot(ray, normal));
  
 // float3 rayR = reflect(normal,ray);
  float raySteep = rayR.z;
  float4 specAmount = tex2D(smAmbSpec, tc);
  float reflectAmount = specAmount.w*saturate(specAmount.y)*1.0;
  float2 tcHit = tc;
  int onceIn = 0;
  int inTimes = 0;
  float dir = 1.0;
  float halver = 1.0;
  rayO+=rayR*(0.1);// *dir*halver;
  float maxDist = -10000000.0;
  float dist2;
 // float n = tex2D(smNoise, tc);
  float diff=0.0;
  float diffPrev=0.0;
  int inNow=0;
  float inDiff = -200000.0;
  float fwdMul = 0.05;
  for (int i=0; i<32; i++) {
	tc2 = (rayO.xy/rayO.z+1.0)*0.5; //+n*0.0;
	float4 d2 = tex2D(smDepth, tc2);
	// float4 n2 = tex2D(smNormal, tc2)*2.0-1.0;
	dist2 = getPointDist(d2.r);
	diff = dist2-rayO.z;
	/*
	if (rayR.z > 0.0) {
	  inNow=0;
	  if (diff < 0.0 && i!=0 && abs(diff)<0.5) {
	    // we are in
		//if (onceIn==0) {
		  tcHit = tc2;
		//}
		onceIn = 1;
		inNow=1;
	  }
	} else {
	  inNow=0;
	  if (diff < 0.0 && i!=0 && abs(diff)<0.5) {
	  //if (diff > 0.0 && diffPrev<0.0 && i!=0 && abs(diff)<0.5) {
	    // we are in
		//if (onceIn==0) {
		  tcHit = tc2;
		//}
		onceIn = 1;
		inNow=1;
	  }	
	}
	diffPrev = diff;
	*/
	  inNow=0;
	  float absDiff = abs(diff);
	  if (diff < 0.0 && i!=0 && absDiff<0.70) {
		// we are in
		//if (onceIn==0) {
		  tcHit = tc2;
		//}
		onceIn = 1;
		inNow=1;
		if (absDiff < 0.01) {
		  break;
		}
	  }
	
	if (onceIn==0) {
	  fwdMul = ((0.25)*(1.0+0.0*(float)i/32.0));
	  rayO+=rayR*fwdMul;//+(float)i/32.0*0.0)*raySteep);//-(float)i/32*0.4);
	} else {
      //break;	
	  halver*=0.15;
	  if (inNow>0) {
	    rayO-=rayR*fwdMul*halver;
	  } else {
	    rayO+=rayR*fwdMul*halver;
	  }
	  
	}
  }
  float a = abs(dist2-rayO.z);
  if (a>0.30) {
    onceIn = 0;
  }  
  if (tcHit.x < 0.0 || tcHit.x > 1.0 || tcHit.y < 0.0 || tcHit.y > 1.0 || onceIn==0) { // || inTimes<1) {
    tcHit = tc;
  }
  
  float diffuseMulWithReflection = specAmount.x;
  
  float4 hitColorR = tex2D(smDiffuse, tcHit+tcOfs+float2(g_rgbDistort*distAmount, 0.0));
  float4 hitColorG = tex2D(smDiffuse, tcHit+tcOfs-float2(g_rgbDistort*distAmount, 0.0));
  float4 hitColorB = tex2D(smDiffuse, tcHit+tcOfs+0.0*float2(g_rgbDistort*normal.x, 0.0));
  
  float4 hitColor = float4(hitColorR.r,hitColorG.g,hitColorB.b, hitColorG.a);
  
  result = (1.0-reflectAmount)*result+1.0*reflectAmount*hitColor*(saturate(1.0-diffuseMulWithReflection)+(tex2D(smDiffuseOrig,tc)*diffuseMulWithReflection));
  result.a = 1.0;
  o.rt0 = result;
  return o;
}




technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}

