

float4x4 g_mWorldViewProjection;    
float4x4 g_mView;    

float zFar = 10000.0;
float zNear = 1.0;

float g_windowWidth;
float g_windowHeight;

float g_time;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};


struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
    float2  vTexcoordActual : TEXCOORD2;
};

VS_OUTPUT vs_deferred_mixer_ao( const VS_INPUT v ) {
  VS_OUTPUT o;
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  o.vTexcoord = (1.0-float2(-o.vPosition.x, o.vPosition.y))*0.5+float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  o.vTexcoordActual = v.vTexcoord;
  return o;
}


float g_ao_darkness = 2.0;
float g_ao_whiteness = 1.0;
float g_ao_area = 10.0;

texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;
texture g_tNoise;
texture g_tAO;

sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = LINEAR; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smNoise =
sampler_state {
  Texture = <g_tNoise>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smAO =
sampler_state {
  Texture = <g_tAO>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

float4 g_lightPos;
float4 g_lightColor;
float g_lightInvDistance;

float g_specularExponent = 128.0f;
float g_lightBallSharpness;
float g_lightBallSize;



float g_blurAmount;

float4 getPointV(float4 vPosSS, float depthV) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  float pointDist = clipB/(depthV-clipA);
  float4 pointV = float4(vPosSS.x*4.0/3.0, vPosSS.y, 1.0, 0.0)*pointDist;  
  return pointV;
}

float rand(float2 co){
  return 0.5+(frac(sin(dot(co.xy ,float2(12.9898,78.233))) * 43758.5453))*0.5;
}

float3 getNormal3(float2 n) {
  float3 n3;
  n3.xy = n*2.0-1.0;
  n3.z = sqrt(1.0-n3.x*n3.x-n3.y*n3.y);
  return n3;
}
//getNormal3(tex2D(smNormal, rayTexC).xy)*2.0-1.0

inline float doAO(float4 pointV, float3 normalV, float2 dir) {
  float4 ray = pointV+float4(dir, 0.0, 0.0);
  float2 rayTexC = ((float2(ray.x*3.0/4.0, -ray.y)/(ray.z))+1.0)*0.5+0.0*float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  if (rayTexC.x > 1.0) return 0.0;
  if (rayTexC.y > 1.0) return 0.0;
  if (rayTexC.x < 0.0) return 0.0;
  if (rayTexC.y < 0.0) return 0.0;
  float2 rayTexCO = rayTexC;
  rayTexC.xy += float2(0.5/g_windowWidth, -0.5/g_windowHeight);
  float4 depthRay = tex2D(smDepth, rayTexC);
  float4 rayV = getPointV(float4(rayTexCO.xy*2.0-1.0, 1.0, 0.0), depthRay.r);
  rayV.y = -rayV.y;
  
  
  float4 diff = rayV-pointV;
  float kukko = length(diff);

  float ambienssi = 0.0;

  //if (1) { 
 //  if (dot(normalV, diff)>0.0) {
	  float dots = dot(normalV, getNormal3(tex2D(smNormal, rayTexC).xy));
		
	  dots = saturate((0.9999-dots)*1.0); // *saturate(dot(normalV, diff));
	  if (depthRay.r > 0.99999999 || depthRay.r < 0.01)
	    dots=0.0;
		
	  // ambienssi = (1.0/(kukko+1.0))*dots;
	  ambienssi = smoothstep(0.0, 1.0, pointV.z-rayV.z)*dots; // (1.0/(kukko+1.0))*dots;
  //}

  return ambienssi;
}

 const float2 vec[4] = {
   float2(1.0,0.0),
   float2(-1.0,0.0),
   float2(0.0,1.0),
   float2(0.0,-1.0)
 };


PS_OUT ps_deferred_mixer_ao( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = (float4)0;

  float2 tc = In.vTexcoord; // + float2(0.5/g_windowWidth, 0.5/g_windowHeight);

  float4 depthV = tex2D(smDepth, tc);

  if (depthV.r > 0.99999999) {
    discard;
    o.rt0 = result;
    return o;
  }


  float ambienssi = 0.0;
  
  float4 pointV = getPointV(In.vPosSS, depthV.r); 

  float4 noiseVT = tex2D(smNoise, (tc)*2.0);
  float3 noiseV = (noiseVT.xyz);

  float3 ray;
  
  float3 normalV = getNormal3(tex2D(smNormal, tc).xy);//(float3(tex2D(smNormal, tc).xyz)*2.0)-1.0;
  
  float radD = 0.02*g_ao_area/(pointV.z*0.02+0.5)*(noiseVT.a*1.0+2.50); 
  

  int iter = 4;
  
  for (int i=0; i<iter; i++) {

   // float2 rayRefl = reflect(vec[i],noiseV.xy);
	//  ray = ray*sign(dot(ray,normalV))*radD*1.0+pointV+normalV*0.0;
    float2 c1 = reflect(vec[i],noiseV.xy)*radD;
    float2 c2 = float2(c1.x*0.707-c1.y*0.707, c1.x*0.707+c1.y*0.707);

    ambienssi += doAO(pointV, normalV, c1*0.25);
    ambienssi += doAO(pointV, normalV, c2*0.5);
    ambienssi += doAO(pointV, normalV, c1*0.75);
    ambienssi += doAO(pointV, normalV, c2);
  }
  
  ambienssi = ambienssi/(iter*4.0);
    
  ambienssi = clamp(ambienssi, 0.0, 1000.0)*g_ao_darkness; 
  result = ambienssi;

 // result.x = rayMo.z*0.004;
  result.a = 1.0;
  
  o.rt0 = result;
  return o;
}



technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_mixer_ao( );
        PixelShader  = compile ps_3_0 ps_deferred_mixer_ao( );
    }
}

