float g_time;
float4x4 g_mWorldViewProjection;    
float g_windowWidth, g_windowHeight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};
struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};

VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  return o;
}

struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

texture g_tWaveHeight;
sampler smWaveHeight =
sampler_state {
  Texture = <g_tWaveHeight>;
  MipFilter = LINEAR;
  MinFilter = LINEAR; 
  MagFilter = LINEAR; 
  AddressU = CLAMP;
  AddressV = CLAMP;
};

texture g_tWaveHeight2;
sampler smWaveHeight2 =
sampler_state {
  Texture = <g_tWaveHeight2>;
  MipFilter = LINEAR;
  MinFilter = LINEAR; 
  MagFilter = LINEAR; 
  AddressU = CLAMP;
  AddressV = CLAMP;
};

PS_OUT ps( VS_OUTPUT In ) {
  PS_OUT o = (PS_OUT)0;
  float4 result = (float4)0.0;
  float2 tcOfs = float2(1.50/g_windowWidth, 1.0/g_windowHeight);
  float4 myHeight = tex2D(smWaveHeight2, In.vTexcoord)-0.5;
  
  float4 hp;
  
  hp = (tex2D(smWaveHeight, In.vTexcoord+float2(tcOfs.x, 0.0))+
       tex2D(smWaveHeight, In.vTexcoord+float2(-tcOfs.x, 0.0))+
	   tex2D(smWaveHeight, In.vTexcoord+float2(0.0, tcOfs.y))+
	   tex2D(smWaveHeight, In.vTexcoord+float2(0.0, -tcOfs.y)))/4.0-0.50;
	  
  hp = (hp*2.0 - myHeight)*0.9+0.5;
  /*
  if (abs(hp.r-0.5)<0.1 && abs(myHeight.r)<0.1) {
    hp = 0.5;
  }
  */
  
  /*
  for (int i=0;i<100; i++) {
	  float2 wavePos = float2(sin(g_time*0.1+i*10.4), cos(g_time*0.1*1.2+i*0.4));
	  float2 pix = In.vTexcoord*2.0-1.0-wavePos;
	  //pix.y *= 0.;
	  float waveSource = saturate(1.0-dot(pix, pix)*10000.0);
	  if (waveSource > 0.01) {
		hp = waveSource*1.0+0.5;
	  }
  }
  */
  
  
  result = hp;
  result.a = 1.0;
  o.rt0 = result;
  return o;
}

technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs();
        PixelShader  = compile ps_3_0 ps();
    }
}