
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;


float2 i2c(float index, float width) {
  float2 tc;

  float k = index/width;
  tc.x = frac(k);
  tc.y = (k-tc.x)/width;
  return tc;
}

float c2i(float2 tc, float2 dim) {
  return tc.x*dim.x + (int)(tc.y*dim.y)*dim.x;
}

float nois(float3 p) {
	return frac(sin(dot(p ,float3(12.9898,78.233,127.789))) * 43758.5453)*2.0-1.0;
}
float pnois(float3 p) {
  p.z += frac((floor(p.x)+floor(p.y))*1.0)*0.5;
  float2 eps = float2(1.0, 0.0);
  float3 pfp = p-frac(p);
  float3 fr = smoothstep(0.0, 1.0, frac(p));
  return ((fr.x*nois(pfp+eps.xyy)+(1.0-fr.x)*nois(pfp))*(1.0-fr.y)+(fr.x*nois(pfp+eps.xxy)+(1.0-fr.x)*nois(pfp+eps.yxy))*fr.y)*(1.0-fr.z)+
	 ((fr.x*nois(pfp+eps.xyx)+(1.0-fr.x)*nois(pfp+eps.yyx))*(1.0-fr.y)+(fr.x*nois(pfp+eps.xxx)+(1.0-fr.x)*nois(pfp+eps.yxx))*fr.y)*(fr.z);
}
/*
float pnois2(float3 p) {
  return (pnois(p)+pnois(p+float3(0.0,0.0,0.5)))*0.5;
}
*/
float4 pn4(float3 p) {
  float3 p3 = float3(p.x, p.y, p.z);
  return float4(pnois(p3), pnois(p3+float4(0.0, 1.2, 0.2, 0.0)), pnois(p3+float4(3.2, 4.32, 0.0, 0.0)), 0.0);
}

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};

VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}

struct PS_OUT {
  float4 rt0 : COLOR0; // new position
  float4 rt1 : COLOR1; // new velocity
  float4 rt2 : COLOR2; // 
};

float g_time;
float g_timeStep;

texture g_tNoise;
sampler smNoise =
sampler_state {
  Texture = <g_tNoise>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = WRAP;
  AddressV = WRAP;
};

texture g_tPosPrev;
sampler smPosPrev =
sampler_state {
  Texture = <g_tPosPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVelPrev;
sampler smVelPrev =
sampler_state {
  Texture = <g_tVelPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVarPrev;
sampler smVarPrev =
sampler_state {
  Texture = <g_tVarPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

float g_emitterRad;
float g_emitterDirSpeed;
float g_emitterRotate;

float g_emitterVar;

float g_emitterMove;
float g_emitterMoveSpeed;

float g_spread;

float g_spreadScale;
float g_spreadEvolve;

float g_maxAge;

float4 g_outputLinesAndOffset;

float g_collisionAtt;

float4 g_grav;

float4 g_emitterPos;

float4 g_hitPoint;
float g_hitRad;
float gHitPower;

PS_OUT ps_pixsim1( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float2 tcOfs = float2((+0.5)/g_windowWidth.x, (+0.5)/g_windowHeight);
  float4 pos = tex2D(smPosPrev, In.vTexcoord+tcOfs);
  float4 vel = tex2D(smVelPrev, In.vTexcoord+tcOfs);
  float4 var = tex2D(smVarPrev, In.vTexcoord+tcOfs);
   
  float pi = c2i(In.vTexcoord, float2(g_windowWidth, g_windowHeight));

  if ((pi/g_windowWidth > (g_outputLinesAndOffset.x+g_outputLinesAndOffset.y)) ||
      (pi/g_windowWidth < g_outputLinesAndOffset.y)) {
    discard;
  }
  
  float4 posPrev = tex2D(smPosPrev, In.vTexcoord+tcOfs);
  pos += (pos-posPrev)*0.05;
  
  float3 korba = pos.xyz-g_hitPoint.xyz;
  float korsu = dot(korba,korba);
  if (korsu < g_hitRad) {
    float dotsa = dot(korba, vel.xyz);
	dotsa = clamp(dotsa, 0.0, 1.0);
    vel.xyz *= -dotsa*korba.xyz*gHitPower;
  }

  pos.w -= g_timeStep*0.2;
  if (pos.w < 0.0) { // init 
    float tk = g_time*g_emitterMoveSpeed;
    float tkp = tk-g_timeStep;
    pos = g_emitterPos+float4(sin(tk), cos(tk*2.1), sin(cos(tk*0.2)*3.4), 0.0)*g_emitterMove;
	/*
    float ak=0.0;
    if (frac(pi*0.002327)<0.7) {
      // emit 70% of particles from other ones
      //float k;
      //modf(pi/200.0,k);
      float2 tc = i2c(pi-1, g_windowWidth);
      pos = tex2D(smPosPrev, tc);
      ak = saturate(pos.w-9.0);
    }
	*/
    
    float4 posPrev = float4(sin(tkp), cos(tkp*2.1), sin(cos(tkp*0.2)*3.4), 0.0)*g_emitterMove;
    float4 posVel = pos-posPrev;
    pos.w = 0.0+frac(pn4(float3(pi,g_time,g_time*0.321)))*g_maxAge;
    float4 noisePos = pn4(pos.xyz*g_emitterVar+(g_time+pi)*float3(1.234, 2.32325, 3.4123)*0.001*g_emitterMoveSpeed)*2.0-1.0;
    pos.xyz += noisePos.xyz*0.350*g_emitterRad;
    pos.xyz += posVel*3.250*g_emitterDirSpeed;
  } 
  pos.xyz += pn4(pos.xyz*g_spread+float3(1.2, 0.2, 2.34)*g_time*0.2*g_spreadEvolve).xyz*g_timeStep*g_spreadScale+g_grav.xyz*g_timeStep;
  

  o.rt0 = pos;
  o.rt1 = vel;
  o.rt2 = var;
  return o;
} 


technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps_pixsim1( );
    }
}

