
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float g_time;


struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = v.vPosition; //mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  o.vTexcoord = (v.vTexcoord); 
 
  return o;
}

struct PS_OUT {
  float4 rt0 : COLOR0; 
};

texture g_tDiffuse;
sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVignette;
sampler smVignette =
sampler_state {
  Texture = <g_tVignette>;
  MipFilter = LINEAR;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = MIRROR;
  AddressV = MIRROR;
};



float g_amount = 1.0;
float4 g_color;

float4 g_texScale;
float4 g_texOfs;



PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float2 tcOfs = float2(0.50/g_windowWidth, 0.50/g_windowHeight);

  float4 ovl = tex2D(smVignette, (In.vTexcoord-float2(0.5,0.5))*g_texScale+float2(0.5,0.5)+tcOfs+g_texOfs);
  float4 r = tex2D(smDiffuse, In.vTexcoord+tcOfs)*(float4(ovl.rgb, 1.0)*g_amount+1.0*(1.0-g_amount));
  /*
 // float4 v = tex2D(smVignette, In.vTexcoord*1.0+tcOfs);
  float2 tcVign = (In.vTexcoord);
  tcVign.x = tcVign.x*(g_windowWidth-1)/g_windowWidth;
  tcVign.y = tcVign.y*(g_windowHeight-1)/g_windowHeight;
  float3 res = float3(0.0, 0.0, 0.0);
 // float zoom_x = g_zoom_x;
//  float zoom_y = g_zoom_y;
//  float speed_x = g_speed_x;
 // float speed_y = g_speed_y;
//  r=r*(1.0-pow(v,4.0)*4);
//  r=r*v;

  for (int i=0; i<1; i++) {
  	//  tcVign -= float2(0.5, 0.5);
	//  tcVign.x *= zoom_x;
	//  tcVign.y *= zoom_y;
	//  tcVign += float2(0.5, 0.5);
	 // tcVign.x += speed_x*g_time;
	//  tcVign.y += speed_y*g_time;
	
	  res += g_amount*tex2D(smVignette, tcVign+tcOfs).xyz;
	//  zoom_x *= 0.250;
	//  zoom_y *= 0.250;
	//  speed_x *= -1.0;
	//  speed_y *= -1.0;
  }
 // r.xyz += res/(float)2;
  o.rt0 = r;
  o.rt0.xyz += res;
  */
  o.rt0 = r;
  return o;
}
/*
PS_OUT ps( VS_OUTPUT In ) {
  PS_OUT o = (PS_OUT)0;
  
  float2 tcOfs = float2(0.50/g_windowWidth, 0.50/g_windowHeight);
  float4 r = tex2D(smDiffuse, In.vTexcoord*1.0+tcOfs);
  float4 v = tex2D(smVignette, In.vTexcoord*1.0+tcOfs);
//  r=r*(1.0-pow(v,4.0)*4);
  r=r*v; // multiple
  r=r-v; // subtract
  r=r+v; // add
  
  o.rt0 = r;
  return o;
}
*/
technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs();
        PixelShader  = compile ps_3_0 ps();
    }
}

