﻿var Text = function(duration, startTime, endTime){
  //kantaluokan rakentajan kutsu
  PartBase.call(this, duration, startTime, endTime);
}

Text.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Text.prototype.initScene = function(){

  //MAIN SCENE
  this.scene = new THREE.Scene();

  var ambient = new THREE.AmbientLight(0xFFFFFF);
  this.scene.add(ambient);

  var pointLight = new THREE.PointLight(0xAACCDD);
  pointLight.position.y = 200;
  pointLight.position.z = 200;
  pointLight.position.x = -100;
  this.scene.add(pointLight);

  this.camera = new THREE.PerspectiveCamera();
  this.camera.position.z = 600;
  this.camera.position.y = 300;
  this.camera.rotation.x = -0.5;
  this.scene.add(this.camera);

  var roofMaterial = new THREE.MeshPhongMaterial({
    color : 0x5959AB,//0x5D478B,
    ambient : 0x304132,
    emissive : 0x302B54,//0x1C1C1C,
    specular : 0x302B54,//0x483D8B,
    side : THREE.BackSide
  });

  this.roof = new THREE.Mesh(new THREE.SphereGeometry(512, 16, 16), roofMaterial);
  this.scene.add(this.roof);
  var fcolor = "#584E56";
  var fcolor_red = "#8E236B";

  this.texts = [];
	this.createText('Hello Alternative Party 2013!', 500, -50, 70, "#584E56");

	this.createText('This is', 980, -60, 0, "#8B0A50");

	this.createText('a beginners demo by', 1050, -90, 0, "#551033");

	this.createText('Paraguay', 1080, -120, 0, "#584E56");

	this.createText('and we bring you', 1220, -190, 0, "#551033");

	this.createText('Lots of balls and healing visuals', 1450, -60, 40, "#584E56");
}

//rendering function
Text.prototype.render = function(elapsedTime){
  TDEMO.renderer.render(this.scene, this.camera);
}

Text.prototype.prepare = function(elapsedTime){
  this.startTime = elapsedTime;
}

//Operations that takes place before rendering in every cycle
Text.prototype.animate = function(elapsedTime){
	for(var i = 0; i<this.texts.length; i++) {
		this.texts[i].position.x -= 1;
	}
}

Text.prototype.createText = function(text, xpos, ypos, zpos, color) {
	var canvas = document.createElement('canvas');
	canvas.width = 512;
	canvas.height = 512;

	var context = canvas.getContext('2d');

	context.font = "20px Arial";
	context.fillStyle = color;
    context.fillText(text, 5, 50);

	var texture = new THREE.Texture(canvas)
	texture.needsUpdate = true;

    var textureMaterial = new THREE.MeshBasicMaterial( {map: texture, side : THREE.DoubleSide} );
    textureMaterial.transparent = true;



    this.mesh = new THREE.Mesh(
        new THREE.PlaneGeometry(canvas.width, canvas.height ),
        textureMaterial
    );


	this.mesh.position.set(xpos,ypos,zpos);
	this.texts.push(this.mesh);
	this.scene.add( this.mesh );
}
