import processing.video.*;
import ddf.minim.*;
import ddf.minim.analysis.*;

/* Video */
Movie video;
float maxdist = 0;
int timeToFlash = 0;
Minim minim;
AudioPlayer player;
BeatDetect beat;

float[] creditAlpha = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
String[] creditText = {"    We love you... ",
                       "     Tristar RSI ",
                       "     Sector One",
                       "        Dune ",
                       "      Triple  A ",
                       "       Mankind ",
                       "     Purelamers ",
                       "        X-Men ", 
                       "     Popsy Team ", 
                       "     Woodtower ",     
                       "     Supremacy ",   
                       "        Titan ",
                       "       Oxygene ",                       
 };

float endlogoAlpha = 0;

PImage logoimg, logPtsimg;

int[][] scrolltextSize = {{ 78, 78, 78, 110, 78}, { 78, 78, 78, 78, 78}, { 78, 78, 78, 78, 78}};
String[][] scrolltext = {
  {
    "                     " ,
    "                     " ,      
    "  Thanks for watching " ,
    "    With You         " ,
    "                     "  
  },
  {
    "                     ",
    "    Fastly designed " ,
    "   During the party " ,
    "      by MJJ PROD   " ,  
    "                   " 
  },
  {
    "    Music : Smith  " ,
    "    Code : Mystic  " ,  
    "           Shazz   " , 
    "    Gfx  : Eric Hines",
    "           Wilfried "  
  }
};
float[] endTextFade = {0, 0, 0, 0};
int endTextIdx = 0;

String[] introScrolltext = {
  "        Enjoy the music   " ,
};
float introTextFade = 0;
float introTextPos = -150;

int scrolltextIndex = 0;
PFont fonts; // Global font variable

void setup() {
  size(1280, 720);
  if (frame != null) frame.setResizable(true);
  
  video = new Movie(this, "data.bin");
  video.loop();
  frameRate(60);
  
  // music
  minim = new Minim(this);
  player = minim.loadFile("zik.bin");
  player.play();
  beat = new BeatDetect();
  beat.detectMode(BeatDetect.FREQ_ENERGY);
  beat.setSensitivity(400);
  
  //logo
  logoimg = loadImage("mjj.jpg");
  logPtsimg = loadImage("credits.jpg");
  
  // fonts
  fonts = createFont( "depthcore.ttf",50, true);
  
}
float currentTime = 0;
void draw() {

  noCursor();
  
  beat.detect(player.mix);
  video.read();  
  currentTime += 0.035; // = video.time(); 
  
  if(currentTime <= 9)
  {
    effectLogo(currentTime); 
  }
  else if(currentTime > 9 && currentTime <= 94)
  {  
    if(beat.isKick()) effectInverse(currentTime - 9);
    else effectIntro(currentTime - 9); 
    
    if(currentTime > 9+10 && currentTime < 9+10+2) credit(creditText[0], 0);
    else if(currentTime > 9+20 && currentTime < 9+20+2) credit(creditText[1], 1);
    else if(currentTime > 9+25 && currentTime < 9+25+2) credit(creditText[2], 2);
    else if(currentTime > 9+30 && currentTime < 9+30+2) credit(creditText[3], 3);
    else if(currentTime > 9+35 && currentTime < 9+35+2) credit(creditText[4], 4);
    else if(currentTime > 9+40 && currentTime < 9+40+2) credit(creditText[5], 5);
    else if(currentTime > 9+45 && currentTime < 9+45+2) credit(creditText[6], 6);
    else if(currentTime > 9+50 && currentTime < 9+50+2) credit(creditText[7], 7);
    else if(currentTime > 9+55 && currentTime < 9+55+2) credit(creditText[8], 8);   
    else if(currentTime > 9+60 && currentTime < 9+60+2) credit(creditText[9], 9);   
    else if(currentTime > 9+65 && currentTime < 9+65+2) credit(creditText[10], 10);  
    else if(currentTime > 9+70 && currentTime < 9+70+2) credit(creditText[11], 11);  
    else if(currentTime > 9+75 && currentTime < 9+75+2) credit(creditText[12], 12); 
  }    
  else if(currentTime > 94 && currentTime <= 94+10)
  {  
      endTextIdx = 0;
      effectEndLogo(currentTime); 
  } 
  else if(currentTime > 94+10 && currentTime <= 94+10+10)
  {  
     endTextIdx = 1;
     effectEndLogo(currentTime);
  }  
  else if(currentTime > 94+10+10 && currentTime <= 94+10+10+160)
  {  
     endTextIdx = 2;
     effectEndLogo(currentTime);
  }    
  
}

void stop()
{
  player.close();
  minim.stop();
  video.stop();
  super.stop();
}


void effectLogo(float time){
     
  tint(200, time*2);
  image(logoimg, 0, 0, width, height);  
  
  scrolltextIndex = 0;
  if(introTextFade < 255) introTextFade += 0.5;
  if(introTextPos < 100) introTextPos++;
  
  textFont(fonts,60);
  fill(introTextFade/3,introTextFade/3,introTextFade/3);
  text(introScrolltext[scrolltextIndex],5,height-introTextPos); 
  fill(introTextFade,introTextFade,introTextFade);
  text(introScrolltext[scrolltextIndex++],5-2,height-2-introTextPos);   
  
}

void credit(String atext, int idx)
{
  if(creditAlpha[idx] < 500) creditAlpha[idx] += 0.1;
    
  textFont(fonts,90);  
  fill(100,100,100, creditAlpha[idx]);
  text(atext,5,20+height/2);
    
  fill(255,255,255, creditAlpha[idx]);
  text(atext,5-2,20+(height/2)-2);     
}

void effectEndLogo(float time){
  
 
  if(endlogoAlpha < 100) endlogoAlpha += 0.1;
  tint(200, endlogoAlpha);
  image(logPtsimg, 0, 0);
   
  if(endTextFade[endTextIdx] < 255.0 && endTextFade[endTextIdx] >= 0) endTextFade[endTextIdx] += 1;
    
  for (int idx = 0; idx < 5; idx++) 
  {
    textFont(fonts,scrolltextSize[endTextIdx][idx]);
    fill(100,100,100, endTextFade[endTextIdx]);
    text(scrolltext[endTextIdx][idx],5,100 + (idx*120));
    
    fill(255,255,255, endTextFade[endTextIdx]);
    text(scrolltext[endTextIdx][idx],5-2,100-2 + (idx*120));   
  }    
}

void effectIntro(float time){
    
  video.loadPixels();
  
  if(maxdist < 380) maxdist += 5;
  
  for (int x = 0; x < video.width; x++) {
    for (int y = 0; y < video.height; y++) {
      
      // Calculate the 1D location from a 2D grid
      int loc = x + y*video.width;
      
      // Get the R,G,B values from image
      float ori_b, ori_r, ori_g, r,g,b;
      
      ori_r = red (video.pixels[loc]);
      ori_g = green (video.pixels[loc]);
      ori_b = blue (video.pixels[loc]);
      
      r = (ori_r * .393) + (ori_g *.769) + (ori_b * .189);
      g = (ori_r * .349) + (ori_g *.686) + (ori_b * .168);
      b = (ori_r * .272) + (ori_g *.534) + (ori_b * .131);
                 
      float d = dist(x,y,video.width/2,video.height/2);
      float adjustbrightness = (maxdist-d)/maxdist;
      r *= adjustbrightness;
      g *= adjustbrightness;
      b *= adjustbrightness;
      
      // Constrain RGB to make sure they are within 0-255 color range
      r = constrain(r,0,255);
      g = constrain(g,0,255);
      b = constrain(b,0,255);
      
      // Make a new color and set pixel in the window
      color c = color(r,g,b);
      video.pixels[loc] = c;
    }
    
  }
  video.updatePixels();   
  
  
  tint(180, 8);
  image(video, 0, 0, width, height);  
}

void effectInverse(float time){
    
  video.loadPixels();
  
  maxdist = 400;
  
  for (int x = 0; x < video.width; x++) {
    for (int y = 0; y < video.height; y++) {
      
      // Calculate the 1D location from a 2D grid
      int loc = x + y*video.width;
      
      // Get the R,G,B values from image
      float ori_b, ori_r, ori_g, r,g,b;
      
      ori_r = red (video.pixels[loc]);
      ori_g = green (video.pixels[loc]);
      ori_b = blue (video.pixels[loc]);
      
      r = (255.0 - ori_r);
      g = (255.0 - ori_g);
      b = (255.0 - ori_b);              
      
      color c = color(r,g,b);
      video.pixels[loc] = c;
    }
    
  }
  video.updatePixels();   
  
  tint(255, 5);
  image(video, 0, 0, width, height);  

}

boolean sketchFullScreen() {
  return true;
}


 
