/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.manual;

import com.jogamp.common.nio.Buffers;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.UnsupportedAudioFileException;
import com.jogamp.openal.eax.EAX;
import com.jogamp.openal.eax.EAXFactory;
import com.jogamp.openal.test.resources.ResourceLocation;
import com.jogamp.openal.util.WAVData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class OpenALTest {
    private ALC alc = null;
    private ALCdevice device = null;
    private ALCcontext context = null;
    private AL al = null;
    private int[] sources = null;
    private boolean initialized = false;

    public void init() throws UnsupportedAudioFileException, IOException {
        boolean bl;
        Object object2;
        if (this.initialized) {
            return;
        }
        this.alc = ALFactory.getALC();
        this.device = this.alc.alcOpenDevice(null);
        this.context = this.alc.alcCreateContext(this.device, null);
        this.alc.alcMakeContextCurrent(this.context);
        this.al = ALFactory.getAL();
        System.out.println("output devices:");
        EAX eAX = this.alc.alcGetDeviceSpecifiers();
        if (null != eAX) {
            for (Object object2 : eAX) {
                System.out.println("    " + (String)object2);
            }
        }
        System.out.println("capture devices:");
        eAX = this.alc.alcGetCaptureDeviceSpecifiers();
        if (null != eAX) {
            for (Object object2 : eAX) {
                System.out.println("    " + (String)object2);
            }
        }
        EAX eAX2 = (bl = this.al.alIsExtensionPresent("EAX2.0")) ? EAXFactory.getEAX() : null;
        System.err.println("EAX present:" + bl + ", EAX retrieved: " + (null != eAX2));
        int[] nArray = new int[1];
        this.al.alGenBuffers(1, nArray, 0);
        WAVData wAVData = WAVData.loadFromStream((InputStream)ResourceLocation.getTestStream2(), (int)ResourceLocation.getTestStream2Size(), (int)2, (int)16, (int)44100, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (boolean)true);
        System.out.println("*** size " + wAVData.data.limit());
        this.al.alBufferData(nArray[0], wAVData.format, (Buffer)wAVData.data, wAVData.size, wAVData.freq);
        this.sources = new int[1];
        this.al.alGenSources(1, this.sources, 0);
        this.al.alSourcei(this.sources[0], 4105, nArray[0]);
        object2 = new int[1];
        this.al.alGetSourcei(this.sources[0], 4103, (int[])object2, 0);
        System.err.println("Looping 1: " + (object2[0] == true));
        int[] nArray2 = new int[1];
        this.al.alGetSourcei(this.sources[0], 4103, nArray2, 0);
        System.err.println("Looping 2: " + (nArray2[0] == 1));
        if (bl && null != eAX2) {
            IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
            intBuffer.put(3);
            eAX2.setListenerProperty(11, (Buffer)intBuffer);
        }
        this.initialized = true;
    }

    public void play() {
        if (!this.initialized) {
            return;
        }
        System.out.println("play direct");
        this.al.alSourceRewind(this.sources[0]);
        this.al.alSourcePlay(this.sources[0]);
    }

    public void play3f(float f, float f2, float f3) {
        if (!this.initialized) {
            return;
        }
        System.out.println("play3f " + f + ", " + f2 + ", " + f3);
        this.al.alSourceRewind(this.sources[0]);
        this.al.alSourcePlay(this.sources[0]);
        this.al.alSource3f(this.sources[0], 4100, f, f2, f3);
    }

    public void pause() {
        if (!this.initialized) {
            return;
        }
        this.al.alSourcePause(this.sources[0]);
    }

    public void dispose() {
        if (!this.initialized) {
            return;
        }
        if (null != this.sources) {
            this.al.alSourceStop(this.sources[0]);
            this.al.alDeleteSources(1, this.sources, 0);
            this.sources = null;
        }
        if (null != this.context) {
            this.alc.alcDestroyContext(this.context);
            this.context = null;
        }
        if (null != this.device) {
            this.alc.alcCloseDevice(this.device);
            this.device = null;
        }
        this.initialized = false;
    }

    public static void main(String[] stringArray) throws InterruptedException, UnsupportedAudioFileException, IOException {
        OpenALTest openALTest = new OpenALTest();
        openALTest.init();
        openALTest.play();
        Thread.sleep(5000L);
        openALTest.play3f(2.0f, 2.0f, 2.0f);
        Thread.sleep(5000L);
        openALTest.play3f(3.0f, 3.0f, 3.0f);
        Thread.sleep(5000L);
        openALTest.play3f(0.0f, 0.0f, 0.0f);
        Thread.sleep(5000L);
        openALTest.dispose();
    }
}

