/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.junit;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.test.resources.ResourceLocation;
import com.jogamp.openal.util.WAVData;
import com.jogamp.openal.util.WAVLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class ALExtLoopbackDeviceSOFTTest {
    @Test
    public void testAlCLoopbackDeviceSOFT() throws UnsupportedAudioFileException, IOException {
        ALC aLC = ALFactory.getALC();
        ALCdevice aLCdevice = aLC.alcOpenDevice(null);
        ALCcontext aLCcontext = aLC.alcCreateContext(aLCdevice, null);
        aLC.alcMakeContextCurrent(aLCcontext);
        AL aL = ALFactory.getAL();
        System.out.println("Available null device OpenAL Extensions:" + aLC.alcGetString(null, 4102));
        System.out.println("Available device OpenAL Extensions:" + aLC.alcGetString(aLCdevice, 4102));
        boolean bl = aLC.alcIsExtensionPresent(aLCdevice, "ALC_SOFT_loopback");
        Exception exception = null;
        ALExt aLExt = ALFactory.getALExt();
        if (!bl) {
            System.out.println("No extension ALC_SOFT_loopback present");
            try {
                aLCdevice = aLExt.alcLoopbackOpenDeviceSOFT(null);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            Assert.assertNotNull((Object)exception);
            return;
        }
        System.out.println("begin testAlCLoopbackDeviceSOFT");
        int[] nArray = new int[1];
        aLCdevice = aLExt.alcLoopbackOpenDeviceSOFT(null);
        Assert.assertNotNull((Object)aLCdevice);
        WAVData wAVData = null;
        try {
            wAVData = WAVLoader.loadFromStream((InputStream)ResourceLocation.getTestStream0());
            aLCcontext = aLC.alcCreateContext(aLCdevice, new int[]{6544, 5376, 6545, 5121, 4103, wAVData.freq, 0}, 0);
            boolean bl2 = aLC.alcMakeContextCurrent(aLCcontext);
            Assert.assertTrue((boolean)bl2);
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        Assert.assertNull((Object)exception);
        exception = null;
        aL.alGenBuffers(1, nArray, 0);
        aL.alBufferData(nArray[0], wAVData.format, (Buffer)wAVData.data, wAVData.size, wAVData.freq);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(wAVData.size).order(wAVData.data.order());
        try {
            aLExt.alcRenderSamplesSOFT(aLCdevice, (Buffer)byteBuffer, wAVData.size);
        }
        catch (Exception exception4) {
            exception = exception4;
        }
        Assert.assertNull((Object)exception);
        for (int i = 0; i < wAVData.size; ++i) {
            byte by = wAVData.data.get(i);
            byte by2 = byteBuffer.get(i);
            Assert.assertEquals((long)by, (long)by2);
        }
        System.out.println("end testAlCLoopbackDeviceSOFT");
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main((String[])new String[]{ALExtLoopbackDeviceSOFTTest.class.getName()});
    }
}

