/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.util.Rectangle;
import javax.media.nativewindow.util.RectangleImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode01cNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long waitTimeShort;
    static long duration;

    @BeforeClass
    public static void initClass() {
        TestScreenMode01cNEWT.setResetXRandRIfX11AfterClass();
        width = 200;
        height = 200;
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(waitTimeShort);
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, String string, int n, int n2, int n3, int n4) throws InterruptedException {
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle(string);
        gLWindow.setPosition(n, n2);
        gLWindow.setSize(n3, n4);
        gLWindow.addGLEventListener((GLEventListener)new GearsES2());
        Assert.assertNotNull((Object)gLWindow);
        long l = System.currentTimeMillis();
        gLWindow.setVisible(true);
        System.err.println("Time for visible/pos: " + (System.currentTimeMillis() - l) + " ms");
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(window, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScreenFullscreenSingleQ1() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        screen.addReference();
        try {
            RectangleImmutable rectangleImmutable = ((MonitorDevice)screen.getMonitorDevices().get(0)).getViewport();
            this.testScreenFullscreenImpl(screen, rectangleImmutable.getX(), rectangleImmutable.getY(), false, null);
        }
        finally {
            screen.removeReference();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScreenFullscreenSingleQ2() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        screen.addReference();
        try {
            if (2 > screen.getMonitorDevices().size()) {
                System.err.println("Test Disabled (1): Monitor count < 2: " + screen);
                return;
            }
            RectangleImmutable rectangleImmutable = ((MonitorDevice)screen.getMonitorDevices().get(1)).getViewport();
            this.testScreenFullscreenImpl(screen, rectangleImmutable.getX(), rectangleImmutable.getY(), false, null);
        }
        finally {
            screen.removeReference();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScreenFullscreenSpanQ1Q2() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        screen.addReference();
        try {
            int n = screen.getMonitorDevices().size();
            if (2 >= n) {
                System.err.println("Test Disabled (2): Spanning monitor count 2 >= screen monitor count: " + screen);
                return;
            }
            ArrayList<MonitorDevice> arrayList = new ArrayList<MonitorDevice>();
            arrayList.add((MonitorDevice)screen.getMonitorDevices().get(0));
            arrayList.add((MonitorDevice)screen.getMonitorDevices().get(1));
            RectangleImmutable rectangleImmutable = ((MonitorDevice)screen.getMonitorDevices().get(0)).getViewport();
            this.testScreenFullscreenImpl(screen, rectangleImmutable.getX() + 50, rectangleImmutable.getY() + 50, true, arrayList);
        }
        finally {
            screen.removeReference();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScreenFullscreenSpanALL() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        screen.addReference();
        try {
            if (2 > screen.getMonitorDevices().size()) {
                System.err.println("Test Disabled (3): Monitor count < 2: " + screen);
                return;
            }
            RectangleImmutable rectangleImmutable = ((MonitorDevice)screen.getMonitorDevices().get(1)).getViewport();
            this.testScreenFullscreenImpl(screen, rectangleImmutable.getX() - 50, rectangleImmutable.getY() + 50, true, null);
        }
        finally {
            screen.removeReference();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        }
    }

    void testScreenFullscreenImpl(Screen screen, int n, int n2, boolean bl, List<MonitorDevice> list) throws InterruptedException {
        Thread.sleep(waitTimeShort);
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = screen.getDisplay();
        System.err.println("Test.0: Window screen: " + screen);
        System.err.println("Test.0: Window bounds (pre): " + n + "/" + n2 + " " + width + "x" + height + " within " + screen.getViewport());
        GLWindow gLWindow = TestScreenMode01cNEWT.createWindow(screen, gLCapabilities, "win0", n, n2, width, height);
        Assert.assertNotNull((Object)gLWindow);
        System.err.println("Test.0: Window bounds: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + " within " + screen.getViewport());
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.start();
        List list2 = screen.getMonitorModes();
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        MonitorDevice monitorDevice = gLWindow.getMainMonitor();
        System.err.println("Test.0: Window monitor: " + monitorDevice);
        if (!bl) {
            gLWindow.setFullscreen(true);
        } else {
            gLWindow.setFullscreen(list);
        }
        monitorDevice = gLWindow.getMainMonitor();
        System.err.println("Test.1: Window bounds: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + " within " + screen.getViewport());
        System.err.println("Test.1: Window monitor: " + monitorDevice.getViewport());
        Rectangle rectangle = new Rectangle(gLWindow.getX(), gLWindow.getY(), gLWindow.getWidth(), gLWindow.getHeight());
        if (!bl) {
            Assert.assertEquals((Object)monitorDevice.getViewport(), (Object)rectangle);
        } else {
            List list3 = list;
            if (null == list3) {
                list3 = gLWindow.getScreen().getMonitorDevices();
            }
            Rectangle rectangle2 = MonitorDevice.unionOfViewports((Rectangle)new Rectangle(), (List)list3);
            Assert.assertEquals((Object)rectangle2, (Object)rectangle);
        }
        Thread.sleep(duration);
        gLWindow.setFullscreen(false);
        rectangle = new Rectangle(gLWindow.getX(), gLWindow.getY(), gLWindow.getWidth(), gLWindow.getHeight());
        monitorDevice = gLWindow.getMainMonitor();
        System.err.println("Test.2: Window bounds: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + " within " + screen.getViewport());
        System.err.println("Test.2: Window monitor: " + monitorDevice.getViewport());
        Thread.sleep(duration);
        animator.stop();
        TestScreenMode01cNEWT.destroyWindow((Window)gLWindow);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        String string = TestScreenMode01cNEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        waitTimeShort = 2000L;
        duration = 4000L;
    }
}

