/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.newt.Screen;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es1.GearsES1;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLWindowInvisiblePointer01NEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
    }

    static GLWindow createWindow(Screen screen, GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException {
        GLWindow gLWindow;
        Assert.assertNotNull((Object)gLCapabilitiesImmutable);
        if (null != screen) {
            gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilitiesImmutable);
            Assert.assertNotNull((Object)gLWindow);
        } else {
            gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
            Assert.assertNotNull((Object)gLWindow);
        }
        gLWindow.setUpdateFPSFrames(1, null);
        GearsES1 gearsES1 = new GearsES1();
        gLWindow.addGLEventListener((GLEventListener)gearsES1);
        gLWindow.setSize(512, 512);
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        return gLWindow;
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
            Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        }
    }

    @Test
    public void testWindow00() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = TestGLWindowInvisiblePointer01NEWT.createWindow(null, (GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        Animator animator = new Animator();
        animator.setUpdateFPSFrames(1, null);
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
        AbstractGraphicsDevice abstractGraphicsDevice = gLWindow.getScreen().getDisplay().getGraphicsDevice();
        System.err.println("GLProfiles window1: " + abstractGraphicsDevice.getConnection() + ": " + GLProfile.glAvailabilityToString((AbstractGraphicsDevice)abstractGraphicsDevice));
        gLWindow.warpPointer(width / 2, height / 2);
        gLWindow.requestFocus();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            boolean bl = animator.getTotalFPSDuration() / 100L % 2L == 0L;
            gLWindow.setPointerVisible(bl);
            Assert.assertEquals((Object)bl, (Object)gLWindow.isPointerVisible());
            Thread.sleep(100L);
        }
        TestGLWindowInvisiblePointer01NEWT.destroyWindow(gLWindow);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestGLWindowInvisiblePointer01NEWT.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestGLWindowInvisiblePointer01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 4000L;
    }
}

