/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.tile;

import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.jogl.tile.PrintableBase;
import com.jogamp.opengl.test.junit.jogl.tile.TiledPrintingAWTBase;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTiledPrintingGearsAWT
extends TiledPrintingAWTBase {
    static boolean waitForKey = false;
    static boolean allow600dpi = false;
    static GLProfile glp;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2")) {
            glp = GLProfile.get((String)"GL2");
            Assert.assertNotNull((Object)glp);
            width = 640;
            height = 480;
        } else {
            TestTiledPrintingGearsAWT.setTestSupported(false);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws InterruptedException, InvocationTargetException {
        Dimension dimension = new Dimension(width / 2, height);
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.setMinimumSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        gLCanvas.setSize(dimension);
        gLCanvas.addGLEventListener((GLEventListener)new Gears());
        GLCanvas gLCanvas2 = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas2);
        gLCanvas2.setMinimumSize(dimension);
        gLCanvas2.setPreferredSize(dimension);
        gLCanvas2.setSize(dimension);
        gLCanvas2.addGLEventListener((GLEventListener)new RedSquareES2());
        final Panel panel = new Panel();
        panel.add((Component)gLCanvas);
        panel.add((Component)gLCanvas2);
        final Frame frame = new Frame("AWT Print");
        Assert.assertNotNull((Object)frame);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTiledPrintingGearsAWT.this.doPrintManual(frame, 72, 0, -1, -1);
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTiledPrintingGearsAWT.this.doPrintManual(frame, 300, -1, -1, -1);
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTiledPrintingGearsAWT.this.doPrintManual(frame, 600, -1, -1, -1);
            }
        };
        Button button = new Button("72dpi");
        button.addActionListener(actionListener);
        Button button2 = new Button("300dpi");
        button2.addActionListener(actionListener2);
        Button button3 = new Button("600dpi");
        button3.addActionListener(actionListener3);
        frame.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel2.add(button);
        panel2.add(button2);
        panel2.add(button3);
        Panel panel3 = new Panel();
        panel3.add(new Label("South"));
        Panel panel4 = new Panel();
        panel4.add(new Label("East"));
        Panel panel5 = new Panel();
        panel5.add(new Label("West"));
        frame.add((Component)panel2, "North");
        frame.add((Component)panel, "Center");
        frame.add((Component)panel3, "South");
        frame.add((Component)panel4, "East");
        frame.add((Component)panel5, "West");
        frame.setTitle("Tiles AWT Print Test");
        Animator animator = new Animator();
        animator.add((GLAutoDrawable)gLCanvas);
        animator.add((GLAutoDrawable)gLCanvas2);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter((KeyListener)quitAdapter)).addTo((Component)gLCanvas);
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter((KeyListener)quitAdapter)).addTo((Component)gLCanvas2);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter((WindowListener)quitAdapter)).addTo((Component)frame);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(frame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas2, true));
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        boolean bl = false;
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && (0L == duration || animator.getTotalFPSDuration() < duration)) {
            Thread.sleep(200L);
            if (bl) continue;
            bl = true;
            PrintableBase printableBase = this.doPrintAuto(frame, 0, null, -1, 72, 0, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto(frame, 0, null, -1, 72, 8, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto(frame, 0, null, -1, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto(frame, 0, null, -1, 150, -1, 2048, 2048, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto(frame, 0, null, -1, 150, -1, -1, -1, true);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto(frame, 0, null, 3, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto(frame, 0, null, 3, 150, -1, -1, -1, true);
            this.waitUntilPrintJobsIdle(printableBase);
            if (!allow600dpi) continue;
            printableBase = this.doPrintAuto(frame, 0, null, -1, 600, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
        }
        Assert.assertNotNull((Object)frame);
        Assert.assertNotNull((Object)gLCanvas);
        Assert.assertNotNull((Object)gLCanvas2);
        Assert.assertNotNull((Object)animator);
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Frame frame2 = frame;
                frame2.remove(panel);
                frame2.dispose();
            }
        });
    }

    @Test
    public void test01_aa0() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test02_aa8() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(8);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    duration = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-600dpi")) {
                allow600dpi = true;
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        if (waitForKey) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main((String[])new String[]{TestTiledPrintingGearsAWT.class.getName()});
    }

    static {
        duration = 500L;
    }
}

