/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glu;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelStorageModes;
import java.awt.Component;
import java.awt.Frame;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug694ScaleImageUnpackBufferSizeAWT
extends UITestCase
implements GLEventListener {
    boolean testDone = false;

    public void init(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.testDone) {
            this.testDone = true;
            GL gL = gLAutoDrawable.getGL();
            GLU gLU = GLU.createGLU((GL)gL);
            this.testGLUScaleImage(gL, gLU, 0);
            this.testGLUScaleImage(gL, gLU, 1);
            this.testGLUScaleImage(gL, gLU, 4);
            this.testGLUScaleImage(gL, gLU, 8);
            gLU.destroy();
        }
    }

    private void testGLUScaleImage(GL gL, GLU gLU, int n) {
        GLPixelStorageModes gLPixelStorageModes = new GLPixelStorageModes(gL);
        if (0 < n) {
            gLPixelStorageModes.setUnpackAlignment(gL, n);
        }
        int[] nArray = new int[1];
        int n2 = GLBuffers.sizeof((GL)gL, (int[])nArray, (int)6409, (int)5121, (int)213, (int)213, (int)1, (boolean)false);
        int n3 = GLBuffers.sizeof((GL)gL, (int[])nArray, (int)6409, (int)5121, (int)256, (int)256, (int)1, (boolean)false);
        System.err.println("Unpack-Alignment " + n + ":  in-size " + n2);
        System.err.println("Unpack-Alignment " + n + ": out-size " + n3);
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)n2);
        ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer((int)n3);
        gLU.gluScaleImage(6409, 213, 213, 5121, (Buffer)byteBuffer, 256, 256, 5121, (Buffer)byteBuffer2);
        gLPixelStorageModes.restore(gL);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    @Test
    public void test01() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        gLCanvas.addGLEventListener((GLEventListener)this);
        final Frame frame = new Frame("Test");
        frame.add((Component)gLCanvas);
        frame.setSize(256, 256);
        frame.validate();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        gLCanvas.display();
        Thread.sleep(200L);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug694ScaleImageUnpackBufferSizeAWT.class.getName()});
    }
}

