/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl3.newt;

import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.gl3.GeomShader01TextureGL3;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGeomShader01TextureGL3NEWT
extends UITestCase {
    static long duration = 500L;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get((String)string));
    }

    @Test
    public void test01_GL3Core_Passthrough() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGeomShader01TextureGL3NEWT.getCaps("GL3");
        if (null == gLCapabilities) {
            return;
        }
        this.testImpl(gLCapabilities, 0);
    }

    @Test
    public void test02_GL3Core_FlipXYZ() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGeomShader01TextureGL3NEWT.getCaps("GL3");
        if (null == gLCapabilities) {
            return;
        }
        this.testImpl(gLCapabilities, 1);
    }

    @Test
    public void test11_GL3Compat_Passthrough() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGeomShader01TextureGL3NEWT.getCaps("GL3bc");
        if (null == gLCapabilities) {
            return;
        }
        this.testImpl(gLCapabilities, 0);
    }

    @Test
    public void test12_GL3Compat_FlipXYZ() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGeomShader01TextureGL3NEWT.getCaps("GL3bc");
        if (null == gLCapabilities) {
            return;
        }
        this.testImpl(gLCapabilities, 1);
    }

    private void testImpl(GLCapabilities gLCapabilities, int n) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setSize(800, 600);
        gLWindow.setVisible(true);
        gLWindow.setTitle("JOGL Geometry Shader Banana Test");
        Assert.assertTrue((boolean)gLWindow.isNativeValid());
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.addGLEventListener((GLEventListener)new GeomShader01TextureGL3(n));
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener((GLEventListener)snapshotGLEventListener);
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.start();
        animator.setUpdateFPSFrames(60, System.err);
        snapshotGLEventListener.setMakeSnapshot();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestGeomShader01TextureGL3NEWT.class.getName()});
    }
}

